/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DocumentDigestImpl
implements DocumentDigest,
Serializable {
    private static final long serialVersionUID = 3015221028590796750L;
    private byte[] digest = null;
    private transient MessageDigest messageDigest = null;
    private transient DigestInputStream inputFilter = null;
    private transient DigestOutputStream outputFilter = null;
    private static TraceComponent tc = Tr.register(DocumentDigestImpl.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");

    DocumentDigestImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DocumentDigestImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DocumentDigestImpl");
        }
    }

    DocumentDigestImpl(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DocumentDigestImpl(data)");
        }
        this.calc(data);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DocumentDigestImpl(data)");
        }
    }

    DocumentDigestImpl(InputStream input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DocumentDigestImpl(stream)");
        }
        this.calc(input);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DocumentDigestImpl(stream)");
        }
    }

    DocumentDigestImpl(MessageDigest md) {
        this.digest = md.digest();
    }

    protected byte[] getDigest() {
        return this.digest;
    }

    protected void calc(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "calc(byte[])");
        }
        MessageDigest messageDigest = null;
        messageDigest = this.getMessageDigest();
        if (messageDigest != null) {
            messageDigest.update(data);
            this.digest = messageDigest.digest();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "calc(byte[])", this.digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void calc(InputStream input) {
        block12: {
            block11: {
                int bytesRead;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "calc(stream)");
                }
                byte[] buffer = new byte[4096];
                MessageDigest messageDigest = null;
                messageDigest = this.getMessageDigest();
                if (messageDigest == null) break block11;
                while ((bytesRead = input.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, bytesRead);
                }
                this.digest = messageDigest.digest();
            }
            Object var6_6 = null;
            try {
                input.close();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"114", (Object)this);
            }
            break block12;
            {
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"113", (Object)this);
                    Tr.service(tc, "ADMR0200E", ioe);
                    Object var6_7 = null;
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"114", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    input.close();
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"114", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "calc(stream)", this.digest);
        }
    }

    public boolean equals(Object d) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(digest)");
        }
        boolean result = false;
        if (d != null && this.getClass().isInstance(d)) {
            DocumentDigestImpl di = (DocumentDigestImpl)d;
            result = this.compareDigestBytes(di.getDigest());
        } else {
            if (d == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "arg is null");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "arg is of type " + d.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(digest): " + result);
        }
        return result;
    }

    public boolean equals(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(byte[])");
        }
        boolean result = this.equals(new DocumentDigestImpl(data));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(byte[]): " + result);
        }
        return result;
    }

    public boolean equals(InputStream input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(stream)");
        }
        boolean result = this.equals(new DocumentDigestImpl(input));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(stream): " + result);
        }
        return result;
    }

    public String toString() {
        int val = 0;
        String hexString = new String();
        if (this.digest != null) {
            for (int i = 0; i < this.digest.length; ++i) {
                val = this.digest[i] < 0 ? this.digest[i] + 256 : this.digest[i];
                hexString = hexString + Integer.toString(val / 16, 16) + Integer.toString(val % 16, 16);
            }
        }
        return hexString;
    }

    private boolean compareDigestBytes(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareDigestBytes");
        }
        boolean result = true;
        if (this.digest != null && data != null && this.digest.length == data.length) {
            for (int i = 0; i < this.digest.length; ++i) {
                if (this.digest[i] == data[i]) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareDigestBytes: " + result);
        }
        return result;
    }

    private MessageDigest getMessageDigest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageDigest");
        }
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.getMessageDigest", (String)"227", (Object)this);
                Tr.error(tc, "ADMR0201E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageDigest");
        }
        return this.messageDigest;
    }

    protected InputStream startInputFilter(InputStream input) {
        this.inputFilter = new DigestInputStream(input, this.getMessageDigest());
        return this.inputFilter;
    }

    protected void stopInputFilter() {
        if (this.messageDigest != null) {
            this.digest = this.messageDigest.digest();
        }
        try {
            if (this.inputFilter != null) {
                this.inputFilter.close();
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"284", (Object)this);
        }
    }

    protected OutputStream startOutputFilter(OutputStream output) {
        this.outputFilter = new DigestOutputStream(output, this.getMessageDigest());
        return this.outputFilter;
    }

    protected void stopOutputFilter() {
        if (this.messageDigest != null) {
            this.digest = this.messageDigest.digest();
        }
        try {
            if (this.outputFilter != null) {
                this.outputFilter.close();
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.DocumentDigestImpl.calc", (String)"310", (Object)this);
        }
    }
}

