/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.ws.management.repository.RepositoryLock;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;

public class DefaultRepositoryLock
implements RepositoryLock {
    private static TraceComponent tc = Tr.register(DefaultRepositoryLock.class, "RepositoryLock", "com.ibm.ws.management.resources.repository");
    private boolean repositoryLocked = false;
    private static DefaultRepositoryLock repositoryLock = new DefaultRepositoryLock();

    private DefaultRepositoryLock() {
    }

    public static DefaultRepositoryLock getRepositoryLock() {
        String uuid = AdminContext.peek();
        if (uuid != null) {
            return DefaultRepositoryLock.getRepositoryLock(uuid);
        }
        return repositoryLock;
    }

    private static DefaultRepositoryLock getRepositoryLock(String profileKey) {
        DefaultRepositoryLock remoteRepositoryLock;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRepositoryLock with AdminContext:" + profileKey);
        }
        if ((remoteRepositoryLock = (DefaultRepositoryLock)AdminSubsystemServiceRegistry.getService((String)DefaultRepositoryLock.class.getName())) == null) {
            remoteRepositoryLock = new DefaultRepositoryLock();
            AdminSubsystemServiceRegistry.addService((String)DefaultRepositoryLock.class.getName(), (Object)remoteRepositoryLock);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRepositoryLock");
        }
        return remoteRepositoryLock;
    }

    public boolean isLockOwner() {
        return false;
    }

    public boolean isRepositoryLocked() {
        return this.repositoryLocked;
    }

    public synchronized boolean lockRepository() {
        if (!this.repositoryLocked) {
            this.repositoryLocked = true;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The RepositoryLock is LOCKED.");
            }
            return true;
        }
        return false;
    }

    public boolean lockRepository(Object lockToken) {
        return false;
    }

    public synchronized boolean unlockRepository() {
        if (this.repositoryLocked) {
            this.repositoryLocked = false;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The RepositoryLock is UNLOCKED.");
            }
            return true;
        }
        return false;
    }

    public boolean unlockRepository(Object lockToken) {
        return false;
    }
}

