/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.websphere.management.repository.ResourceNameFilter;

public class ConfigurableResourceNameFilter
implements ResourceNameFilter {
    private String filter;
    private boolean endsWithFilter = false;
    private boolean startsWithFilter = false;

    public ConfigurableResourceNameFilter(String inFilter) {
        this.filter = inFilter;
        if (this.filter != null && !this.filter.equals("")) {
            if (this.filter.startsWith("*")) {
                this.endsWithFilter = true;
                this.filter = this.filter.substring(1);
            } else if (this.filter.endsWith("*")) {
                this.startsWithFilter = true;
                this.filter = this.filter.substring(0, this.filter.length() - 1);
            }
        }
    }

    public boolean accept(String parent, String name) {
        String path = parent + "/" + name;
        if (this.startsWithFilter && path.startsWith(this.filter)) {
            return true;
        }
        if (this.endsWithFilter && path.endsWith(this.filter)) {
            return true;
        }
        return !this.startsWithFilter && !this.endsWithFilter && path.equals(this.filter);
    }
}

