/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.provisioning;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.management.provisioning.AdminServerActivationHelper;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.provisioning.ComponentInfo;
import com.ibm.wsspi.runtime.provisioning.ServerActivation;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServerActivationPlan
implements ServerActivation {
    private static final String ADMIN_AGENT_ACTIVATION_COMPONENTS_EXT_PT = "admin-agent-components";
    private static final String DMZ_ADMIN_AGENT_ACTIVATION_COMPONENTS_EXT_PT = "dmz-admin-agent-components";
    private static final String JOB_MANAGER_ACTIVATION_COMPONENTS_EXT_PT = "job-manager-components";
    private static final String ADMIN_AGENT = "ADMIN_AGENT";
    private static final String JOB_MANAGER = "JOB_MANAGER";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ComponentInfo> getActivationPlan() throws RuntimeError {
        String extensionPointId;
        block21: {
            String serverType;
            block20: {
                String prodName;
                block19: {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("Begin AdminServerActivationPlan.getActivationPlan()");
                    }
                    serverType = AdminServerActivationHelper.getServerType();
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("serverType - " + serverType);
                    }
                    if (!serverType.equals(ADMIN_AGENT)) break block20;
                    Properties mProps = new Properties();
                    prodName = null;
                    InputStream inStream = null;
                    ConfigService configservice2 = (ConfigService)WsServiceRegistry.getService(AdminServerActivationHelper.class, ConfigService.class);
                    String nodeName = configservice2.getNodeName();
                    LoggingServices.out.println(" node =" + nodeName);
                    String cellName = configservice2.getCellName();
                    String path = configservice2.getPath() + "/cells/" + cellName + "/nodes/" + nodeName + "/node-metadata.properties";
                    LoggingServices.out.println(" path =" + path);
                    inStream = new FileInputStream(path);
                    Properties props = new Properties();
                    props.load(inStream);
                    LoggingServices.out.println("props: " + props);
                    prodName = props.getProperty("com.ibm.websphere.baseProductShortName");
                    LoggingServices.out.println("prodname: " + prodName);
                    Object var12_12 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                        break block19;
                    }
                    catch (IOException e2) {}
                    break block19;
                    {
                        catch (AdminException e) {
                            LoggingServices.out.println("Faled to retrieve product name" + e);
                            prodName = null;
                            Object var12_13 = null;
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                                break block19;
                            }
                            catch (IOException e2) {}
                            break block19;
                        }
                        catch (Exception e) {
                            LoggingServices.out.println("Faled to retrieve product name" + e);
                            prodName = null;
                            Object var12_14 = null;
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                                break block19;
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                extensionPointId = prodName != null && prodName.equals("NDDMZ") ? ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + DMZ_ADMIN_AGENT_ACTIVATION_COMPONENTS_EXT_PT : ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + ADMIN_AGENT_ACTIVATION_COMPONENTS_EXT_PT;
                break block21;
            }
            if (serverType.equals(JOB_MANAGER)) {
                extensionPointId = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + JOB_MANAGER_ACTIVATION_COMPONENTS_EXT_PT;
            } else {
                return null;
            }
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("Exit AdminServerActivationPlan.getActivationPlan()");
        }
        LoggingServices.out.println("extensionPointId" + extensionPointId);
        return AdminServerActivationHelper.getComponents(extensionPointId);
    }
}

