/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.component.MVSServices;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.management.launcher.ProcessTerminator;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.nodeagent.MonitorConfig;
import com.ibm.ws.management.nodeagent.NodeAgentDiagnosticHelper;
import com.ibm.ws.management.nodeagent.PidWaiter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.xcf.common.plugin.GenJoinEventListener;
import com.ibm.ws.xcf.common.plugin.GenLeaveEventListener;
import com.ibm.ws.xcf.common.plugin.GenLivenessPlugin;
import com.ibm.ws.xcf.common.plugin.GenLivenessPluginFactory;
import com.ibm.wsspi.management.profile.ProfileUtility;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class NodeAgent
extends RuntimeCollaborator
implements NotificationListener,
PropertyChangeListener,
DiagnosticProvider,
AlarmListener {
    private static final String resBundleName = "com.ibm.ws.management.resources.launcher";
    public static String BUNDLE_NAME = "com.ibm.ws.management.resources.nodeutils";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.launcher");
    private static TraceComponent tc = Tr.register(NodeAgent.class, "Admin", "com.ibm.ws.management.resources.launcher");
    String myXCFMemberName;
    String myXCFGroup;
    Integer myXCFcheckInterval;
    String myXCFHostCellNode;
    GenLivenessPlugin lp;
    private static Integer CHECK_ALARM_CONTEXT = new Integer(2);
    private static String XCF_CHECK_INTERVAL_PROP = "com.ibm.websphere.management.xcfcheck.interval";
    private Alarm checkAlarm;
    private String monitorFile;
    private static final Integer DISCOVERY_LISTENER = new Integer(0);
    private static final Integer STOPPING_LISTENER = new Integer(1);
    private static final String DEFAULT_LAUNCH_TIMEOUT = "1200";
    private static final String DEFAULT_LAUNCH_TIMEOUT_ZOS = "600";
    private static final Integer DEFAULT_LAUNCH_TIMEOUT_INTEGER = new Integer("1200");
    private static final Integer DEFAULT_LAUNCH_TIMEOUT_INTEGER_ZOS = new Integer("600");
    private static Logger nodeAgentLogger = Logger.getLogger(NodeAgent.class.getName(), "com.ibm.ws.management.resources.launcher");
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private static final String DIAGNOSTIC_BUNDLE = "com.ibm.ws.management.resources.DiagnosticProviderText";
    private static NodeAgent instance;
    private boolean isInitialized;
    private MBeanFactory mbeanFactory;
    private AdminService adminService;
    private VariableMap variableMap;
    private ConfigService configService;
    private String cellName;
    private String nodeName;
    private long ntfySeqNum;
    private HashMap adoptedChildren;
    private HashMap launchedChildren;
    private HashMap processHandlers;
    private HashMap monitoringPolicies;
    private boolean isRipple;
    private String ownPid;
    private boolean ZOS;
    private StatusCache nacache;
    private String profileKey;
    private HashMap serverConnectorType;
    private HashMap pidWaiterHashMap;
    private DiagnosticProviderInfo dpInfo;
    public static final String sDPName = "NodeAgentDP";
    private static final Integer SYNC_LISTENER;
    private static boolean isSyncInProgress;
    private boolean isRestartingAllServers;
    private boolean isBeingCalledByStopNodeMethod;
    private boolean isBeingCalledByRestartMethod;
    private boolean crosslpar;
    private boolean xcfMonitor_Enabled;
    String theXCFGroup;
    private long lastXCFContext;

    public NodeAgent() {
        block19: {
            this.myXCFMemberName = null;
            this.myXCFGroup = null;
            this.myXCFcheckInterval = new Integer(60);
            this.myXCFHostCellNode = null;
            this.lp = null;
            this.checkAlarm = null;
            this.monitorFile = "${LOG_ROOT}/nodeagent/monitor.state";
            this.adminService = null;
            this.ntfySeqNum = 0L;
            this.adoptedChildren = new HashMap();
            this.launchedChildren = new HashMap();
            this.processHandlers = new HashMap();
            this.monitoringPolicies = new HashMap();
            this.isRipple = false;
            this.ownPid = null;
            this.ZOS = false;
            this.nacache = null;
            this.profileKey = null;
            this.serverConnectorType = new HashMap();
            this.pidWaiterHashMap = new HashMap();
            this.dpInfo = null;
            this.isRestartingAllServers = false;
            this.isBeingCalledByStopNodeMethod = false;
            this.isBeingCalledByRestartMethod = false;
            this.crosslpar = false;
            this.xcfMonitor_Enabled = false;
            this.theXCFGroup = "TheXCFGroup";
            this.lastXCFContext = -1L;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgent constructor, ZOS = " + AdminHelper.getPlatformHelper().isZOS());
            }
            this.profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminContext: " + this.profileKey);
            }
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.ZOS = true;
            }
            this.nacache = StatusCacheFactory.getStatusCache();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nacache = " + this.nacache);
            }
            if (this.ZOS) {
                String naprofileKey;
                block18: {
                    naprofileKey = null;
                    if (AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
                        try {
                            naprofileKey = ProfileUtility.getUUID();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "NA profileKey: " + naprofileKey);
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent", (String)"338", (Object)this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "na profileKey not found. Exception " + e.getMessage());
                        }
                    }
                }
                String cellName = AdminServiceFactory.getAdminService().getCellName();
                String nodeName = AdminServiceFactory.getAdminService().getNodeName();
                this.myXCFHostCellNode = "MyHost" + cellName + nodeName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "myXCFHostCellNode: " + this.myXCFHostCellNode);
                }
                RoutingTable rt = RoutingTable.getInstance();
                this.xcfMonitor_Enabled = rt.isXCFMonitorEnabled();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "xcfMonitor_Enabled: " + this.xcfMonitor_Enabled);
                }
                if (this.xcfMonitor_Enabled) {
                    boolean isAdminAgent = AdminServiceFactory.getAdminService().getProcessType().equals("AdminAgent");
                    if (isAdminAgent) {
                        this.myXCFMemberName = this.myXCFHostCellNode + "adminagent";
                        this.myXCFGroup = this.theXCFGroup + this.profileKey;
                    } else {
                        this.myXCFMemberName = this.myXCFHostCellNode + "nodeagent";
                        this.myXCFGroup = this.theXCFGroup + naprofileKey;
                    }
                    this.myXCFcheckInterval = Integer.getInteger(XCF_CHECK_INTERVAL_PROP, 60);
                    this.useXCFMonitor();
                }
            }
            if (this.profileKey != null) {
                try {
                    String aaProcessName = AdminServiceFactory.getAdminService().getProcessName();
                    VariableMap variableMap = (VariableMap)WsServiceRegistry.getService((Object)this, VariableMap.class);
                    String logRoot = variableMap.expand("${LOG_ROOT}");
                    this.monitorFile = logRoot + "/" + aaProcessName + "/monitor-" + this.profileKey + ".state";
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "MonitorFile could not be assigned " + e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgent constructor");
        }
    }

    void initialize(ConfigService configService, VariableMap variableMap, ThreadPoolMgr tpMgr) {
        AdminService as;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (this.isInitialized) {
            Tr.exit(tc, "initialize - done");
            return;
        }
        this.configService = configService;
        this.variableMap = variableMap;
        this.cellName = AdminServiceFactory.getAdminService().getCellName();
        this.nodeName = AdminServiceFactory.getAdminService().getNodeName();
        this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
        Properties diagnosticProps = new Properties();
        diagnosticProps.setProperty("diagnosticProvider", "true");
        try {
            this.mbeanFactory.activateMBean("NodeAgent", this, "NodeAgent", null, diagnosticProps);
        }
        catch (AdminException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.management.nodeagent.NodeAgent.initialize", (String)"171", (Object)this);
        }
        this.discoveryMBeanListenerRegistration();
        this.listenForJ2EEStateStoppingNotifications();
        this.listenForSyncStartAndCompleteNofications();
        this.loadMonitoringPolicies();
        if (AdminContext.peek() == null) {
            DiagnosticProviderHelper.registerMBeanWithDiagnosticService(sDPName, this.getObjectName());
        }
        this.isInitialized = true;
        instance = this;
        if (this.ZOS && (as = AdminServiceFactory.getAdminService()) != null) {
            String localServerType = as.getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localServerType: " + localServerType);
            }
            if (localServerType != null && !localServerType.equals("ADMIN_AGENT")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Check if enabled and activate the MVSServices Mbean.");
                }
                this.createMVSServicesMBean();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void initialize(Repository repository2, VariableMap variableMap, ThreadPoolMgr tpMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize with endpoint UUID " + AdminContext.peek());
        }
        if (this.isInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - done");
            }
            return;
        }
        ConfigService cfgService = ConfigServiceFactory.createConfigService((String)repository2.getRootURI(), (String)repository2.getCellName(), (String)repository2.getNodeName(), (String)repository2.getServerName(), (String)repository2.getClusterName());
        this.initialize(cfgService, variableMap, tpMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public static NodeAgent getInstance() {
        return instance;
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    private String getPid(String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPid", serverName);
        }
        String pidType = "<null>";
        String pid = this.getAdoptedChildPid(serverName);
        if (pid == null) {
            pid = this.getLaunchedChildPid(serverName);
            if (pid == null) {
                pid = this.getFilePid(serverName);
                if (pid != null) {
                    pidType = "file";
                }
            } else {
                pidType = "launched";
            }
        } else {
            pidType = "adopted";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPid", new String[]{"pid=" + pid, "pidType=" + pidType});
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean terminate(String serverName) throws AdminException {
        boolean status;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate", serverName);
        }
        if (serverName != null) {
            String lock;
            String string = lock = serverName.intern();
            synchronized (string) {
                status = this.terminatePrivate(serverName);
            }
        } else {
            status = this.terminatePrivate(serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate", new Object[]{serverName, status});
        }
        return status;
    }

    public boolean terminatePrivate(String serverName) throws AdminException {
        String pid2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminatePrivate", serverName);
        }
        try {
            if (this.getProcessStatus(serverName).equals("STOPPED")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminatePrivate", "true");
                }
                this.sendNotification("websphere.process.stopped", serverName);
                return true;
            }
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Threw exception " + t.getMessage());
            }
            throw Utils.makeAdminException(t);
        }
        Process p = null;
        boolean result = false;
        String processName = serverName;
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.getRepositoryRootURI());
        sid.setServerName(processName);
        sid.setNodeName(this.nodeName);
        sid.setCellName(this.cellName);
        PidWaiter pidWaiter = null;
        if (this.pidWaiterHashMap.containsKey(serverName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + serverName + " in pidWaiterHashMap");
            }
            pidWaiter = (PidWaiter)this.pidWaiterHashMap.get(serverName);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did NOT find " + serverName + " in pidWaiterHashMap");
        }
        boolean launchedProcess = false;
        String pid = this.getPid(processName);
        if (pid != null && (pid2 = this.getLaunchedChildPid(processName)) != null) {
            launchedProcess = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pid in launched set is " + pid);
            }
        }
        if (this.ZOS) {
            Process terminatedProcess = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "terminating ZOS process: " + sid.getServerName());
            }
            try {
                String notificationType;
                boolean doSendNotification;
                block63: {
                    if (pidWaiter != null) {
                        pidWaiter.setProcessIsTerminated(true);
                        this.pidWaiterHashMap.remove(serverName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removed " + serverName + " from pidWaiterHashMap");
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "issuing stopImmediate first");
                    }
                    ProcessTerminator stopImmediate = new ProcessTerminator(sid);
                    stopImmediate.setStopMode(true);
                    stopImmediate.terminate();
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        Tr.debug(tc, "ThreadInterrupted Exception ", ex);
                    }
                    doSendNotification = false;
                    boolean doTerminate = false;
                    notificationType = null;
                    if (pid != null) {
                        block61: {
                            try {
                                terminatedProcess = ProcessFactory.bindTo((String)pid);
                            }
                            catch (ProcessOpException poe) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Could not bind to Process, so stopImmediate succeeded.");
                                }
                                if (pidWaiter != null) break block61;
                                doSendNotification = true;
                                notificationType = new String("websphere.process.stopped");
                            }
                        }
                        if (terminatedProcess != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Bound to Process, so stopImmediate failed.");
                            }
                            doTerminate = true;
                            if (pidWaiter == null) {
                                doSendNotification = true;
                                notificationType = new String("websphere.process.not.monitored");
                            }
                        }
                    } else {
                        doTerminate = true;
                        doSendNotification = true;
                        notificationType = new String("websphere.process.not.monitored");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sending NOT_MONITORED");
                        }
                    }
                    if (doTerminate) {
                        block62: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "issuing force");
                            }
                            stopImmediate.setStopMode(false);
                            stopImmediate.setForceMode(true);
                            try {
                                stopImmediate.terminate();
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block62;
                                Tr.debug(tc, "terminate failed but is ignored");
                            }
                        }
                        if (terminatedProcess != null) {
                            try {
                                terminatedProcess.waitForTermination(20);
                            }
                            catch (ProcessStillActiveException e) {
                                if (!tc.isDebugEnabled()) break block63;
                                Tr.debug(tc, "waitForTermination failed but is ignored");
                            }
                        }
                    }
                }
                if (doSendNotification) {
                    this.sendNotification(notificationType, processName);
                }
                if (this.nacache != null) {
                    this.nacache.removeFromCache(0, processName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminatePrivate", "true");
                }
                return true;
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminate", "false");
                }
                throw new AdminException(e, "Process " + processName + " failed to terminate");
            }
        }
        try {
            block65: {
                block64: {
                    if (pid == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "terminatePrivate", "false");
                        }
                        return false;
                    }
                    p = ProcessFactory.bindTo((String)pid);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "send stopping notification for server " + serverName + "for pid: " + pid);
                    }
                    this.sendNotification("websphere.process.stopping", serverName);
                    if (pidWaiter != null) {
                        pidWaiter.setProcessIsTerminated(true);
                        this.pidWaiterHashMap.remove(serverName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removed " + serverName + " from pidWaiterHashMap");
                        }
                    }
                    StopParams stopParams = new StopParams();
                    stopParams.setProcessID(pid);
                    stopParams.setStopMode(1);
                    try {
                        ProcessFactory.terminate((StopParams)stopParams);
                    }
                    catch (ProcessStillActiveException e) {
                        if (!tc.isDebugEnabled()) break block64;
                        Tr.debug(tc, "ProcessFactory.terminate failed but is ignored");
                    }
                }
                try {
                    p.waitForTermination();
                }
                catch (ProcessStillActiveException e) {
                    if (!tc.isDebugEnabled()) break block65;
                    Tr.debug(tc, "ProcessFactory.terminate failed but is ignored");
                }
            }
            if (this.getProcessStatus(serverName).equals("STOPPED")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "send stopped notification for server " + serverName + "for pid: " + pid);
                }
                this.removeLaunchedChild(serverName, pid);
                this.sendNotification("websphere.process.stopped", serverName);
                if (GenericServerProcHelper.isServerAGenericServer(sid) || GenericServerProcHelper.isServerAnIHSServer(sid)) {
                    GenericServerProcHelper.removeFileContainingPid(sid);
                }
                result = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server " + serverName + " and pid " + pid + " did not stop");
                }
                result = false;
                if (pidWaiter == null) {
                    this.sendNotification("websphere.process.not.monitored", processName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sending NOT_MONITORED");
                    }
                }
            }
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Threw exception " + t.getMessage());
            }
            throw Utils.makeAdminException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminatePrivate", new Boolean(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopProcess(String serverName) throws AdminException {
        int status;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopProcess", serverName);
        }
        if (serverName != null) {
            String lock;
            String string = lock = serverName.intern();
            synchronized (string) {
                status = this.stopProcessPrivate(serverName);
            }
        } else {
            status = this.stopProcessPrivate(serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopProcess", new Object[]{serverName, status});
        }
        return status;
    }

    public int stopProcessPrivate(String serverName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopProcessPrivate", serverName);
        }
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.getRepositoryRootURI());
        sid.setServerName(serverName);
        sid.setNodeName(this.nodeName);
        sid.setCellName(this.cellName);
        if (this.ZOS) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ZOS stopProcess()");
                }
                ProcessTerminator pt = new ProcessTerminator(sid);
                pt.terminate();
                return 0;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.launchProcess", (String)"298", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in NodeAgent.terminate:", e);
                }
                throw new AdminException("Process failed to terminate: " + serverName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopProcess non-ZOS", serverName);
        }
        try {
            if (!GenericServerProcHelper.isServerAnIHSServer(sid) && this.getProcessStatus(serverName).equals("STOPPED")) {
                return 0;
            }
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        boolean result = false;
        int retCode = GenericServerProcHelper.stopArbitraryServerProcess(sid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopProcessPrivate");
        }
        return retCode;
    }

    private boolean isServerRunning(ConfigService configService, String serverName) throws Exception {
        boolean running;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isServerRunning", serverName);
            }
            running = false;
            ConfigObject server_NamedEndPoint = null;
            List l = configService.getDocumentObjects(configService.getScope(3), "serverindex.xml");
            ConfigObject serverIndex = (ConfigObject)l.get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerIndex ", serverIndex);
            }
            List servers = serverIndex.getObjectList("serverEntries");
            ConfigScope cscope = configService.createScope(4);
            cscope.set(4, serverName);
            ConfigObject server = null;
            try {
                List srvlist = configService.getDocumentObjects(cscope, "server.xml");
                server = (ConfigObject)srvlist.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server", server);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.isServerRunning", (String)"872", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured while getting server configobject.");
                }
                throw e;
            }
            this.retrieveConnectorType(serverName, server);
            String connector2 = this.getServerConnectorType(serverName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorType: " + connector2);
            }
            if (connector2 != null) {
                String ENDPOINT = null;
                if (connector2.equals("SOAP")) {
                    ENDPOINT = "SOAP_CONNECTOR_ADDRESS";
                } else if (connector2.equals("RMI") || connector2.equals("JSR160RMI")) {
                    ENDPOINT = "BOOTSTRAP_ADDRESS";
                } else if (connector2.equals("IPC")) {
                    ENDPOINT = "IPC_CONNECTOR_ADDRESS";
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected endpoint", connector2);
                    }
                    throw new Exception(NodeAgent.getFormattedMessage("ADMU0514E", new Object[]{connector2}, "Un-supported connector type: " + connector2));
                }
                if (ENDPOINT != null) {
                    for (int i = 0; i < servers.size(); ++i) {
                        ConfigObject serverEntry = (ConfigObject)servers.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ServerEntry", serverEntry);
                        }
                        if (!serverEntry.getString("serverName", "__null__").equals(serverName)) continue;
                        List endpts = serverEntry.getObjectList("specialEndpoints");
                        for (int e = 0; e < endpts.size(); ++e) {
                            ConfigObject namedEndPoint = (ConfigObject)endpts.get(e);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "NamedEndPoint", namedEndPoint);
                            }
                            if (!namedEndPoint.getString("endPointName", "__null__").equals(ENDPOINT) || server_NamedEndPoint != null) continue;
                            server_NamedEndPoint = namedEndPoint;
                        }
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverNamedEndPoint: " + server_NamedEndPoint);
            }
            if (server_NamedEndPoint != null) {
                ConfigObject ep = server_NamedEndPoint.getObject("endPoint");
                int port = ep.getInt("port", 0);
                String host = ep.getString("host", "__null__");
                try {
                    Socket soc = host.equals("*") ? new Socket((String)null, port) : new Socket(host, port);
                    running = true;
                    soc.close();
                    String portObj = new Integer(port).toString();
                    String result = TraceNLS.getStringFromBundle(BUNDLE_NAME, "ADMU3028I", (String)null);
                    String mesg = TraceNLS.getFormattedMessageFromLocalizedMessage(result, new Object[]{portObj, serverName}, true);
                    Tr.warning(tc, mesg);
                }
                catch (ConnectException ce) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ConnectException occured while opening a socket. Check FFDC for log: " + ce.getMessage());
                        FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.management.nodeagent.NodeAgent.isServerRunning", (String)"947", (Object)this);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.isServerRunning", (String)"842", (Object)this);
                    if (!tc.isDebugEnabled()) break block27;
                    Tr.debug(tc, "Exception occured while opening a socket");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerRunning", new Boolean(running));
        }
        return running;
    }

    public boolean launchProcess(String processName) throws AdminException {
        Integer IlaunchTimeout = null;
        String launchTimeout = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " launchProcess launchTimeout: " + launchTimeout);
        }
        if (launchTimeout == null || launchTimeout.length() < 0) {
            launchTimeout = AdminHelper.getPlatformHelper().isZOS() ? DEFAULT_LAUNCH_TIMEOUT_ZOS : DEFAULT_LAUNCH_TIMEOUT;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " launchProcess launchTimeout: " + launchTimeout);
            }
        }
        try {
            IlaunchTimeout = new Integer(launchTimeout);
        }
        catch (Throwable t) {
            IlaunchTimeout = this.ZOS ? DEFAULT_LAUNCH_TIMEOUT_INTEGER_ZOS : DEFAULT_LAUNCH_TIMEOUT_INTEGER;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " launchProcess IlaunchTimeout: " + IlaunchTimeout);
        }
        return this.launchProcess(processName, IlaunchTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launchProcess(String processName, Integer itimeout) throws AdminException {
        boolean status;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchProcess", new Object[]{processName, itimeout});
        }
        if (processName != null) {
            String lock;
            String string = lock = processName.intern();
            synchronized (string) {
                status = this.launchProcessPrivate(processName, itimeout);
            }
        } else {
            status = this.launchProcessPrivate(processName, itimeout);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "launchProcess", new Object[]{processName, itimeout, status});
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean launchProcessPrivate(String processName, Integer itimeout) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchProcessPrivate", new Object[]{processName, itimeout});
        }
        int timeout = itimeout;
        boolean started = false;
        Integer statusPort = null;
        boolean wait = true;
        String pid = null;
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.getRepositoryRootURI());
        sid.setServerName(processName);
        sid.setNodeName(this.nodeName);
        sid.setCellName(this.cellName);
        this.launchProcessPart1(processName);
        try {
            if (GenericServerProcHelper.isServerAGenericServer(sid) && this.getProcessStatus(processName).equals("RUNNING")) {
                return true;
            }
        }
        catch (Throwable t) {
            throw Utils.makeAdminException(t);
        }
        String disableCheckForServerReady = System.getProperty("disableCheckForServerReady");
        boolean waitForAppBinExpansion = !"true".equals(disableCheckForServerReady);
        int retryAttempts = 1;
        if (waitForAppBinExpansion) {
            Tr.debug(tc, "waiting for app-bin expansion feature is ENABLED");
        } else {
            Tr.debug(tc, "waiting for app-bin expansion feature is DISABLED");
        }
        while (isSyncInProgress && waitForAppBinExpansion) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " launchProcess: wait for " + retryAttempts + " time");
                }
                Thread.sleep(500L);
                ++retryAttempts;
            }
            catch (InterruptedException ie) {}
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launchProcess: isSyncInProgress " + isSyncInProgress);
        }
        if (waitForAppBinExpansion) {
            CommonAppUtils.waitForAppExpansion((String)processName, (String)this.nodeName, (String)this.cellName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launchProcess: After calling waitForAppExpansion");
        }
        try {
            block57: {
                try {
                    int status;
                    Process p;
                    block56: {
                        block58: {
                            ConfigService cs = ConfigServiceFactory.createConfigService((String)sid.getConfigRoot(), (String)sid.getCellName(), (String)sid.getNodeName(), (String)processName);
                            ConfigObject server = null;
                            ConfigScope cscope = this.configService.createScope(4);
                            cscope.set(4, processName);
                            List resContents = cs.getDocumentObjects(cscope, "server.xml");
                            server = (ConfigObject)resContents.get(0);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nodeagent launchProcess server: " + server);
                            }
                            String clusterName = server.getString("clusterName", "__null__");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nodeagent launchProcess Cluster: " + clusterName);
                            }
                            if (clusterName != null) {
                                cs = ConfigServiceFactory.createConfigService((String)sid.getConfigRoot(), (String)sid.getCellName(), (String)sid.getNodeName(), (String)processName, (String)clusterName);
                            }
                            VariableMap map = VariableMapFactory.createVariableMap((ConfigService)cs);
                            map.initialize(null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "sid = " + sid.toString());
                            }
                            LaunchCommand launcher2 = new LaunchCommand(cs, map, sid);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Launching a new server process: " + sid.getServerName());
                            }
                            this.sendNotification("websphere.process.starting", processName);
                            ServerSocket statusSocket = null;
                            this.crosslpar = this.checkcrosslpar(processName);
                            wait = true;
                            if (GenericServerProcHelper.isServerAGenericServer(sid) || GenericServerProcHelper.isServerAnIHSServer(sid)) {
                                wait = false;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "wait for server init = " + wait);
                            }
                            if (wait && (statusSocket = this.getFreePort(timeout * 1000)) != null) {
                                statusPort = new Integer(statusSocket.getLocalPort());
                                launcher2.setStatusSocketPort(statusPort);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "status socket = " + statusPort.toString());
                                }
                            }
                            if (this.isServerRunning(cs, sid.getServerName())) {
                                throw new AdminException(NodeAgent.getFormattedMessage("ADMU3027E", null, null));
                            }
                            p = launcher2.launchProcess();
                            pid = p.id();
                            GenericServerProcHelper.savePidToFile(pid, sid);
                            pid = pid.toUpperCase();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Launched process pid: " + pid);
                            }
                            this.addLaunchedChild(processName, pid);
                            int port = 1;
                            if (wait) {
                                port = statusSocket.getLocalPort();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Local port = " + port);
                                }
                            } else {
                                int retryLimit = 5;
                                for (int retryCount = 0; this.getProcessStatus(processName).equals("STOPPED") && retryCount < retryLimit; ++retryCount) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Generic Server " + processName + " not yet started, wait(ms): " + timeout);
                                    }
                                    Thread.sleep(timeout);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Processing as generic server. ");
                                }
                            }
                            new ProcessWatcher(p, port, timeout);
                            status = -2;
                            if (statusSocket == null) break block58;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "xcfMonitor_Enabled:" + this.xcfMonitor_Enabled + "  crosslpar:" + this.crosslpar);
                            }
                            if (this.crosslpar) {
                                if (this.xcfMonitor_Enabled) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "About to waitForXCFMonitor. ");
                                    }
                                    status = this.waitForXCFMonitor(processName, timeout);
                                    break block56;
                                } else {
                                    int mytimeout = 60;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "NOT waiting for XCFMonitor. ");
                                    }
                                    mytimeout = timeout == 0 ? DEFAULT_LAUNCH_TIMEOUT_INTEGER_ZOS : timeout;
                                    Thread.sleep(mytimeout * 1000);
                                    status = -2;
                                }
                                break block56;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to waitForServerInit. ");
                                }
                                status = this.waitForServerInit(statusSocket);
                            }
                            break block56;
                        }
                        if (this.getProcessStatus(processName).equals("RUNNING") && !wait) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Process status is RUNNING. ");
                            }
                            this.sendNotification("websphere.process.running", processName);
                            this.setFilePid(processName, pid);
                            status = 0;
                        } else if (this.getProcessStatus(processName).equals("STOPPED") && !wait) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Process status is STOPPED. ");
                            }
                            this.sendNotification("websphere.process.stopped", processName);
                        }
                    }
                    if (status == 0) {
                        if (this.nacache != null) {
                            this.nacache.addToCache(0, processName, "j2ee.state.running");
                        }
                        Tr.audit(tc, "ADML0000I", new Object[]{pid, processName});
                        started = true;
                    } else {
                        if (status == -1) {
                            this.sendNotification("websphere.process.failed", processName);
                            Tr.warning(tc, "ADML0011E");
                            throw new AdminException(NodeAgent.getFormattedMessage("ADML0011E", null, null));
                        }
                        if (status == 0) {
                            Tr.warning(tc, "ADML0011E");
                            throw new AdminException(NodeAgent.getFormattedMessage("ADML0011E", null, null));
                        }
                        String timeString = new Integer(timeout).toString();
                        Tr.warning(tc, "ADML0040E", new Object[]{processName, timeString});
                    }
                    if (started) {
                        this.addProcessHandler(processName, pid, p);
                    } else {
                        this.removeLaunchedChild(processName, pid);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process is on another LPAR: " + this.crosslpar);
                    }
                    if (!tc.isDebugEnabled()) break block57;
                    Tr.debug(tc, "processName = " + processName + " pid = " + pid + " status = " + status + " - started = " + started + " wait = " + wait);
                }
                catch (Exception e) {
                    if (pid != null) {
                        this.removeLaunchedChild(processName, pid);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.launchProcess", (String)"298", (Object)this);
                    if (!tc.isDebugEnabled()) throw new AdminException(e, "Process " + processName + " failed to launch: " + e);
                    Tr.debug(tc, "Exception in LaunchCommand.launchProcess():", e);
                    throw new AdminException(e, "Process " + processName + " failed to launch: " + e);
                }
            }
            Object var25_28 = null;
            if (!tc.isEntryEnabled()) return started;
            Tr.exit(tc, "launchProcessPrivate", new Boolean(started));
            return started;
        }
        catch (Throwable throwable) {
            Object var25_29 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "launchProcessPrivate", new Boolean(started));
            throw throwable;
        }
    }

    private void launchProcessPart1(String processName) throws AdminException {
        AdminHelper.getInstance().audit("ADMN1000I", "ADMN1001I", (Object)new Object[]{processName, this.nodeName, null});
        if (!this.serverExists(this.cellName, this.nodeName, processName)) {
            throw new AdminException("Server, " + processName + ", not found.");
        }
        boolean syncResult = false;
        try {
            syncResult = NodeSync.getNodeSync().syncForServerStartup();
        }
        catch (Exception e) {
            Tr.error(tc, e.getMessage());
        }
        if (!syncResult) {
            Tr.warning(tc, "ADML0065W");
        }
    }

    public String getProcessStatus(String serverName) throws IllegalArgumentException, AdminException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessStatus", serverName);
        }
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.getRepositoryRootURI());
        sid.setServerName(serverName);
        sid.setNodeName(this.nodeName);
        sid.setCellName(this.cellName);
        String result = GenericServerProcHelper.getStatusUsingPidFile(sid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessStatus", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void setFilePid(String processName, String pid) {
        block16: {
            if (NodeAgent.tc.isEntryEnabled()) {
                Tr.entry(NodeAgent.tc, "setFilePid", pid);
            }
            pidFile = this.variableMap.expand("${LOG_ROOT}/" + processName + "/" + processName + ".pid");
            if (NodeAgent.tc.isDebugEnabled()) {
                Tr.debug(NodeAgent.tc, "Pid = " + pid + " to be saved in " + pidFile);
            }
            if (pid != null) {
                f = new File(pidFile);
                f.getParentFile().mkdirs();
                out = null;
                try {
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    out = new FileOutputStream(f);
                    out.write(pid.getBytes());
                    var8_6 = null;
                    ** if (out == null) goto lbl-1000
                }
                catch (Throwable var7_13) {
                    var8_8 = null;
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"744", (Object)this);
                        }
                    }
                    throw var7_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"744", (Object)this);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"732", (Object)this);
                        var8_7 = null;
                        if (out != null) {
                            try {
                                out.flush();
                                out.close();
                            }
                            catch (IOException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.writeFile", (String)"744", (Object)this);
                            }
                        }
                    }
                }
            }
        }
        if (NodeAgent.tc.isEntryEnabled()) {
            Tr.exit(NodeAgent.tc, "setFilePid");
        }
    }

    String getFilePid(String processName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilePid", processName);
        }
        String pid = this.getCurrentPid(processName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid from file found: " + pid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilePid", pid);
        }
        return pid;
    }

    private boolean isGenericServer(ConfigObject processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenericServer");
        }
        boolean result = false;
        String executableName = processDef.getString("executableName", "__null__");
        if (executableName != null) {
            ConfigObject javaProcessDef;
            String jPDTarget;
            if ((executableName = executableName.trim()).indexOf("java") < 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGenericServer");
                }
                return true;
            }
            if (processDef.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/processexec.xmi", "JavaProcessDef") && (jPDTarget = (javaProcessDef = processDef).getString("executableTarget", "__null__")) != null && !jPDTarget.equals(WSSERVER_CLASS)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGenericServer");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenericServer");
        }
        return result;
    }

    private boolean serverExists(String cellName, String nodeName, String serverName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverExists", new Object[]{cellName, nodeName, serverName});
        }
        ConfigRepository cr = this.getLocalRepository();
        String uri = ConfigStructureHelper.getURI((String)cellName, (String)nodeName, (String)serverName, (String)"server.xml");
        String[] files = cr.listResourceNames(uri, 1, 0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverExists", files.length != 0);
        }
        return files.length != 0;
    }

    private synchronized ConfigRepository getLocalRepository() throws AdminException {
        ConfigRepository localRepository;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalRepository");
        }
        Properties p = new Properties();
        if (this.profileKey == null) {
            p.setProperty("location", "local");
        } else {
            p.setProperty("location", "profilekey");
            p.setProperty("profileKey", this.profileKey);
        }
        try {
            localRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)p);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getLocalRepository", (String)"427", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in ConfigRepositoryClientFactory.getConfigRepositoryClient():", e);
            }
            throw new AdminException(e, "Unable to create repository client: " + e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalRepository", localRepository);
        }
        return localRepository;
    }

    private Notification createNotification(String type, String processName) {
        Notification ntfyObj = new Notification(type, this.getObjectName(), this.ntfySeqNum++);
        Properties props = new Properties();
        props.setProperty("processName", processName);
        ntfyObj.setUserData(props);
        return ntfyObj;
    }

    public void bindMBean(ModelMBeanInfo info, ModelMBean bean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMBean");
        }
        super.bindMBean(info, bean);
        if (info != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "info:", info);
            }
            Descriptor mBeanDescriptor = info.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanDescriptor", mBeanDescriptor);
            }
            String displayName = "NodeAgent";
            mBeanDescriptor.setField("displayName", displayName);
            String type = (String)mBeanDescriptor.getFieldValue("type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type:" + type);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindMBean");
        }
    }

    private ServerSocket getFreePort(int timeout) {
        ServerSocket s = null;
        try {
            s = new ServerSocket(0);
            s.setSoTimeout(timeout);
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getFreePort", (String)"349", (Object)this);
            Tr.error(tc, "ADML0012E", ioe);
        }
        return s;
    }

    private int waitForServerInit(ServerSocket statusSocket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForServerInit");
        }
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = statusSocket.accept();
            }
            catch (InterruptedIOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", (String)"368", (Object)this);
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", (String)"374", (Object)this);
                Tr.error(tc, "ADML0009E", ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = -1;
            }
            if (acceptedSocket == null || (result = this.getStatus(acceptedSocket)) != 0 && result != 0 && result != -1) continue;
            statusReceived = true;
        }
        if (!statusReceived) {
            result = -2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForServerInit");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket s) {
        FilterInputStream dataInput;
        InputStream socketInput;
        int status;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatus");
            }
            status = -1;
            socketInput = null;
            dataInput = null;
            socketInput = s.getInputStream();
            dataInput = new DataInputStream(socketInput);
            status = ((DataInputStream)dataInput).readInt();
            Object var8_5 = null;
            try {
                dataInput.close();
                socketInput.close();
                break block10;
            }
            catch (IOException e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"425", (Object)this);
                Tr.error(tc, "ADML0009E", e2);
            }
            {
                break block10;
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"414", (Object)this);
                    Tr.error(tc, "ADML0009E", e);
                    int n = -1;
                    Object var8_6 = null;
                    try {
                        dataInput.close();
                        socketInput.close();
                    }
                    catch (IOException e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"425", (Object)this);
                        Tr.error(tc, "ADML0009E", e2);
                    }
                    dataInput = null;
                    socketInput = null;
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    dataInput.close();
                    socketInput.close();
                }
                catch (IOException e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getStatus", (String)"425", (Object)this);
                    Tr.error(tc, "ADML0009E", e2);
                }
                dataInput = null;
                socketInput = null;
                throw throwable;
            }
        }
        dataInput = null;
        socketInput = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus");
        }
        return status;
    }

    private static String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = nls.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            FFDCFilter.processException((Throwable)npe, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getFormattedMessage", (String)"449");
            return defaultString;
        }
    }

    public void stopNode() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNode");
        }
        AdminHelper.getInstance().audit("ADMN1002I", "ADMN1003I", (Object)new Object[]{this.nodeName, null});
        boolean attempted = true;
        Object nodeAgentServerName = null;
        Vector servers = null;
        try {
            servers = this.getServers();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.stopNode", (String)"471", (Object)this);
            throw new AdminException(ex, "An problem occurred during stopNode processing: ");
        }
        this.saveNodeState(false, false);
        this.isBeingCalledByStopNodeMethod = true;
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                String serverName = (String)servers.get(i);
                this.sendStop(serverName, false);
            }
        }
        this.sendStop(AdminHelper.getInstance().getNodeAgentName(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNode");
        }
    }

    private boolean sendStop(String serverName, boolean nodeAgentStop) {
        boolean attempt;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendStop", serverName);
            }
            attempt = true;
            try {
                ObjectName server = this.getServerObjectName(serverName);
                if (server == null) break block11;
                if (nodeAgentStop && server.getKeyProperty("processType").equalsIgnoreCase("NodeAgent") || !nodeAgentStop && !server.getKeyProperty("processType").equalsIgnoreCase("NodeAgent")) {
                    String opName = "stop";
                    try {
                        Object[] params = null;
                        String[] sig = null;
                        int timeout = 600;
                        ServerSocket statusSocket = this.getFreePort(timeout * 1000);
                        Integer statusPort = null;
                        if (statusSocket != null) {
                            if (!nodeAgentStop) {
                                statusPort = new Integer(statusSocket.getLocalPort());
                            }
                            params = new Object[]{Boolean.TRUE, statusPort};
                            sig = new String[]{"java.lang.Boolean", "java.lang.Integer"};
                        }
                        Object result = this.getAdminService().invoke(server, opName, params, sig);
                        if (nodeAgentStop) break block11;
                        int status = -2;
                        if (statusSocket != null) {
                            status = this.waitForServerInit(statusSocket);
                        }
                        if (status != 0) {
                            Tr.warning(tc, "ADML0111E");
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        Tr.error(tc, "ADML0019E", e);
                    }
                    break block11;
                }
                attempt = false;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.sendStop", (String)"557", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendStop", serverName);
        }
        return attempt;
    }

    private ObjectName getServerObjectName(String serverName) {
        ObjectName _server = null;
        ObjectName queryName = null;
        try {
            queryName = new ObjectName("WebSphere:*,type=Server,process=" + serverName + ",node=" + this.nodeName);
            Set s = this.getAdminService().queryNames(queryName, null);
            if (s.size() != 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are " + s.size() + " Servers! queryName=" + queryName);
            }
            if (s.size() > 0) {
                Object[] o = s.toArray();
                _server = (ObjectName)o[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server handle is ==> " + _server.getCanonicalName());
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getServerObjectName", (String)"593", (Object)this);
            Tr.error(tc, "ADML0523E", new Object[]{queryName, e});
        }
        return _server;
    }

    private Vector getServers() throws Exception {
        Vector<String> v = new Vector<String>();
        String sdir = this.getRepositoryRootURI() + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File serverContexts = new File(sdir);
        File[] servers = serverContexts.listFiles();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].isDirectory()) continue;
            String serverName = servers[i].getName();
            v.add(serverName);
        }
        return v;
    }

    private AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
        }
        return this.adminService;
    }

    private void discoveryMBeanListenerRegistration() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "discoveryMBeanListenerRegistration " + AdminContext.peek());
            }
            try {
                String query = "WebSphere:type=Discovery,process=" + AdminServiceFactory.getAdminService().getProcessName() + ",*";
                ObjectName queryName = new ObjectName(query);
                Set s = AdminServiceFactory.getAdminService().queryNames(queryName, null);
                Iterator it = s.iterator();
                queryName = (ObjectName)it.next();
                AdminServiceFactory.getAdminService().addNotificationListener(queryName, this, null, (Object)DISCOVERY_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.registerToDiscoveryMBean", (String)"646", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "can not register as a listener to DiscoveryMBean", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discoveryMBeanListenerRegistration");
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String processType = this.profileKey == null ? "ManagedProcess" : "UnManagedProcess";
            ObjectName appserver = new ObjectName("WebSphere:*,type=Server,processType=" + processType);
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("j2ee.state.stopping");
            adminService.addNotificationListenerExtended(appserver, this, filter, STOPPING_LISTENER);
        }
        catch (JMException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.listenForJ2EEStateStoppingNotifications", (String)"666", (Object)this);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        String type = notification.getType();
        if (handback.equals(DISCOVERY_LISTENER)) {
            if (type.equals("websphere.discovery.process.found")) {
                Properties props = (Properties)notification.getUserData();
                String pName = props.getProperty("processName");
                String pid = props.getProperty("processId");
                this.sendNotification("websphere.process.running", pName);
                boolean launched = this.containLaunchedChild(pName, pid);
                try {
                    this.monitorProcess(pName, pid, !launched);
                }
                catch (ProcessOpException ex) {
                    Tr.error(tc, "ADML0056E", new Object[]{pName, pid, ex.getMessage()});
                }
            }
        } else if (handback.equals(STOPPING_LISTENER)) {
            if (type.equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "j2ee.state.stopping notification received");
                }
                this.sendNotification("websphere.process.stopping", ((ObjectName)notification.getSource()).getKeyProperty("name"));
            }
        } else if (handback.equals(SYNC_LISTENER)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess : Sync Event received ");
            }
            if (type.equals("websphere.nodesync.initiated")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess : NodeSync Initiated");
                }
                isSyncInProgress = true;
            }
            if (type.equals("websphere.nodesync.complete")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess : NodeSync Complete");
                }
                isSyncInProgress = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void adoptChildProcess(String pName, String pid) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adoptChildProcess", new Object[]{pName, pid});
        }
        if (this.containAdoptedChild(pName, pid)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "already adopted", pName);
            }
            return;
        }
        Process p = null;
        p = ProcessFactory.bindTo((String)pid);
        this.addProcessHandler(pName, pid, p);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adoptChildProcess", new Object[]{pName, pid});
        }
    }

    private boolean checkcrosslpar(String svrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkcrosslpar " + svrName);
        }
        String profilesystem = null;
        AdminService as = AdminServiceFactory.getAdminService();
        if (as != null && AdminHelper.getPlatformHelper().isZOS()) {
            String localServerType = as.getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localServerType: " + localServerType);
            }
            if (localServerType != null && localServerType.equals("ADMIN_AGENT")) {
                String aasystem = AdminHelper.getPlatformHelper().getSystemName();
                profilesystem = this.getwasConfiguredSystemName(svrName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AdminAgent system: " + aasystem + " Profile system: " + profilesystem);
                }
                if (!aasystem.equals(profilesystem)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkcrosslpar", "true");
                    }
                    return true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkcrosslpar", "false");
        }
        return false;
    }

    private String getwasConfiguredSystemName(String svrName) {
        String ownConfiguredSystemName;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getwasConfiguredSystemName");
            }
            ownConfiguredSystemName = null;
            try {
                ConfigScope cscope = this.configService.createScope(4);
                cscope.set(4, svrName);
                List list = this.configService.getDocumentObjects(cscope, "server.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configservice list has size: " + list.size());
                }
                ConfigObject object = (ConfigObject)list.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using server.xml for server: " + object.getString("name", "__null__"));
                }
                List services = object.getObjectList("services");
                for (ConfigObject service : services) {
                    String typeName = service.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying services config type: " + typeName);
                    }
                    if (!typeName.equals("AdminService")) continue;
                    List properties = service.getObjectList("properties");
                    for (ConfigObject property : properties) {
                        if (!"was.ConfiguredSystemName".equals(property.getString("name", ""))) continue;
                        ownConfiguredSystemName = property.getString("value", null);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + ownConfiguredSystemName);
                    }
                }
                if (ownConfiguredSystemName != null) break block12;
                List components = object.getObjectList("components");
                for (ConfigObject component2 : components) {
                    String typeName = component2.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying component config type: " + typeName);
                    }
                    if (!typeName.equals("ApplicationServer")) continue;
                    List properties = component2.getObjectList("properties");
                    for (ConfigObject property : properties) {
                        if (!"was.ConfiguredSystemName".equals(property.getString("name", ""))) continue;
                        ownConfiguredSystemName = property.getString("value", null);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + ownConfiguredSystemName);
                    }
                    break;
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.launcher.LaunchCommand.getwasConfiguredSystemName", (String)"1479", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getwasConfiguredSystemName", ownConfiguredSystemName);
        }
        return ownConfiguredSystemName;
    }

    public boolean getcrosslpar() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getcrosslpar: " + this.crosslpar);
        }
        return this.crosslpar;
    }

    private void monitorProcess(String pName, String pid, boolean adoption) throws ProcessOpException {
        Process p;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorProcess", new Object[]{pName, pid, new Boolean(adoption)});
        }
        this.crosslpar = this.checkcrosslpar(pName);
        if (this.crosslpar) {
            pid = "0";
            adoption = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "crosslpar - forcing pid = 0, adoption = false.");
            }
        }
        if ((p = this.removeProcessHandler(pName, pid)) == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "process object is null.");
        }
        if (!this.crosslpar) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not crosslpar.");
            }
            if (p != null) {
                try {
                    p.isAlive();
                }
                catch (ProcessOpException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "process not alive", (Object)ex);
                    }
                    p = null;
                }
            }
            if (p == null) {
                try {
                    p = ProcessFactory.bindTo((String)pid);
                    adoption = true;
                }
                catch (ProcessOpException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "can not bind to process", (Object)ex);
                    }
                    if (this.ZOS) {
                        new MonitorProcess(pName, pid, adoption).start();
                        return;
                    }
                    throw ex;
                }
                if (adoption) {
                    this.addAdoptedChild(pName, pid);
                }
            }
        }
        if (p != null) {
            String launchTimeout;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "starting PidWaiter.");
            }
            if ((launchTimeout = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout")) == null || launchTimeout.length() < 0) {
                launchTimeout = this.ZOS ? DEFAULT_LAUNCH_TIMEOUT_ZOS : DEFAULT_LAUNCH_TIMEOUT;
            }
            int timeout = Integer.parseInt(launchTimeout);
            PidWaiter pidWaiter = new PidWaiter(this, p, pid, this.variableMap, pName, timeout, adoption, this.profileKey);
            if (this.ZOS) {
                Thread thr = new Thread(pidWaiter);
                thr.setDaemon(true);
                thr.start();
            } else {
                new Thread(pidWaiter).start();
            }
            this.pidWaiterHashMap.put(pName, pidWaiter);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added " + pName + " to pidWaiterHashMap");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "monitorProcess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProcessHandler(String name, String pid, Process p) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "addProcessHandler", new Object[]{name, pid});
        }
        String key = name + ":" + pid;
        HashMap hashMap = this.processHandlers;
        synchronized (hashMap) {
            this.processHandlers.put(key, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process removeProcessHandler(String name, String pid) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "removeProcessHandler", new Object[]{name, pid});
        }
        String key = name + ":" + pid;
        Process p = null;
        HashMap hashMap = this.processHandlers;
        synchronized (hashMap) {
            p = (Process)this.processHandlers.remove(key);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLaunchedChild(String name, String pid) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "addLaunchedChild", new Object[]{"serverName=" + name, "pid=" + pid});
        }
        boolean old = false;
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            String entryPid = (String)this.launchedChildren.get(name);
            if (entryPid != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replacing old launched child: " + name + ":" + entryPid);
                }
                old = true;
            }
            this.launchedChildren.put(name, pid);
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAdoptedChild(String name, String pid) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "addAdoptedChild", new Object[]{"serverName=" + name, "pid=" + pid});
        }
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            String entryPid = (String)this.adoptedChildren.get(name);
            if (entryPid != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing old adopted child: " + name + ": " + entryPid);
            }
            this.adoptedChildren.put(name, pid);
        }
        if (this.nacache != null) {
            this.nacache.addToCache(0, name, "j2ee.state.running");
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLaunchedChild(String name, String pid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeLaunchedChild", new Object[]{name, pid});
        }
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            String entryPid = (String)this.launchedChildren.remove(name);
            if (entryPid != null) {
                if (entryPid.equals(pid)) {
                    this.launchedChildren.remove(name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removeLaunchedChild", "Entry deleted.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeLaunchedChild", "Entry not deleted--pid mismatch. entryPid=" + entryPid);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeLaunchedChild", "Entry not found.");
            }
        }
        if (this.nacache != null) {
            this.nacache.removeFromCache(0, name);
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAdoptedChild(String name, String pid) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "removeAdoptedChild", new Object[]{"serverName=" + name, "pid=" + pid});
        }
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            String entryPid = (String)this.adoptedChildren.remove(name);
            if (entryPid != null) {
                if (entryPid.equals(pid)) {
                    this.adoptedChildren.remove(name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removeAdoptedChild", "Entry deleted.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeAdoptedChild", "Entry not deleted--pid mismatch. entryPid=" + entryPid);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeAdoptedChild", "Entry not found.");
            }
        }
        if (this.nacache != null) {
            this.nacache.removeFromCache(0, name);
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLaunchedChildPid(String name) {
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            return (String)this.launchedChildren.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAdoptedChildPid(String name) {
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            return (String)this.adoptedChildren.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containAdoptedChild(String name, String pid) {
        String adoptedPid;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "containAdoptedChild", new Object[]{"serverName=" + name, "pid=" + pid});
        }
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            adoptedPid = (String)this.adoptedChildren.get(name);
        }
        return adoptedPid != null && adoptedPid.equals(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containLaunchedChild(String name, String pid) {
        String launchedPid;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "containLaunchedChild", new Object[]{name, pid});
        }
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            launchedPid = (String)this.launchedChildren.get(name);
        }
        return launchedPid != null && launchedPid.equals(pid);
    }

    private void loadMonitoringPolicies() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMonitoringPolicies");
        }
        Vector servers = null;
        MonitorConfig cfg = null;
        try {
            servers = this.getServers();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"838", (Object)this);
        }
        if (servers == null) {
            return;
        }
        for (String svrName : servers) {
            if (svrName.equals(AdminHelper.getInstance().getNodeAgentName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "load monitoring policy for server:", svrName);
            }
            if (this.ZOS) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "load390MonitoringPolicies");
                }
                cfg = this.load390ServerMonitoringPolicy(svrName);
            } else {
                cfg = this.loadServerMonitoringPolicy(svrName);
            }
            if (cfg == null) continue;
            this.monitoringPolicies.put(svrName, cfg);
        }
        this.loadNodeState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMonitoringPolicies");
        }
    }

    HashMap getMonitoringPolicies() {
        return this.monitoringPolicies;
    }

    MonitorConfig loadServerMonitoringPolicy(String svrName) {
        Object resource = null;
        MonitorConfig cfg = null;
        ConfigScope cscope = this.configService.createScope(4);
        cscope.set(4, svrName);
        try {
            List l = this.configService.getDocumentObjects(cscope, "server.xml");
            ConfigObject server = (ConfigObject)l.get(0);
            this.retrieveConnectorType(svrName, server);
            ConfigObject processDef = null;
            List processDefs = server.getObjectList("processDefinitions");
            String processType = null;
            for (int i = 0; i < processDefs.size(); ++i) {
                processDef = (ConfigObject)processDefs.get(i);
                processType = processDef.getString("processType", "__null__");
                if (processType == null) continue;
                if (this.ZOS) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for z/OS Control Region type.");
                    }
                    if (!processType.equalsIgnoreCase("Control")) continue;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for Dist Single process type.");
                }
                if (processType.equalsIgnoreCase("Single")) break;
            }
            if (processDef == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processDef is null, trying singleton.");
                }
                processDef = server.getObject("processDefinition");
            }
            if (processDef == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processDef still null, exception.......");
                }
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML0065E", null, null));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeAgent: ProcessDef: " + processDef);
            }
            ConfigObject monitoringPolicy = processDef.getObject("monitoringPolicy");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MonitoringPolicy: " + monitoringPolicy);
            }
            cfg = new MonitorConfig(monitoringPolicy);
            ServerIdentifiers sid = new ServerIdentifiers();
            sid.setConfigRoot(this.getRepositoryRootURI());
            sid.setServerName(svrName);
            sid.setNodeName(this.nodeName);
            sid.setCellName(this.cellName);
            if (GenericServerProcHelper.isServerAGenericServer(sid) || GenericServerProcHelper.isServerAWebServer(sid) || this.isGenericServer(processDef)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, svrName + " is a generic or web server; setting state to STOPPED");
                }
                cfg.setNodeRestartState(0);
            }
        }
        catch (FileNotFoundException nofile) {
            FFDCFilter.processException((Throwable)nofile, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"896", (Object)this);
            Tr.service(tc, "ADML0062W", svrName);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"901", (Object)this);
        }
        return cfg;
    }

    MonitorConfig load390ServerMonitoringPolicy(String svrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load390ServerMonitoringPolicy", svrName);
        }
        Object resource = null;
        MonitorConfig cfg = null;
        ConfigObject processDef = null;
        ConfigScope cscope = this.configService.createScope(4);
        cscope.set(4, svrName);
        try {
            List l = this.configService.getDocumentObjects(cscope, "server.xml");
            ConfigObject server = (ConfigObject)l.get(0);
            this.retrieveConnectorType(svrName, server);
            List processDefs = server.getObjectList("processDefinitions");
            String processType = null;
            for (int i = 0; !(i >= processDefs.size() || (processType = (processDef = (ConfigObject)processDefs.get(i)).getString("processType", "__null__")) != null && processType.equalsIgnoreCase("Control")); ++i) {
            }
            if (processDef == null) {
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML0065E", null, null));
            }
            ConfigObject monitor = processDef.getObject("monitoringPolicy");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MonitoringPolicy: " + monitor);
            }
            cfg = new MonitorConfig(monitor);
        }
        catch (FileNotFoundException nofile) {
            FFDCFilter.processException((Throwable)nofile, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"896", (Object)this);
            Tr.service(tc, "ADML0062W", svrName);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"901", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load390ServerMonitoringPolicy", cfg);
        }
        return cfg;
    }

    private ConfigObject getServer(ConfigService configService, int scope, String relPath) throws Exception {
        List csContents = configService.getDocumentObjects(configService.getScope(scope), relPath);
        return (ConfigObject)csContents.get(0);
    }

    private void retrieveConnectorType(String svrName, ConfigObject server) {
        List list = server.getObjectList("services");
        String type = "SOAP";
        for (ConfigObject o : list) {
            if (!o.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "AdminService")) continue;
            ConfigObject jmxConnector = o.getObject("preferredConnector");
            if (jmxConnector == null) {
                jmxConnector = o.getObject("remoteAdminProtocol");
            }
            if (jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "SOAPConnector")) {
                type = "SOAP";
                break;
            }
            if (jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "RMIConnector")) {
                type = "RMI";
                break;
            }
            if (jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "JSR160RMIConnector")) {
                type = "JSR160RMI";
                break;
            }
            if (!jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "IPCConnector")) break;
            type = "IPC";
            break;
        }
        this.serverConnectorType.put(svrName, type);
    }

    String getServerConnectorType(String name) {
        return (String)this.serverConnectorType.get(name);
    }

    public void propertyChange(PropertyChangeEvent event2) {
        String currentState = (String)event2.getNewValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "propertyChange currentState = " + currentState + " isRipple = " + this.isRipple);
        }
        if (currentState.equals("STARTED")) {
            this.bootstrapNode();
        } else if (currentState.equals("DESTROYED")) {
            if (this.isRipple) {
                if (!this.ZOS) {
                    try {
                        this.reLaunchSelf();
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", (String)"944", (Object)this);
                        Tr.error(tc, "ADML0059E", ex.getMessage());
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ZOS setRestartFlag()");
                    }
                    AdminHelper.getPlatformHelper().setRestartFlag();
                }
            } else {
                this.saveNodeState(false, false);
            }
        }
    }

    public void stopServers() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopServers");
        }
        boolean attempted = true;
        Object nodeAgentServerName = null;
        Vector servers = null;
        try {
            servers = this.getServers();
        }
        catch (Exception ex) {
            Tr.debug(tc, "Error occured during stopServer", ex);
            throw new AdminException(ex, "An problem occurred during stopNode processing: ");
        }
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                String serverName = (String)servers.get(i);
                this.sendStop(serverName, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startServers() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServers");
        }
        Vector servers = null;
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            this.adoptedChildren.clear();
        }
        hashMap = this.launchedChildren;
        synchronized (hashMap) {
            this.launchedChildren.clear();
        }
        this.processHandlers.clear();
        try {
            servers = this.getServers();
        }
        catch (Exception ex) {
            throw new AdminException(ex, "An problem occurred during start Server processes: ");
        }
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                String serverName = (String)servers.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "starting Server : serverName");
                }
                if (serverName.equals(AdminHelper.getInstance().getNodeAgentName())) continue;
                this.launchProcess(serverName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServers");
        }
    }

    public void restart(Boolean syncFirst, Boolean restartServers) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restart", new Object[]{syncFirst, restartServers});
        }
        this.isBeingCalledByRestartMethod = true;
        AdminHelper.getInstance().audit("ADMN1004I", "ADMN1005I", (Object)new Object[]{this.nodeName, null});
        this.isRipple = true;
        this.saveNodeState(restartServers, true);
        if (syncFirst.booleanValue()) {
            Boolean syncd;
            try {
                syncd = NodeSync.getNodeSync().sync();
            }
            catch (Throwable th) {
                this.isRipple = false;
                this.saveNodeState(false, true);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, nls.getString("ADML0057E"));
            }
            if (syncd == null || !syncd.booleanValue()) {
                this.saveNodeState(false, true);
                this.isRipple = false;
                throw new AdminException(nls.getString("ADML0057E"));
            }
        }
        try {
            if (restartServers.booleanValue()) {
                this.stopNode();
            } else {
                this.sendStop(AdminHelper.getInstance().getNodeAgentName(), true);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.nodeagent.NodeAgent.restart", (String)"1002", (Object)this);
            Tr.error(tc, "ADML0058E");
            this.isRipple = false;
            this.saveNodeState(false, true);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, nls.getString("ADML0058E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restart");
        }
    }

    private void listenForSyncStartAndCompleteNofications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForSyncStartAndCompleteNofications");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName appserver = new ObjectName("WebSphere:type=NodeSync,*");
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.nodesync.initiated");
            filter.enableType("websphere.nodesync.complete");
            adminService.addNotificationListenerExtended(appserver, this, filter, SYNC_LISTENER);
        }
        catch (JMException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.listenForSyncStartAndCompleteNofications", (String)"2461", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForSyncStartAndCompleteNofications");
        }
    }

    private void reLaunchSelf() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reLaunchSelf");
        }
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.getRepositoryRootURI());
        sid.setServerName(AdminHelper.getInstance().getNodeAgentName());
        sid.setNodeName(this.nodeName);
        sid.setCellName(this.cellName);
        LaunchCommand launcher2 = new LaunchCommand(this.configService, this.variableMap, sid);
        launcher2.launchProcess();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ZOS " + this.ZOS);
        }
        if (!this.ZOS) {
            launcher2.launchProcess();
        } else {
            LaunchParams params = launcher2.getLaunchParams();
            String startCmd = params.getStartCommand();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Command", startCmd);
            }
            String startCmdArgs = "";
            Vector startCmdArgsVec = params.getStartCommandArgs();
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < startCmdArgsVec.size(); ++i) {
                buff.append((String)startCmdArgsVec.get(i));
            }
            startCmdArgs = buff.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Command Args", startCmdArgs);
            }
            if (startCmd != null && startCmd.trim().length() > 0) {
                PlatformUtils u = AdminServiceImpl.getPlatformUtils();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "platformutil: " + u);
                }
                if (u != null) {
                    u.setenv("control_region_start_cmd", startCmd + " " + startCmdArgs);
                    String envCheck = u.getenv("control_region_start_cmd");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "after getenv: " + envCheck);
                    }
                }
            }
            AdminHelper.getPlatformHelper().setRestartFlag();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reLaunchSelf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadNodeState() {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadNodeState");
            }
            String stFile = this.variableMap.expand(this.monitorFile);
            BufferedReader br = null;
            File f = new File(stFile);
            if (f.exists()) {
                String line;
                br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    int idx1 = line.indexOf(58);
                    int idx2 = line.lastIndexOf(58);
                    String pName = line.substring(0, idx1);
                    String pid = line.substring(idx1 + 1, idx2);
                    String force = line.substring(idx2 + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pName pid force = " + pName + " " + pid + " " + force);
                    }
                    this.isRestartingAllServers = Boolean.valueOf(force);
                    MonitorConfig cfg = (MonitorConfig)this.monitoringPolicies.get(pName);
                    if (cfg == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "this pid is set to running");
                    }
                    cfg.setPreviousState(1);
                    cfg.setPid(pid);
                }
            }
            Object var12_12 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block17;
            }
            catch (IOException ex2) {
                FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1065", (Object)this);
            }
            break block17;
            {
                catch (IOException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1058", (Object)this);
                    Object var12_13 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block17;
                    }
                    catch (IOException ex2) {
                        FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1065", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", (String)"1065", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNodeState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void saveNodeState(boolean restartServers, boolean calledByRestart) {
        block29: {
            if (NodeAgent.tc.isEntryEnabled()) {
                Tr.entry(NodeAgent.tc, "saveNodeState");
            }
            if (this.isBeingCalledByRestartMethod && !calledByRestart || this.isBeingCalledByStopNodeMethod) {
                if (NodeAgent.tc.isEntryEnabled() == false) return;
                Tr.exit(NodeAgent.tc, "saveNodeState -- no update");
                return;
            }
            stFile = this.variableMap.expand(this.monitorFile);
            if (NodeAgent.tc.isDebugEnabled()) {
                Tr.debug(NodeAgent.tc, "restartServers = " + restartServers + " monitorFile = " + stFile);
            }
            bw = null;
            try {
                f = new File(stFile);
                if (!f.exists()) {
                    f.createNewFile();
                }
                bw = new BufferedWriter(new FileWriter(f));
                if (this.profileKey != null) {
                    bw.write(AdminServiceFactory.getAdminService().getProcessName() + ":" + this.getOwnPid());
                } else {
                    bw.write(AdminHelper.getInstance().getNodeAgentName() + ":" + this.getOwnPid());
                }
                if (restartServers) {
                    bw.write(":true");
                } else {
                    bw.write(":false");
                }
                bw.newLine();
                var6_7 = this.launchedChildren;
                synchronized (var6_7) {
                    for (Map.Entry<K, V> entry : this.launchedChildren.entrySet()) {
                        bw.write(entry.getKey() + ":" + entry.getValue());
                        if (NodeAgent.tc.isDebugEnabled()) {
                            Tr.debug(NodeAgent.tc, "launchedChildren " + entry.getValue());
                        }
                        if (restartServers) {
                            bw.write(":true");
                        } else {
                            bw.write(":false");
                        }
                        bw.newLine();
                    }
                }
                var6_7 = this.adoptedChildren;
                synchronized (var6_7) {
                    for (Map.Entry<K, V> entry : this.adoptedChildren.entrySet()) {
                        bw.write(entry.getKey() + ":" + entry.getValue());
                        if (NodeAgent.tc.isDebugEnabled()) {
                            Tr.debug(NodeAgent.tc, "adoptedChildren " + entry.getValue());
                        }
                        if (restartServers) {
                            bw.write(":true");
                        } else {
                            bw.write(":false");
                        }
                        bw.newLine();
                    }
                }
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1109", (Object)this);
                var12_11 = null;
                if (bw != null) {
                    try {
                        bw.flush();
                        bw.close();
                    }
                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1119", (Object)this);
                    }
                }
                break block29;
            }
            var12_10 = null;
            if (bw == null) break block29;
            {
                catch (Throwable var11_16) {
                    var12_12 = null;
                    if (bw == null) throw var11_16;
                    ** try [egrp 4[TRYBLOCK] [8 : 656->669)] { 
lbl72:
                    // 1 sources

                    bw.flush();
                    bw.close();
                    throw var11_16;
lbl75:
                    // 1 sources

                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1119", (Object)this);
                    }
                    throw var11_16;
                }
                ** try [egrp 4[TRYBLOCK] [8 : 656->669)] { 
lbl79:
                // 1 sources

                bw.flush();
                bw.close();
lbl82:
                // 1 sources

                catch (IOException ex) {}
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.propertyChange", (String)"1119", (Object)this);
            }
        }
        if (NodeAgent.tc.isEntryEnabled() == false) return;
        Tr.exit(NodeAgent.tc, "saveNodeState");
    }

    private String getSavedPid(String processName) {
        MonitorConfig cfg = (MonitorConfig)this.monitoringPolicies.get(processName);
        if (cfg != null) {
            return cfg.getPid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getCurrentPid(String server) {
        String pid;
        block12: {
            pid = null;
            String pidFile = this.variableMap.expand("${LOG_ROOT}/" + server + "/" + server + ".pid");
            File f = new File(pidFile);
            if (f.exists()) {
                BufferedReader br = null;
                br = new BufferedReader(new FileReader(f));
                pid = br.readLine();
                Object var8_6 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                    break block12;
                }
                catch (IOException ex2) {
                    FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1162", (Object)this);
                }
                break block12;
                {
                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1155", (Object)this);
                        Object var8_7 = null;
                        try {
                            if (br != null) {
                                br.close();
                            }
                            break block12;
                        }
                        catch (IOException ex2) {
                            FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1162", (Object)this);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException ex2) {
                        FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", (String)"1162", (Object)this);
                    }
                    throw throwable;
                }
            }
        }
        return pid;
    }

    private void bootstrapNode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bootstrapNode");
        }
        NodeSync.getNodeSync().isConnected(120000L);
        Set s = this.monitoringPolicies.entrySet();
        ThreadPool tpool = null;
        int DEFINED_DEFAULT_SIZE = 5;
        int DEFINED_MAX_SIZE = 5;
        String propertyTPMaxSize = System.getProperty("com.ibm.websphere.management.nodeagent.bootstrap.maxthreadpool");
        if (propertyTPMaxSize == null) {
            propertyTPMaxSize = System.getProperty("threadpool.maxsize");
        }
        if (propertyTPMaxSize == null) {
            propertyTPMaxSize = new Integer(DEFINED_DEFAULT_SIZE).toString();
        }
        if (propertyTPMaxSize != null) {
            int TPMaxSize;
            try {
                TPMaxSize = Integer.parseInt(propertyTPMaxSize);
            }
            catch (Exception e) {
                Tr.audit(tc, "Invalid value entered for JVM custom property. All eligible application servers will be started in parallel.");
                TPMaxSize = -1;
            }
            if (TPMaxSize > DEFINED_MAX_SIZE) {
                TPMaxSize = DEFINED_MAX_SIZE;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "System property for maxthreadpool was larger than max value allowed.  Setting to max: " + TPMaxSize);
                }
            }
            if (TPMaxSize > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "maxthreadpool has value " + TPMaxSize);
                }
                tpool = new ThreadPool(null, 1, TPMaxSize);
            }
        }
        for (Map.Entry entry : s) {
            String pName = (String)entry.getKey();
            MonitorConfig cfg = (MonitorConfig)entry.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "process monitor policy: ", new Object[]{pName, cfg});
            }
            String currentPid = this.getCurrentPid(pName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pName = " + pName + " currentPid = " + currentPid);
            }
            if (currentPid != null && !currentPid.equals(this.getOwnPid())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, pName + " is already running");
                }
                try {
                    this.adoptChildProcess(pName, currentPid);
                }
                catch (ProcessOpException ex) {
                    currentPid = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, pName + " must be dead");
                    }
                }
            } else {
                currentPid = null;
            }
            if (currentPid != null) continue;
            if (!this.ZOS) {
                String savedPid = this.getSavedPid(pName);
                if (savedPid != null && !savedPid.equals(this.getOwnPid())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "going to adopt child process");
                    }
                    try {
                        this.adoptChildProcess(pName, savedPid);
                    }
                    catch (ProcessOpException ex) {
                        savedPid = null;
                    }
                } else {
                    savedPid = null;
                }
                if (savedPid != null) continue;
            }
            boolean shouldLaunchProcess = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRestartingAllServers = " + this.isRestartingAllServers);
            }
            if (this.isRestartingAllServers) {
                if (cfg.getPreviousState() == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "previousState was running");
                    }
                    shouldLaunchProcess = true;
                }
            } else {
                int restartState = cfg.getNodeRestartState();
                switch (restartState) {
                    case 1: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "restartState = RUNNING");
                        }
                        shouldLaunchProcess = true;
                        break;
                    }
                    case 0: {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "restartState = STOPPED");
                        break;
                    }
                    case 2: {
                        int previousState;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "restartState = PREVIOUS");
                        }
                        if ((previousState = cfg.getPreviousState()) != 1) break;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "previousState = RUNNING");
                        }
                        shouldLaunchProcess = true;
                    }
                }
            }
            if (!shouldLaunchProcess) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launching " + pName);
                }
                if (tpool == null) {
                    Thread thread = new Thread(new ProcessLauncher(pName));
                    thread.setDaemon(true);
                    thread.start();
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using threadpool.");
                }
                tpool.execute((Runnable)new ProcessLauncher(pName));
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.nodeRestart", (String)"2677", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "bootstrapNode: Unexpected error occured", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bootstrapNode");
        }
    }

    private String getOwnPid() {
        if (this.ownPid == null) {
            try {
                Process myproc = ProcessFactory.createSelf();
                String string = myproc.id();
            }
            catch (ProcessOpException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.getownPid", (String)"1269", (Object)this);
            }
        }
        return this.ownPid;
    }

    public void emitTryingToStopProcessNotification(String processName) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "emitTryingToStopProcessNotification", processName);
            }
            try {
                ObjectName nodeAgent = null;
                String query = "WebSphere:type=NodeAgent,node=" + this.nodeName + ",*";
                ObjectName queryName = new ObjectName(query);
                Set s = this.getAdminService().queryNames(queryName, null);
                if (s.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node agent MBean is not found");
                    }
                    return;
                }
                nodeAgent = (ObjectName)s.iterator().next();
                Notification notf = new Notification("websphere.process.initiatedStopping", nodeAgent, this.ntfySeqNum++);
                Properties props = new Properties();
                props.setProperty("nodeName", this.nodeName);
                props.setProperty("processName", processName);
                notf.setUserData(props);
                this.sendNotification(notf);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception, Node agent MBean was not found");
                e.printStackTrace();
            }
        }
    }

    void sendNotification(String type, String processName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendNotification", new Object[]{type, processName});
        }
        try {
            this.sendNotification(this.createNotification(type, processName));
        }
        catch (MBeanException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.nodeagent.sendNotification", (String)"1284", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendNotification");
        }
    }

    private void createMVSServicesMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMVSServicesMBean");
        }
        boolean enable = false;
        ConfigObject server = null;
        try {
            server = this.getServer(this.configService, 4, "server.xml");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.nodeagent.NodeAgent.createMVSServicesMBean", (String)"3063", (Object)this);
        }
        if (server == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMVSServicesMBean", "Failed to file NodeAgent server object");
            }
            return;
        }
        ConfigObject service2 = null;
        List props = null;
        List list = server.getObjectList("services");
        for (ConfigObject service2 : list) {
            if (!service2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "AdminService")) continue;
            props = service2.getObjectList("properties");
            break;
        }
        for (ConfigObject property : props) {
            String key = property.getString("name", "__null__");
            if (!"com.ibm.websphere.zos.mvsservices.enable".equals(key) || !"true".equalsIgnoreCase(property.getString("value", "__null__"))) continue;
            enable = true;
            break;
        }
        if (enable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to activate MVSServices MBean");
            }
            try {
                this.mbeanFactory.activateMBean("MVSServices", (RuntimeCollaborator)((Object)new MVSServices()), "MVSServices", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activated MVSServices MBean");
                }
            }
            catch (AdminException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.management.component.NodeAgent.createMVSServicesMBean", (String)"3111", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMVSServicesMBean", "enable = " + enable);
        }
    }

    protected String getRepositoryRootURI() {
        return this.configService.getPath();
    }

    public String getDiagnosticProviderName() {
        return sDPName;
    }

    public String getDiagnosticProviderId() {
        return this.getObjectName().toString();
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegisteredDiagnostics");
        }
        if (this.dpInfo == null) {
            InputStream regIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/management/nodeagent/NodeAgentDiagnosticProvider.xml");
            this.dpInfo = DiagnosticProviderHelper.loadRegistry(regIS, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegisteredDiagnostics", this.dpInfo);
        }
        return this.dpInfo;
    }

    public DiagnosticEvent[] configDump(String aLocalId, boolean aRegisteredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{aLocalId, new Boolean(aRegisteredOnly)});
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        DiagnosticTypedValue dtv = new DiagnosticTypedValue(System.getProperty("os.name"), "os.name.key");
        result.put(NodeAgentDiagnosticHelper.NODEAGENT_PLATFORM, dtv);
        dtv = new DiagnosticTypedValue(this.ZOS ? DEFAULT_LAUNCH_TIMEOUT_ZOS : DEFAULT_LAUNCH_TIMEOUT, "Launch.timeout.key");
        result.put(NodeAgentDiagnosticHelper.NODEAGENT_LAUNCHTIMEOUT, dtv);
        try {
            DiagnosticTypedValue.addCollectionToHashMap(result, NodeAgentDiagnosticHelper.NODEAGENT_SERVERS, this.getServers(), "Nodeagent.servers.key");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception getting servers", e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.configDump", (String)"2019", (Object)this);
            result.put(NodeAgentDiagnosticHelper.NODEAGENT_SERVERS, e.getMessage());
        }
        DiagnosticEvent de = DiagnosticEventFactory.createConfigDump(this.getObjectName().toString(), NodeAgent.class.getName(), "configDump", result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configDump", de);
        }
        return new DiagnosticEvent[]{de};
    }

    public DiagnosticEvent[] stateDump(String aLocalId, boolean aRegisteredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{aLocalId, new Boolean(aRegisteredOnly)});
        }
        HashMap result = null;
        result = new HashMap(2);
        HashSet set = new HashSet();
        set.addAll(this.adoptedChildren.keySet());
        set.addAll(this.launchedChildren.keySet());
        DiagnosticTypedValue.addCollectionToHashMap(result, NodeAgentDiagnosticHelper.NODEAGENT_DISCOVERED_SERVERS, set, "Nodeagent.discovered.servers.key");
        DiagnosticEvent de = DiagnosticEventFactory.createStateDump(this.getObjectName().toString(), NodeAgent.class.getName(), "stateDump", result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateDump", de);
        }
        return new DiagnosticEvent[]{de};
    }

    public DiagnosticEvent[] selfDiagnostic(String aLocalId, boolean aRegisteredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfDiagnostic", new Object[]{aLocalId});
        }
        if (this.dpInfo == null) {
            this.getRegisteredDiagnostics();
        }
        HashMap<String, DiagnosticTypedValue> total = null;
        if (aLocalId != null && (NodeAgentDiagnosticHelper.NODEAGENT_PING_SERVER.matches(aLocalId) || aLocalId.startsWith(NodeAgentDiagnosticHelper.NODEAGENT_PING_SERVER))) {
            total = new HashMap<String, DiagnosticTypedValue>();
            HashSet<String> clone = null;
            int index = aLocalId.lastIndexOf(46);
            if (index > -1) {
                String server = aLocalId.substring(index + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server", server);
                }
                if ("*".equals(server)) {
                    try {
                        clone = new HashSet(this.getServers());
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exception getting servers", e);
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.selfDiagnostic", (String)"3069", (Object)this);
                    }
                } else {
                    clone = new HashSet<String>(1);
                    clone.add(server);
                }
            }
            Iterator it = clone.iterator();
            String server = null;
            String state = "j2ee.state.stopped";
            while (it.hasNext()) {
                server = (String)it.next();
                if (server.equals("nodeagent")) {
                    state = "j2ee.state.running";
                } else {
                    state = "j2ee.state.stopped";
                    try {
                        AdminClient ac = RoutingTable.getInstance().getAdminClient(server);
                        if (ac != null && ac.isAlive() != null) {
                            state = "j2ee.state.running";
                        }
                    }
                    catch (ConnectorException ce) {
                        Tr.debug(tc, "ConnectorException checking AdminClient.isAlive", ce);
                    }
                }
                DiagnosticTypedValue dtv = new DiagnosticTypedValue(state, "Nodeagent.server.state");
                total.put(NodeAgentDiagnosticHelper.NODEAGENT_PING_SERVER + "." + server, dtv);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalid local id", aLocalId);
        }
        DiagnosticEvent de = DiagnosticEventFactory.createDiagnosticEvent(this.getObjectName().toString(), "selfDiagnostic", 10, NodeAgent.class.getName(), "selfDiagnostic", this.dpInfo.resourceBundleName, "NodeAgent.ping.respondingProperty.descriptionKey", null, total);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfDiagnostic", de);
        }
        return new DiagnosticEvent[]{de};
    }

    public String[] localize(String[] aKeys, Locale aLocale) {
        ResourceBundle bundle = ResourceBundle.getBundle(DIAGNOSTIC_BUNDLE, aLocale);
        String[] localized = new String[aKeys.length];
        for (int i = 0; i < aKeys.length; ++i) {
            localized[i] = bundle.getString(aKeys[i]);
        }
        return localized;
    }

    private void useXCFMonitor() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "useXCFMonitor");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "myXCFMemberName: " + this.myXCFMemberName + " myXCFGroup: " + this.myXCFGroup + " myXCFcheckInterval: " + this.myXCFcheckInterval);
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("LP_THIS_MEMBER_NAME", this.myXCFMemberName);
            config.put("LP_GROUP_NAME", this.myXCFGroup);
            config.put("LP_CHECK_INTERVAL_SECS", this.myXCFcheckInterval);
            try {
                GenLivenessPluginFactory factory = (GenLivenessPluginFactory)Class.forName("com.ibm.ws.xcf.groupservices.GenLivenessPluginZoSFactory").newInstance();
                this.lp = factory.createInstance(config);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.nodeagent.NodeAgent.useXCFMonitor", (String)"3801", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Got Exception trying to createInstance of Generic Liveness Plugin:", t);
            }
        }
        NAXCFJoinEventListener jel = new NAXCFJoinEventListener();
        this.lp.addJoinEventListener((GenJoinEventListener)jel);
        NAXCFLeaveEventListener lel = new NAXCFLeaveEventListener();
        this.lp.addLeaveEventListener((GenLeaveEventListener)lel);
        this.lp.start();
        long timeout = (this.myXCFcheckInterval.longValue() - 10L) * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial check alarm with timeout(millisecs): " + timeout);
        }
        this.checkAlarm = AlarmManager.createNonDeferrable((long)timeout, (AlarmListener)this, (Object)CHECK_ALARM_CONTEXT);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "useXCFMonitor");
        }
    }

    private int waitForXCFMonitor(String processName, int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForXCFMonitor", new Object[]{processName, new Integer(timeout).toString()});
        }
        int result = -2;
        if (timeout == 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, "timeout is zero, waiting indefinitely.");
        }
        RoutingTable rt = RoutingTable.getInstance();
        String memberName = rt.getmyXCFHostCellNode();
        memberName = memberName + processName;
        boolean timedOut = false;
        long ct = 0L;
        long topoint = System.currentTimeMillis() + (long)(timeout * 1000);
        while (!timedOut) {
            ct = System.currentTimeMillis();
            if (timeout == 0 || ct < topoint) {
                if (rt.isXCFGroupMember(memberName)) {
                    result = 0;
                    break;
                }
            } else {
                timedOut = true;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Interrupted Exception caught:", ie);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForXCFMonitor", result == 0 ? "SERVER_INIT_COMPLETE" : "TIMED_OUT");
        }
        return result;
    }

    public void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm - XCF check");
        }
        if (CHECK_ALARM_CONTEXT.equals(alarmContext)) {
            this.lp.check();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New check alarm with timeout(secs): " + this.myXCFcheckInterval.longValue());
            }
            AlarmManager.createNonDeferrable((long)(this.myXCFcheckInterval.longValue() * 1000L), (AlarmListener)this, (Object)CHECK_ALARM_CONTEXT);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm - XCF check");
        }
    }

    static {
        SYNC_LISTENER = new Integer(2);
        isSyncInProgress = false;
    }

    private class NAXCFLeaveEventListener
    implements GenLeaveEventListener {
        private NAXCFLeaveEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void memberLeft(String memberName, long context, String reason, long rc) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NAXCF memberLeft called for: " + memberName);
                Tr.debug(tc, "context:" + context + ",Reason:" + reason + ",Return code:" + rc);
            }
            if (context <= NodeAgent.this.lastXCFContext) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "memberLeft");
                return;
            }
            NodeAgent.this.lastXCFContext = context;
            boolean pushed = false;
            try {
                if (AdminServiceFactory.getAdminService().getProcessType().equals("AdminAgent")) {
                    String profileKey = NodeAgent.this.myXCFGroup.substring(NodeAgent.this.theXCFGroup.length());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "profileKey: " + profileKey);
                    }
                    pushed = AdminContext.push((String)profileKey);
                }
                RoutingTable rt = RoutingTable.getInstance();
                rt.removeXCFGroupMember(memberName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NAXCF members: " + rt.getXCFGroupMembers());
                }
                Object var10_7 = null;
                if (!pushed) return;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (!pushed) throw throwable;
                AdminContext.pop();
                throw throwable;
            }
            AdminContext.pop();
        }
    }

    private class NAXCFJoinEventListener
    implements GenJoinEventListener {
        private NAXCFJoinEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void memberJoined(String memberName, long context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NAXCF memberJoined called for: " + memberName + " with context: " + context + ",lastXCFContext:" + NodeAgent.this.lastXCFContext);
            }
            if (context <= NodeAgent.this.lastXCFContext) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "memberJoined");
                return;
            }
            NodeAgent.this.lastXCFContext = context;
            boolean pushed = false;
            try {
                RoutingTable rt;
                if (AdminServiceFactory.getAdminService().getProcessType().equals("AdminAgent")) {
                    String profileKey = NodeAgent.this.myXCFGroup.substring(NodeAgent.this.theXCFGroup.length());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "profileKey: " + profileKey);
                    }
                    pushed = AdminContext.push((String)profileKey);
                }
                if (!(rt = RoutingTable.getInstance()).isXCFGroupMember(memberName)) {
                    rt.addXCFGroupMember(memberName, new Long(context));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Member " + memberName + " is ALREADY a member of group. Recvd Context: " + context + " Why are we getting multiple joins?");
                    Tr.debug(tc, "Context from GroupMember: " + rt.getXCFGroupMember(memberName));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NAXCF members: " + rt.getXCFGroupMembers());
                }
                Object var7_5 = null;
                if (!pushed) return;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (!pushed) throw throwable;
                AdminContext.pop();
                throw throwable;
            }
            AdminContext.pop();
        }
    }

    class MonitorProcess
    extends Thread {
        String pName;
        String pid;
        boolean adoption;

        public MonitorProcess(String pName, String pid, boolean adoption) {
            this.pName = pName;
            this.pid = pid;
            this.adoption = adoption;
        }

        public void bindTo() throws ProcessOpException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Process Monitor run");
            }
            Process p = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception ex) {
                    break;
                }
                try {
                    p = ProcessFactory.bindTo((String)this.pid);
                    this.adoption = true;
                    break;
                }
                catch (ProcessOpException ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "failed to bind to process", (Object)ex);
                    continue;
                }
            }
            if (p != null) {
                String launchTimeout;
                if (this.adoption) {
                    NodeAgent.this.addAdoptedChild(this.pName, this.pid);
                }
                if ((launchTimeout = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout")) == null || launchTimeout.length() < 0) {
                    launchTimeout = AdminHelper.getPlatformHelper().isZOS() ? NodeAgent.DEFAULT_LAUNCH_TIMEOUT_ZOS : NodeAgent.DEFAULT_LAUNCH_TIMEOUT;
                }
                int timeout = Integer.parseInt(launchTimeout);
                Thread thr = new Thread(new PidWaiter(NodeAgent.this, p, this.pid, NodeAgent.this.variableMap, this.pName, timeout, this.adoption));
                thr.setDaemon(true);
                thr.start();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Process Monitor exit");
            }
        }

        public void run() {
            try {
                this.bindTo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ProcessLauncher
    extends Thread {
        private String serverName = null;

        public ProcessLauncher(String pName) {
            this.serverName = pName;
        }

        public void run() {
            block4: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "Process Launcher run");
                }
                try {
                    NodeAgent.this.launchProcess(this.serverName);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Error during starting server", this.serverName);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ProcessLauncher run");
            }
        }
    }

    class ProcessWatcher
    extends Thread {
        Process process;
        int statusSocketPort;
        int timeout;

        public ProcessWatcher(Process process, int statusSocketPort, int timeout) {
            this.process = process;
            this.statusSocketPort = statusSocketPort;
            this.timeout = timeout;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block27: {
                boolean launchFailed;
                block26: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    launchFailed = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timeout in run = " + this.timeout);
                    }
                    try {
                        if (this.process.isAlive()) {
                            block25: {
                                try {
                                    this.process.waitForTermination(this.timeout);
                                }
                                catch (ProcessStillActiveException ex) {
                                    if (!tc.isDebugEnabled()) break block25;
                                    Tr.debug(tc, "process " + this.process.id() + " is still running", (Object)ex);
                                }
                            }
                            if (!this.process.isAlive()) {
                                launchFailed = true;
                            }
                            break block26;
                        }
                        launchFailed = true;
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block26;
                        Tr.debug(tc, "can not determine whether process is alive", ex);
                    }
                }
                if (launchFailed) {
                    FilterOutputStream dos = null;
                    Socket soc = null;
                    soc = new Socket("localhost", this.statusSocketPort);
                    dos = new DataOutputStream(soc.getOutputStream());
                    ((DataOutputStream)dos).writeInt(-1);
                    Object var6_6 = null;
                    try {
                        if (dos != null) {
                            dos.close();
                        }
                        if (soc != null) {
                            soc.close();
                        }
                        break block27;
                    }
                    catch (Exception ex) {}
                    break block27;
                    {
                        catch (Exception ioe) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "failed to write back INIT_FAILED", ioe);
                            }
                            Object var6_7 = null;
                            try {
                                if (dos != null) {
                                    dos.close();
                                }
                                if (soc != null) {
                                    soc.close();
                                }
                                break block27;
                            }
                            catch (Exception ex) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        try {
                            if (dos != null) {
                                dos.close();
                            }
                            if (soc != null) {
                                soc.close();
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }
}

