/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.CellPackage;
import com.ibm.websphere.models.config.topology.cell.CellType;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollector;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.util.DebugUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ManagedObjectMetadataCollectorManagerImpl
implements com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager,
ManagedObjectMetadataCollectorManager {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollectorManagerImpl.class, "Admin", null);
    private static final String[][] EXPECTED_PRODUCT_IDS = ManagedObjectMetadataCollectorImpl.EXPECTED_PRODUCT_IDS;
    private static final String BOOTSTRAP_ADDR = "BOOTSTRAP_ADDRESS";
    private static final String SOAP_CONNECTOR_ADDRESS = "SOAP_CONNECTOR_ADDRESS";
    private static final int DOC_CHANGED_RETRY_COUNT = 2;
    private static ArrayList _collectors = null;
    private AdminClient _adminClient = null;
    private String _repositoryRoot = null;
    private Properties _inputProps;
    private String _cellName;
    private String _nodeName;
    private boolean _localOnly;

    public ManagedObjectMetadataCollectorManagerImpl(Properties inputProps, AdminClient adminClient) throws AdminException {
        this(inputProps, adminClient, false);
    }

    public ManagedObjectMetadataCollectorManagerImpl(Properties inputProps) throws AdminException {
        this(inputProps, null, true);
    }

    private ManagedObjectMetadataCollectorManagerImpl(Properties inputProps, AdminClient adminClient, boolean localOnly) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ManagedObjectMetadataCollectorManagerImpl(String, Properties, boolean)", new String[]{"Input props: " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)inputProps), "localOnly=" + localOnly});
        }
        if (adminClient == null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "ManagedObjectMetadataCollectorManagerImpl: Null AdminClient");
        }
        this._localOnly = localOnly;
        this._adminClient = adminClient;
        this.getInputProps(inputProps);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataCollectorManagerImpl(String, Properties, boolean)");
        }
    }

    private void getInputProps(Properties inputProps) throws AdminException {
        AdminService adminService;
        if (inputProps == null) {
            AdminException ae = new AdminException("Null Properties argument.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ManagedObjectMetadataCollectorManagerImpl: Null Properties", ae);
            }
            throw ae;
        }
        this._inputProps = inputProps;
        this._repositoryRoot = inputProps.getProperty("was.repository.root");
        if ((this._repositoryRoot == null || this._repositoryRoot.length() == 0) && (adminService = AdminServiceFactory.getAdminService()) == null) {
            AdminException ae = new AdminException("Property \"was.repository.root\" not defined or has a zero-length value.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ManagedObjectMetadataCollectorManagerImpl: Exception", ae);
            }
            throw ae;
        }
        this._cellName = inputProps.getProperty("local.cell");
        this._nodeName = inputProps.getProperty("local.node");
    }

    public Properties updateMetadata() throws AdminException {
        return this.updateMetadata("Collect Metadata", null);
    }

    public Properties updateMetadata(String action, Hashtable actionParams) throws AdminException {
        AdminException ae;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateMetadata");
        }
        if (action == null) {
            AdminException ae2 = new AdminException("The Managed Object Metadata Collector Manager was invoked with a null action.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Null action.", ae2);
            }
        }
        Properties updatedMetadata = null;
        ArrayList collectors = new ArrayList();
        try {
            this.getCollectors(collectors);
            if (_tc.isEventEnabled() && collectors.size() == 0) {
                Tr.event(_tc, "No managed object metadata collectors found.");
            }
        }
        catch (AdminException e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Received exception: " + e);
            }
            throw e;
        }
        int documentChangedRetryCount = 2;
        DocumentChangedException documentChangedException = null;
        do {
            try {
                Properties existingMetadata = new Properties();
                DocumentContentSource docContents = this.readMetadataFromConfig(existingMetadata);
                updatedMetadata = (Properties)existingMetadata.clone();
                int numCollectors = collectors.size();
                for (int i = 0; i < numCollectors; ++i) {
                    Object collector = collectors.get(i);
                    this.invokeCollector(collector, action, actionParams, updatedMetadata);
                }
                this.writeMetadataToConfig(docContents, existingMetadata, updatedMetadata);
                documentChangedRetryCount = -99;
            }
            catch (DocumentChangedException e) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateMetadataForNode: DocumentChangedException.", new Object[]{"retryCount=" + documentChangedRetryCount, e});
                }
                --documentChangedRetryCount;
                documentChangedException = e;
            }
            catch (AdminException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateMetadata: AdminException: ", e);
                }
                throw e;
            }
            catch (Exception e) {
                ae = new AdminException(e, "Could not complete metadata update.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateMetadata: Received exception: ", e);
                }
                throw ae;
            }
        } while (documentChangedRetryCount >= 0);
        if (documentChangedRetryCount == -1) {
            AdminException ae3 = new AdminException(documentChangedException, "Could not store metadata to the config repository after 2 retries.");
            Tr.exit(_tc, "invokeConfigRepository: Exhausted retry count.", ae3);
            throw ae3;
        }
        try {
            if (this._adminClient == null && !this._localOnly) {
                this._adminClient = this.createAdminClient();
            }
            if (this._adminClient != null) {
                ObjectName oName = this._adminClient.getServerMBean();
                String mbeanNodeName = oName.getKeyProperty("node");
                String mbeanProcessName = oName.getKeyProperty("process");
                this.invokeAdminOpsMBean(updatedMetadata, mbeanNodeName, mbeanProcessName);
            }
        }
        catch (AdminException e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Attempt to send metadata to Deployment Manager failed: " + e);
            }
            throw e;
        }
        catch (Exception e) {
            ae = new AdminException(e, "Could not complete metadata update.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Attempt to send metadata to Deployment Manager failed: ", e);
            }
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateMetadata", "updatedMetadata=" + updatedMetadata);
        }
        return updatedMetadata;
    }

    public Properties updateVersion5Metadata(ObjectName v5ServerMBeanObjectName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateVersion5Metadata", "v5ServerMBeanObjectName=" + v5ServerMBeanObjectName);
        }
        Properties updatedMetadata = null;
        int documentChangedRetryCount = 2;
        DocumentChangedException documentChangedException = null;
        do {
            try {
                String serverName;
                Properties existingMetadata = new Properties();
                DocumentContentSource docContents = this.readMetadataFromConfig(existingMetadata);
                updatedMetadata = (Properties)existingMetadata.clone();
                OneNodeAccessor accessor = new OneNodeAccessor(this._nodeName, updatedMetadata);
                ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
                String majorVersion = helper.getNodeMajorVersion(this._nodeName);
                if (!majorVersion.equals("5")) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getMetadataForVersion5Node: Not a v5 node.", "majorVersion=" + majorVersion);
                    }
                    return null;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMetadataForVersion5Node: Collecting v5 metadata.");
                }
                boolean propertyChanged = this.invokeServerMBean(v5ServerMBeanObjectName, updatedMetadata);
                String nodeName = v5ServerMBeanObjectName.getKeyProperty("node");
                if (propertyChanged |= this.invokeJVMMBean(nodeName, serverName = v5ServerMBeanObjectName.getKeyProperty("process"), updatedMetadata)) {
                    this.writeMetadataToConfig(docContents, existingMetadata, updatedMetadata);
                }
                documentChangedRetryCount = -99;
            }
            catch (DocumentChangedException e) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateVersion5Metadata: DocumentChangedException.", new Object[]{"retryCount=" + documentChangedRetryCount, e});
                }
                --documentChangedRetryCount;
                documentChangedException = e;
            }
            catch (MetadataNotAvailableException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateVersion5Metadata: Expected metadata missing.", (Object)e);
                }
                throw e;
            }
            catch (AdminException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateVersion5Metadata: AdminException: ", e);
                }
                throw e;
            }
            catch (Exception e) {
                AdminException ae = new AdminException(e, "Encountered error while attempting to collect v5 metadata.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateVersion5Metadata: Error occurred.", ae);
                }
                throw ae;
            }
        } while (documentChangedRetryCount >= 0);
        if (documentChangedRetryCount == -1) {
            AdminException ae = new AdminException(documentChangedException, "Could not store metadata to the config repository after 2 retries.");
            Tr.exit(_tc, "invokeConfigRepository: Exhausted retry count.", ae);
            throw ae;
        }
        return updatedMetadata;
    }

    private void getCollectors(ArrayList collectors) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCollectors");
        }
        ArrayList collectorInfo = ManagedObjectMetadataCollectorManagerImpl.getCollectorInfo();
        for (int i = 0; i < collectorInfo.size(); ++i) {
            String implClassName = ((CollectorInfo)collectorInfo.get((int)i)).className;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> implClass = classLoader.loadClass(implClassName);
                Constructor<?> implCtor = implClass.getConstructor(Properties.class);
                Properties inputProps = (Properties)this._inputProps.clone();
                Object implInst = implCtor.newInstance(inputProps);
                if (implInst instanceof ManagedObjectMetadataCollector || implInst instanceof com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector) {
                    collectors.add(implInst);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "getCollectors: Collector " + implClassName + " instantiated and added to list of collectors.");
                    continue;
                }
                FFDCFilter.processException((Throwable)new AdminException("getCollectors: Collector class " + implClassName + " does not implement expected interface.  Collector ignored."), (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.getCollectors", (String)"529", (Object)this);
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, "getCollectors: Collector class " + implClassName + " does not implement expected interface.  Collector ignored.");
                continue;
            }
            catch (Exception e) {
                AdminException ae = new AdminException(e, "Could not instantiate ManagedObjectMetadataCollector implementation class \"" + implClassName + "\".");
                FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.getCollectors", (String)"542", (Object)this);
                if (!_tc.isEntryEnabled()) continue;
                Tr.exit(_tc, "Could not instantiate ManagedObjectMetadataCollector implementation class \"" + implClassName + "\".", ae);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCollectors", "numCollectors=" + collectors.size());
        }
    }

    /*
     * Exception decompiling
     */
    private static ArrayList getCollectorInfo() throws AdminException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void invokeCollector(Object collObj, String action, Hashtable actionParams, Properties metadata2) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeCollector", new String[]{"action=" + action});
        }
        try {
            if (collObj instanceof com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector) {
                com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector collector = (com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector)collObj;
                collector.updateMetadata(action, actionParams, metadata2);
            } else if (action.equals("Collect Metadata")) {
                ManagedObjectMetadataCollector collector = (ManagedObjectMetadataCollector)collObj;
                metadata2.putAll((Map<?, ?>)collector.collectMetadata());
            } else if (_tc.isEventEnabled()) {
                Tr.event(_tc, "invokeCollector: Cannot invoke action on legacy collector.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.invokeCollector", (String)"737", (Object)this);
            String msg = "Metadata collection failed.  Received exception from collector " + collObj.getClass().getName() + ".";
            AdminException ae = new AdminException(e, msg);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "invokeCollector: " + msg, ae);
            }
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeCollector");
        }
    }

    private void invokeAdminOpsMBean(Properties metadata2, String mbeanNodeName, String mbeanProcessName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeAdminOpsMBean");
        }
        try {
            Set mbeans;
            StringBuffer queryString = new StringBuffer();
            queryString.append(this._adminClient.getDomainName());
            queryString.append(":");
            queryString.append("name");
            queryString.append("=");
            queryString.append("AdminOperations");
            queryString.append(",");
            queryString.append("node");
            queryString.append("=");
            queryString.append(mbeanNodeName);
            queryString.append(",");
            queryString.append("process");
            queryString.append("=");
            queryString.append(mbeanProcessName);
            queryString.append(",*");
            ObjectName querySpec = new ObjectName(queryString.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "invokeAdminOpsMBean", "query ObjectName=" + querySpec.toString());
            }
            try {
                mbeans = this._adminClient.queryNames(querySpec, null);
                if (mbeans == null) {
                    Tr.exit(_tc, "invokeAdminOpsMBean: Received null set from queryNames.");
                    return;
                }
                int setSize = mbeans.size();
                if (setSize == 0) {
                    Tr.exit(_tc, "invokeAdminOpsMBean: Received empty set from queryNames.");
                    return;
                }
                if (setSize > 1) {
                    Tr.event(_tc, "invokeAdminOpsMBean: Received set size greater than 1. Using only the first entry.", "querySetSize=" + setSize);
                }
            }
            catch (Throwable t) {
                Tr.debug(_tc, "invokeAdminOpsMBean: Received exception from queryNames.", t);
                throw t;
            }
            Iterator iter = mbeans.iterator();
            if (iter.hasNext()) {
                ObjectName oName = (ObjectName)iter.next();
                this._adminClient.invoke(oName, "updateMetadataForNode", new Object[]{this._nodeName, metadata2}, new String[]{"java.lang.String", "java.util.Properties"});
            }
        }
        catch (AdminException e) {
            Tr.exit(_tc, "invokeAdminOpsMBean: AdminException: ", e);
            throw e;
        }
        catch (Throwable t) {
            AdminException ae = new AdminException(t, "Could not send metadata to administrative server.");
            Tr.exit(_tc, "invokeAdminOpsMBean: Received exception: ", t);
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeAdminOpsMBean");
        }
    }

    private boolean invokeServerMBean(ObjectName v5ServerMBeanObjectName, Properties metadata2) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeServerMBean", "v5ServerMBeanObjectName=" + v5ServerMBeanObjectName.toString());
        }
        boolean propertyChanged = false;
        try {
            String prodVer = null;
            for (int i = 0; i < EXPECTED_PRODUCT_IDS.length; ++i) {
                String currentProdVer;
                Object o;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "invokeServerMBean: Collecting version info for " + EXPECTED_PRODUCT_IDS[i][0] + ".");
                }
                if ((prodVer = this.parseV5ProductVersionXML(o = this._adminClient.invoke(v5ServerMBeanObjectName, "getProductVersion", new Object[]{EXPECTED_PRODUCT_IDS[i][0]}, new String[]{"java.lang.String"}))) == null || prodVer.length() == 0) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "invokeServerMBean: Have version info for " + EXPECTED_PRODUCT_IDS[i][0] + ": " + prodVer);
                }
                if ((currentProdVer = metadata2.getProperty("com.ibm.websphere.baseProductVersion")) == null || !currentProdVer.equals(prodVer)) {
                    metadata2.setProperty("com.ibm.websphere.baseProductVersion", prodVer);
                    propertyChanged = true;
                    if (!_tc.isDebugEnabled()) break;
                    Tr.debug(_tc, "invokeServerMBean: Updating v5 version info.");
                    break;
                }
                Tr.debug(_tc, "invokeServerMBean: No change in v5 version.");
                break;
            }
            if (prodVer == null && _tc.isEventEnabled()) {
                Tr.event(_tc, "invokeServerMBean: Could not obtain product version for version 5 node.");
            }
        }
        catch (Throwable t) {
            AdminException ae = new AdminException(t, "Could not obtain metadata from version 5 node \"" + this._nodeName + "\".");
            Tr.exit(_tc, "invokeServerMBean: Received exception: ", t);
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeServerMBean", "propertyChanged=" + propertyChanged);
        }
        return propertyChanged;
    }

    private boolean invokeJVMMBean(String nodeName, String serverName, Properties metadata2) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeJVMMBean", new String[]{"nodeName=" + nodeName, "serverName=" + serverName});
        }
        boolean propertyChanged = false;
        try {
            Iterator iter;
            Set mbeans;
            StringBuffer queryString = new StringBuffer();
            queryString.append(this._adminClient.getDomainName());
            queryString.append(":");
            queryString.append("name");
            queryString.append("=");
            queryString.append("JVM");
            queryString.append(",");
            queryString.append("node");
            queryString.append("=");
            queryString.append(nodeName);
            queryString.append(",");
            queryString.append("process");
            queryString.append("=");
            queryString.append(serverName);
            queryString.append(",*");
            ObjectName querySpec = new ObjectName(queryString.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "invokeJVMMBean: querySpec: " + querySpec);
            }
            if ((mbeans = this._adminClient.queryNames(querySpec, null)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "invokeJVMMBean: No JVM MBeans returned from query.");
                }
                return false;
            }
            int setSize = mbeans.size();
            if (setSize == 0) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "invokeJVMMBean: Empty set returned from JVM MBean query.");
                }
                return false;
            }
            if (setSize > 1 && _tc.isEventEnabled()) {
                Tr.event(_tc, "invokeJVMMBean: More than one qualifying JVM MBean.");
            }
            if ((iter = mbeans.iterator()).hasNext()) {
                ObjectName oName = (ObjectName)iter.next();
                String osName = (String)this._adminClient.invoke(oName, "getProperty", new Object[]{"os.name"}, new String[]{"java.lang.String"});
                if (osName == null) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "invokeJVMMBean: Null os.name value returned from JVM MBean.");
                    }
                    return false;
                }
                if ((osName = ManagedObjectMetadataUtilities.normalizeOSName((String)osName)) == null) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "invokeJVMMBean: os.name value of \"" + osName + "\" could not be normalized.");
                    }
                    return false;
                }
                String currOS = metadata2.getProperty("com.ibm.websphere.nodeOperatingSystem");
                if (currOS == null || !currOS.equals(osName)) {
                    metadata2.setProperty("com.ibm.websphere.nodeOperatingSystem", osName);
                    propertyChanged = true;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "invokeJVMMBean: Updating v5 node OS to \"" + osName + "\".");
                    }
                } else {
                    Tr.debug(_tc, "invokeJVMMBean: No change in v5 node OS.");
                }
            }
        }
        catch (Throwable t) {
            AdminException ae = new AdminException(t, "Could not OS name from version 5 node \"" + this._nodeName + "\".");
            Tr.exit(_tc, "invokeJVMMBean: Received exception: ", t);
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeJVMMBean", "propertyChanged=" + propertyChanged);
        }
        return propertyChanged;
    }

    private String parseV5ProductVersionXML(Object getProdVerRetObj) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseV5ProductVersionXML", "xml=" + getProdVerRetObj);
        }
        if (getProdVerRetObj == null || !(getProdVerRetObj instanceof String)) {
            return null;
        }
        String v5ProdVerXML = (String)getProdVerRetObj;
        int i = v5ProdVerXML.indexOf("<version>");
        if (i < 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseV5ProductVersionXML: No <version> tag found. Returning null.");
            }
            return null;
        }
        int j = v5ProdVerXML.indexOf("</version>", i);
        if (j < 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseV5ProductVersionXML: No </version> tag found. Returning null.");
            }
            return null;
        }
        String retVer = v5ProdVerXML.substring(i + 9, j);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseV5ProductVersionXML", "v5ProdVer=" + retVer);
        }
        return retVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentContentSource readMetadataFromConfig(Properties readMetadata) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readMetadataFromConfig");
        }
        DocumentContentSource docContents = null;
        try {
            ConfigRepository repo;
            String docURI = ConfigStructureHelper.getURI((String)this._cellName, (String)this._nodeName, (String)"", (String)"node-metadata.properties");
            Properties rProps = new Properties();
            String pKey = AdminContext.peek();
            if (pKey == null) {
                rProps.setProperty("location", "local");
            } else {
                rProps.setProperty("location", "profilekey");
                rProps.setProperty("profileKey", pKey);
            }
            rProps.setProperty("com.ibm.ws.management.standalone", "true");
            if (this._repositoryRoot != null) {
                rProps.setProperty("was.repository.root", this._repositoryRoot);
            }
            if ((repo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)rProps)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "readMetadataFromConfig: Null ConfigRepository.");
                }
                throw new AdminException("ManagedObjectMetadataCollectorManagerImpl.readMetadataFromConfig: Null ConfigRepository.");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readMetadataFromConfig: Extracting " + docURI);
            }
            docContents = repo.extract(docURI);
            InputStream inStream = docContents.getSource();
            try {
                readMetadata.load(inStream);
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    Tr.event(_tc, "Could not close node metadata properties file input stream.", e);
                }
                throw throwable;
            }
            try {
                inStream.close();
            }
            catch (IOException e) {
                Tr.event(_tc, "Could not close node metadata properties file input stream.", e);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.readMetadataFromConfig", (String)"1129", (Object)this);
            AdminException ae = new AdminException(e, "Error occurred attempting to read metadata from the config repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "readMetadataFromConfig: Received unexpected exception.", ae);
            }
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readMetadataFromConfig");
        }
        return docContents;
    }

    private void writeMetadataToConfig(DocumentContentSource docContents, Properties existingMetadata, Properties updatedMetadata) throws DocumentChangedException, AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeMetadataToConfig");
        }
        if (existingMetadata.equals(updatedMetadata)) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeMetadataToConfig: No changes.  File not updated.");
            }
            return;
        }
        try {
            ConfigRepository repo;
            Properties rProps = new Properties();
            String pKey = AdminContext.peek();
            if (pKey == null) {
                rProps.setProperty("location", "local");
            } else {
                rProps.setProperty("location", "profilekey");
                rProps.setProperty("profileKey", pKey);
            }
            rProps.setProperty("com.ibm.ws.management.standalone", "true");
            if (this._repositoryRoot != null) {
                rProps.setProperty("was.repository.root", this._repositoryRoot);
            }
            if ((repo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)rProps)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "writeMetadataToConfig: Null ConfigRepository.");
                }
                return;
            }
            String docURI = ConfigStructureHelper.getURI((String)this._cellName, (String)this._nodeName, (String)"", (String)"node-metadata.properties");
            Document doc = new Document(docURI);
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            updatedMetadata.store(baOut, null);
            byte[] docBytes = baOut.toByteArray();
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "writeMetadataToConfig: Modifying " + docURI);
                }
                ByteArrayInputStream source = new ByteArrayInputStream(docBytes);
                if (docContents != null) {
                    docContents.setSource((InputStream)source);
                } else {
                    docContents = new DocumentContentSource(doc, (InputStream)source);
                }
                DocumentDigest digest = repo.modify(docContents);
            }
            catch (DocumentNotFoundException repE) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "writeMetadataToConfig: Creating " + docURI);
                }
                ByteArrayInputStream source = new ByteArrayInputStream(docBytes);
                docContents.setSource((InputStream)source);
                DocumentDigest digest = repo.create(docContents);
            }
        }
        catch (DocumentChangedException e) {
            if (_tc.isEventEnabled()) {
                Tr.exit(_tc, "writeMetadataToConfig: DocumentChangedException.", e);
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.writeMetadataToConfig", (String)"1223", (Object)this);
            AdminException ae = new AdminException(e, "Error occurred attempting to store metadata to the config repository.");
            Tr.exit(_tc, "writeMetadataToConfig: Received unexpected exception.", e);
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeMetadataToConfig");
        }
    }

    private AdminClient createAdminClient() {
        EndPoint[] dmgrEndpoints;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createAdminClient");
        }
        if ((dmgrEndpoints = this.getDMgrEndpoints()) == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createAdminClient", "AdminClient not created");
            }
            return null;
        }
        AdminClient adminClient = null;
        for (int i = 0; i < 2; ++i) {
            String connType = i == 0 ? "SOAP" : "RMI";
            String inputConnType = this._inputProps.getProperty("type");
            if (inputConnType != null && !inputConnType.equals(connType)) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Caller specified connector type " + inputConnType + ".  Skipping connector type " + connType);
                continue;
            }
            String host = this._inputProps.getProperty("host");
            String port = this._inputProps.getProperty("port");
            if (dmgrEndpoints[i] == null && (host == null || port == null)) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Incomplete or no endpoint data for connector type " + connType);
                continue;
            }
            Properties connProps = new Properties();
            if (host == null) {
                host = dmgrEndpoints[i].getHost();
            }
            if (port == null) {
                port = new Integer(dmgrEndpoints[i].getPort()).toString();
            }
            connProps.setProperty("type", connType);
            connProps.setProperty("host", host);
            connProps.setProperty("port", port);
            connProps.putAll((Map<?, ?>)this._inputProps);
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Creating AdminClient", new String[]{"host=" + host, "port=" + port});
                }
                adminClient = AdminClientFactory.createAdminClient(connProps);
                break;
            }
            catch (Exception e) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Could not create AdminClient: connType=" + connType, e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createAdminClient", adminClient == null ? "AdminClient not created" : "AdminClient created.");
        }
        return adminClient;
    }

    private EndPoint[] getDMgrEndpoints() {
        EndPoint[] dmgrEndpoints;
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getDMgrEndpoints");
            }
            dmgrEndpoints = new EndPoint[2];
            try {
                Properties rProps = new Properties();
                String pKey = AdminContext.peek();
                if (pKey == null) {
                    rProps.setProperty("location", "local");
                } else {
                    rProps.setProperty("location", "profilekey");
                    rProps.setProperty("profileKey", pKey);
                }
                ConfigRepository repo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)rProps);
                ConfigInit.init();
                ServerindexPackage sipkg = ServerindexPackage.eINSTANCE;
                CellPackage cellpkg = CellPackage.eINSTANCE;
                ResourcesPackage resourcespkg = ResourcesPackage.eINSTANCE;
                String cellURIString = ConfigStructureHelper.getURI((String)this._cellName, (String)"", (String)"", (String)"cell.xml");
                DocumentContentSource cellDCS = repo.extract(cellURIString);
                WASResourceSetImpl cellResSet = new WASResourceSetImpl();
                URI cellURI = URI.createFileURI(cellDCS.getDocument().getURI());
                Resource cellRes = cellResSet.createResource(cellURI);
                cellRes.load(cellDCS.getSource(), new HashMap());
                Cell cell = (Cell)cellRes.getContents().get(0);
                CellType cellType = cell.getCellType();
                if (cellType.equals(CellType.DISTRIBUTED_LITERAL)) {
                    String nodesURI = ConfigStructureHelper.getURI((String)this._cellName, (String)"", (String)"", (String)"nodes");
                    String[] nodes = repo.listResourceNames(nodesURI, 2, 1);
                    boolean dmgrFound = false;
                    block2: for (int i = 0; i < nodes.length && !dmgrFound; ++i) {
                        String docURIString = nodes[i] + "/serverindex.xml";
                        DocumentContentSource siDCS = repo.extract(docURIString);
                        WASResourceSetImpl siResSet = new WASResourceSetImpl();
                        URI siURI = URI.createFileURI(siDCS.getDocument().getURI());
                        Resource siRes = siResSet.createResource(siURI);
                        siRes.load(siDCS.getSource(), new HashMap());
                        ServerIndex si = (ServerIndex)siRes.getContents().get(0);
                        String currNodeName = nodes[i].substring(nodes[i].lastIndexOf(47) + 1);
                        EList servers = si.getServerEntries();
                        for (int j = 0; j < servers.size(); ++j) {
                            ServerEntry se = (ServerEntry)servers.get(j);
                            String st = se.getServerType();
                            if (st == null || !st.equals("DEPLOYMENT_MANAGER")) continue;
                            dmgrFound = true;
                            if (currNodeName.equals(this._nodeName)) {
                                if (_tc.isEntryEnabled()) {
                                    Tr.exit(_tc, "getDMgrEndpoints: Local node is dmgr node.");
                                }
                                return null;
                            }
                            EList endpoints = se.getSpecialEndpoints();
                            int numEP = 0;
                            for (int k = 0; k < endpoints.size() && numEP < 2; ++k) {
                                EndPoint ep;
                                NamedEndPoint nep = (NamedEndPoint)endpoints.get(k);
                                if (nep.getEndPointName().equals(SOAP_CONNECTOR_ADDRESS)) {
                                    ep = nep.getEndPoint();
                                    if (ep == null) continue;
                                    dmgrEndpoints[0] = ep;
                                    ++numEP;
                                    continue;
                                }
                                if (!nep.getEndPointName().equals(BOOTSTRAP_ADDR) || (ep = nep.getEndPoint()) == null) continue;
                                dmgrEndpoints[1] = ep;
                                ++numEP;
                            }
                            continue block2;
                        }
                    }
                    break block15;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.exit(_tc, "getDMgrEndpoints: Cell is not distributed.");
                }
                return null;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.getDMgrEndpoints", (String)"1357", (Object)this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getDMgrEndpoints: Could not read configuration.", e);
                }
                return null;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getDMgrEndpoints: Returning endpoints:", dmgrEndpoints);
        }
        return dmgrEndpoints;
    }

    private static class OneNodeAccessor
    implements ManagedObjectMetadataAccessor {
        private String _accessedNode;
        private Properties _metadata;

        public OneNodeAccessor(String nodeName, Properties metadata2) {
            this._accessedNode = nodeName;
            this._metadata = metadata2;
        }

        public Properties getMetadataProperties(String nodeName) throws AdminException {
            if (nodeName.equals(this._accessedNode)) {
                return this._metadata;
            }
            AdminException ae = new AdminException("Invalid node name \"" + nodeName + "\"specified. Expected \"" + this._accessedNode + "\".");
            FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.OneNodeAccessor.getMetadataProperties", (String)"1531", (Object)this);
            throw ae;
        }

        public String getMetadataProperty(String nodeName, String propertyName) throws AdminException {
            Properties metadata2 = this.getMetadataProperties(nodeName);
            return metadata2.getProperty(propertyName);
        }
    }

    private static class CollectorInfo {
        public String className;

        private CollectorInfo() {
        }

        public String toString() {
            return "CollectorInfo{collector-class=" + this.className + "}";
        }
    }

    private static class CollectorHandler
    extends DefaultHandler {
        Locator _locator;
        ArrayList _collectors = new ArrayList();
        CollectorInfo _currentCollector;
        URL _currentURL;
        StringBuffer value = new StringBuffer();

        public void setURL(URL url) {
            this._currentURL = url;
        }

        public ArrayList getCollectors() {
            return this._collectors;
        }

        public void startDocument() throws SAXException {
            this._collectors.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (qName.equals("metadata-collector")) {
                this._currentCollector = new CollectorInfo();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._currentCollector == null) {
                return;
            }
            if (qName.equals("metadata-collector")) {
                if (this._currentCollector.className == null) {
                    throw new SAXException("Missing name in " + this._currentURL + " at line " + this._locator.getLineNumber());
                }
                Tr.debug(_tc, "XML parse results: " + this._currentCollector);
                this._collectors.add(this._currentCollector);
                this._currentCollector = null;
            } else {
                if (!qName.equals("collector-class")) throw new SAXParseException("Invalid tag: " + qName, this._locator);
                if (this._currentCollector.className != null) throw new SAXParseException("Multiple classes defined", this._locator);
                this._currentCollector.className = this.value.toString();
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException arg0) throws SAXException {
            this._currentCollector = null;
        }

        public void error(SAXParseException arg0) throws SAXException {
            this._currentCollector = null;
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            this._collectors.clear();
            this._currentCollector = null;
            throw arg0;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.value.append(ch, start, length);
        }

        public void setDocumentLocator(Locator arg0) {
            this._locator = arg0;
        }
    }
}

