/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.runtime.provisioning.ActivationPlanUtil2;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManagedObjectMetadataCollectorImpl
implements ManagedObjectMetadataCollector {
    static final String ACTION_PARAM_PROFILE_TYPE = "Base Profile Type";
    static final String BASE_EXTENSION_ID = "base";
    static final String PROFILE_TYPE_DMGR = "dmgr";
    static final String PROFILE_TYPE_MANAGED = "managed";
    static final String PROFILE_TYPE_DEFAULT = "default";
    static final String PROFILE_TYPE_ADMINAGENT = "adminagent";
    static final String PROFILE_TYPE_JOBMGR = "jobmgr";
    static final String PROFILE_TYPE_SECUREPROXY = "secureproxy";
    static final String[] PROFILE_TYPES = new String[]{"dmgr", "adminagent", "jobmgr", "managed", "default", "secureproxy"};
    static final String[][] EXPECTED_PRODUCT_IDS = new String[][]{{"BASE", "Base"}, {"ND", "ND"}, {"NDDMZ", "NDDMZ"}, {"EXPRESS", "Express"}, {"embeddedEXPRESS", "Express"}};
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollector.class, "Admin", null);
    private static final String[] STANDALONE_CELL_FEATURE_FILTERS = new String[]{"com.ibm.ws.base_", "com.ibm.ws.express_", "com.ibm.ws.j2ee_", "com.ibm.ws.uddi_", "com.ibm.ws.wsgateway_"};
    private static final String[] DMGR_FEATURE_FILTERS = new String[]{"com.ibm.ws.base_", "com.ibm.ws.express_", "com.ibm.ws.j2ee_", "com.ibm.ws.nd_", "com.ibm.ws.uddi_", "com.ibm.ws.wsgateway_"};
    private static final String[] MANAGED_FEATURE_FILTERS = DMGR_FEATURE_FILTERS;
    private static final String[] ADMINAGENT_FEATURE_FILTERS = new String[]{"com.ibm.ws.adminagent_"};
    private static final String[] JOBMGR_FEATURE_FILTERS = new String[]{"com.ibm.ws.jobmanager_"};
    private static final String[] SECUREPROXY_FEATURE_FILTERS = new String[]{"com.ibm.ws.proxy_"};
    private Properties _inputProps;
    private Properties _metadata;
    private Exception _e = null;

    public ManagedObjectMetadataCollectorImpl(Properties inputProps) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ManagedObjectMetadataCollectorImpl(Properties)", "Input props: " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)inputProps));
        }
        this._inputProps = inputProps;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataCollectorImpl(Properties)");
        }
    }

    public void updateMetadata(String action, Hashtable actionParams, Properties metadata2) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateMetadata", new String[]{"action=" + action, "actionParams=" + actionParams, "metadata(in)=" + metadata2});
        }
        try {
            if (action == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateMetadata: Null action.  No action taken.");
                }
            } else if (action.equals("Collect Metadata")) {
                this.collectMetadata(metadata2);
            } else if (action.equals("Add Extension")) {
                String extID = (String)actionParams.get("param.action.extension.id");
                if (extID != null && extID.equals(BASE_EXTENSION_ID)) {
                    String profileType = (String)actionParams.get(ACTION_PARAM_PROFILE_TYPE);
                    this.appendBaseFeatures(metadata2, profileType);
                    this.collectAppActivationPlans(metadata2, profileType);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "updateMetadata: Extension ID not recognized or not present.  No action taken.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateMetadata: Action not recognized.  No action taken.");
            }
        }
        catch (Exception e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Exception: " + e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateMetadata", new String[]{"metadata(out)=" + metadata2});
        }
    }

    private void collectMetadata(Properties metadata2) throws AdminException {
        Properties tempMetadata = new Properties();
        this.collectVersionInfo(tempMetadata);
        String osName = System.getProperty("os.name");
        osName = ManagedObjectMetadataUtilities.normalizeOSName((String)osName);
        if (osName != null) {
            String sysplex;
            tempMetadata.setProperty("com.ibm.websphere.nodeOperatingSystem", osName);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "collectMetadata:", "osName=" + osName);
            }
            if (osName.equals("os390") && (sysplex = AdminHelper.getPlatformHelper().getSysplexName()) != null && sysplex.length() > 0) {
                tempMetadata.setProperty("com.ibm.websphere.nodeSysplexName", sysplex);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "collectMetadata:", "sysplex=" + sysplex);
                }
            }
        } else {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Could not obtain operating system name.");
            }
            throw new AdminException("Could not obtain operating system name.");
        }
        metadata2.putAll((Map<?, ?>)tempMetadata);
    }

    private void collectVersionInfo(Properties metadata2) throws AdminException {
        String prodVer = null;
        try {
            WASProduct wasProd = new WASProduct(this._inputProps.getProperty("was.install.root"));
            for (int i = 0; i < EXPECTED_PRODUCT_IDS.length; ++i) {
                product prod;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "collectVersionInfo: Collecting version info for " + EXPECTED_PRODUCT_IDS[i][0] + ".");
                }
                if ((prod = wasProd.getProductById(EXPECTED_PRODUCT_IDS[i][0])) == null || (prodVer = prod.getVersion()) == null) continue;
                metadata2.setProperty("com.ibm.websphere.baseProductVersion", prodVer);
                metadata2.setProperty("com.ibm.websphere.baseProductShortName", EXPECTED_PRODUCT_IDS[i][1]);
                break;
            }
        }
        catch (Exception e) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Caught exception.", e);
            }
            throw new AdminException(e, "Could not obtain product version.");
        }
        if (prodVer == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Could not obtain product version.");
            }
            throw new AdminException("Could not obtain product version.");
        }
    }

    private void collectAppActivationPlans(Properties metadata2, String profileType) throws AdminException {
        if (profileType.equals(PROFILE_TYPE_MANAGED)) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectAppActivationPlans: No application actiavtion plan for the specified profile type. profileType=" + profileType);
            }
            return;
        }
        Properties tempMetadata = new Properties();
        String appActivationPlans = ActivationPlanUtil2.getBaseApplicationPlans();
        if (appActivationPlans != null) {
            tempMetadata.setProperty("com.ibm.websphere.baseRuntimeComponents", appActivationPlans);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "collectAppActivationPlans:", "appActivationPlans =" + appActivationPlans);
            }
        } else {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectAppActivationPlans: Could not obtain application activation plans.");
            }
            throw new AdminException("Could not obtain application activation plans.");
        }
        metadata2.putAll((Map<?, ?>)tempMetadata);
    }

    private void appendBaseFeatures(Properties metadata2, String profileType) throws Exception {
        block17: {
            String installRootPath;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "appendbaseFeatures: profileType = " + profileType);
            }
            if ((installRootPath = this._inputProps.getProperty("was.install.root")) == null) {
                AdminException ae = new AdminException("No install root path provided.");
                FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl.appendBaseFeatures", (String)"205", (Object)this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "appendBaseFeatures: No install root path.", ae);
                }
                throw ae;
            }
            String featuresDirPath = installRootPath + File.separator + "features";
            File featuresDir = new File(featuresDirPath);
            if (!featuresDir.exists()) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "appendBaseFeatures: No features directory found under the install root directory, " + installRootPath + ".");
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "appendbaseFeatures: No features added.");
                }
                return;
            }
            if (!featuresDir.isDirectory()) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "appendBaseFeatures: The path \"" + featuresDirPath + "\" does not resolve to a directory.");
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "appendbaseFeatures: No features added.");
                }
                return;
            }
            try {
                String comma;
                StringBuffer propBuff;
                String featuresProp = metadata2.getProperty("com.ibm.websphere.deployed.features");
                Set existingFeatures = this.parseFeaturesProp(featuresProp);
                String[] newFeatures = featuresDir.list(new FeatureFileFilter(profileType));
                if (featuresProp == null) {
                    propBuff = new StringBuffer();
                    comma = "";
                } else {
                    propBuff = new StringBuffer(featuresProp);
                    comma = ",";
                }
                int addCount = 0;
                for (int i = 0; i < newFeatures.length; ++i) {
                    String newFeature = newFeatures[i];
                    if (existingFeatures.contains(newFeature)) continue;
                    propBuff.append(comma);
                    propBuff.append(newFeature);
                    ++addCount;
                    comma = ",";
                }
                if (addCount > 0) {
                    featuresProp = propBuff.toString();
                    Tr.debug(_tc, "appendBaseFeatures: setting featuures list:", "featuresProp=" + featuresProp);
                    metadata2.setProperty("com.ibm.websphere.deployed.features", featuresProp);
                } else {
                    Tr.debug(_tc, "appendBaseFeatures: No features added.");
                }
            }
            catch (Exception e) {
                if (!_tc.isEventEnabled()) break block17;
                Tr.event(_tc, "appendBaseFeatures: Exception received:", e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "appendbaseFeatures");
        }
    }

    private Set parseFeaturesProp(String featuresProp) {
        String feature;
        HashSet<String> featuresSet = new HashSet<String>();
        if (featuresProp == null || featuresProp.length() == 0) {
            return featuresSet;
        }
        int bi = 0;
        int ei = featuresProp.indexOf(44);
        while (ei != -1) {
            feature = featuresProp.substring(bi, ei).trim();
            if (feature.length() > 0) {
                featuresSet.add(feature);
            }
            bi = ei + 1;
            ei = featuresProp.indexOf(44, bi);
        }
        feature = featuresProp.substring(bi).trim();
        if (feature.length() > 0) {
            featuresSet.add(feature);
        }
        return featuresSet;
    }

    private class FeatureFileFilter
    implements FilenameFilter {
        private String _profileType;
        private String[] _featureFilters;

        public FeatureFileFilter(String profileType) {
            this._profileType = profileType;
            if (profileType.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_DMGR)) {
                this._featureFilters = DMGR_FEATURE_FILTERS;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_MANAGED)) {
                this._featureFilters = MANAGED_FEATURE_FILTERS;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_DEFAULT)) {
                this._featureFilters = STANDALONE_CELL_FEATURE_FILTERS;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_ADMINAGENT)) {
                this._featureFilters = ADMINAGENT_FEATURE_FILTERS;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_JOBMGR)) {
                this._featureFilters = JOBMGR_FEATURE_FILTERS;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_SECUREPROXY)) {
                this._featureFilters = SECUREPROXY_FEATURE_FILTERS;
            } else {
                FFDCFilter.processException((Throwable)new AdminException("No feature filters for profile type " + profileType), (String)"com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl.FilenameFilter.FeatureFileFilter", (String)"362", (Object)this);
                this._featureFilters = null;
            }
        }

        public boolean accept(File dir, String name) {
            if (this._featureFilters == null) {
                return false;
            }
            for (int i = 0; i < this._featureFilters.length; ++i) {
                if (!name.startsWith(this._featureFilters[i])) continue;
                File childDir = new File(dir.getAbsolutePath() + File.separator + name);
                return childDir.isDirectory();
            }
            return false;
        }
    }
}

