/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import java.util.Properties;

public class CollectManagedObjectMetadata {
    private static final String TRACE_FILE_NAME = "CollectManagedObjectMetadataTrace.log";
    private static final String[] PROFILE_TYPES = ManagedObjectMetadataCollectorImpl.PROFILE_TYPES;

    public static void main(String[] args) throws Exception {
        String traceString = null;
        boolean add = false;
        String profileType = null;
        try {
            ManagedObjectMetadataCollectorManager manager;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                ConfigInit.init();
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-traceString")) {
                    if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                        traceString = args[++i];
                        continue;
                    }
                    traceString = "com.ibm.*=all=enabled";
                    continue;
                }
                if (!args[i].equals("-add")) continue;
                add = true;
                if (i < args.length - 1) {
                    if ((profileType = args[++i]).startsWith("-")) {
                        throw new AdminException("Command syntax error.  Invalid profile type: " + profileType);
                    }
                    boolean match = false;
                    for (int j = 0; j < PROFILE_TYPES.length; ++j) {
                        if (!profileType.equals(PROFILE_TYPES[j])) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    throw new AdminException("Command syntax error.  Unrecognized profile type: " + profileType);
                }
                throw new AdminException("Command syntax error.  No profile type specified.");
            }
            if (traceString != null) {
                try {
                    ManagerAdmin.configureClientTrace(traceString, "named file", TRACE_FILE_NAME, false, "basic", false);
                    System.out.println("Trace enabled.  Writing to log file \"CollectManagedObjectMetadataTrace.log\".");
                }
                catch (Exception e) {
                    System.out.println("Trace setup failed.");
                    e.printStackTrace();
                }
            }
            if ((manager = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null)) == null) {
                throw new AdminException("Could not initialize ManagedObjectMetadataCollector");
            }
            if (add) {
                System.out.println("ACTION: Add to profile.  Profile type: " + profileType);
                Properties actionParams = new Properties();
                actionParams.setProperty("param.action.extension.id", "base");
                actionParams.setProperty("Base Profile Type", profileType);
                manager.updateMetadata("Add Extension", actionParams);
            }
            System.out.println("ACTION: Collect");
            Properties collectedProps = manager.updateMetadata("Collect Metadata", null);
            System.out.println(collectedProps.toString());
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Metadata collection failed.");
            e.printStackTrace();
            throw e;
        }
    }
}

