/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import java.util.Date;
import java.util.Vector;

public class UnixLaunchScriptCollaborator
implements LaunchScriptPlatformCollaborator {
    public String customizeScriptFilename(String filename) {
        return filename + ".sh";
    }

    public String buildScriptHeader(String filename) {
        StringBuffer header = new StringBuffer();
        header.append(this.getPlatformComment());
        header.append("!/bin/sh\n");
        header.append(this.getPlatformComment());
        header.append(" ");
        header.append(filename);
        header.append("\n");
        header.append(this.getPlatformComment());
        Date now = new Date();
        header.append(" Generated: " + now.toString());
        header.append("\n");
        header.append("\n");
        header.append(this.getPlatformComment());
        header.append(" Bootstrap values ...");
        header.append("\n");
        if (System.getProperty("user.install.root") != null) {
            header.append("binDir=" + System.getProperty("user.install.root") + "/bin");
        } else {
            header.append("binDir=`dirname $0`");
        }
        header.append("\n");
        header.append(". $binDir/setupCmdLine.sh");
        header.append("\n");
        header.append("\n");
        header.append(this.getPlatformComment());
        header.append(" For debugging the server process:");
        header.append("\n");
        header.append(this.getPlatformComment());
        header.append(" export DEBUG=\"-Djava.compiler=NONE");
        header.append(" -Xdebug -Xnoagent");
        header.append(" -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=7777\"");
        header.append("\n");
        return header.toString();
    }

    public String buildEnvSettings(Vector env) {
        StringBuffer envbuff = new StringBuffer();
        envbuff.append(this.getPlatformComment());
        envbuff.append(" Environment Settings\n");
        envbuff.append("PLATFORM=`/bin/uname`\n");
        envbuff.append("case $PLATFORM in\n");
        envbuff.append("  AIX)\n");
        envbuff.append("    EXTSHM=ON\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dibm.websphere.preload.classes=true\"\n");
        envbuff.append("    LIBPATH=\"$WAS_LIBPATH\":$LIBPATH\n");
        envbuff.append("    export LIBPATH EXTSHM ;;\n");
        envbuff.append("  Linux)\n");
        envbuff.append("    LD_LIBRARY_PATH=\"$WAS_LIBPATH\":$LD_LIBRARY_PATH\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dibm.websphere.preload.classes=true\"\n");
        envbuff.append("    export LD_LIBRARY_PATH ;;\n");
        envbuff.append("  SunOS)\n");
        envbuff.append("    LD_LIBRARY_PATH=\"$WAS_LIBPATH\":$LD_LIBRARY_PATH\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dibm.websphere.preload.classes=true\"\n");
        envbuff.append("    export LD_LIBRARY_PATH ;;\n");
        envbuff.append("  HP-UX)\n");
        envbuff.append("    SHLIB_PATH=\"$WAS_LIBPATH\":$SHLIB_PATH\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dibm.websphere.preload.classes=true\"\n");
        envbuff.append("    export SHLIB_PATH ;;\n");
        envbuff.append("  OS/390)\n");
        envbuff.append("    PATH=\"$PATH\":$binDir\n");
        envbuff.append("    export PATH\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dfile.encoding=ISO8859-1 $DELIM -Djava.ext.dirs=\"$JAVA_EXT_DIRS\"\"\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dwas.serverstart.cell=\"$WAS_CELL\"\"\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dwas.serverstart.node=\"$WAS_NODE\"\"\n");
        envbuff.append("    D_ARGS=\"\"$D_ARGS\" $DELIM -Dwas.serverstart.server=\"$1\"\"\n");
        envbuff.append("    X_ARGS=\"-Xnoargsconversion\" ;;\n");
        envbuff.append("esac\n");
        envbuff.append("\n");
        for (int i = 0; i < env.size(); ++i) {
            envbuff.append(this.getPlatformEnvVerb());
            envbuff.append(" ");
            envbuff.append((String)env.get(i));
            envbuff.append("\n");
        }
        envbuff.append("\n");
        return envbuff.toString();
    }

    public String buildDevOptions(String opt) {
        StringBuffer header = new StringBuffer();
        if (opt != null) {
            header.append(this.getPlatformComment());
            header.append(" export ");
            header.append(opt);
            header.append(this.getPlatformLineEnd());
        }
        return header.toString();
    }

    public String getPlatformEnvVerb() {
        return "export";
    }

    public String getPlatformComment() {
        return "#";
    }

    public String getPlatformVarBegin() {
        return "$";
    }

    public String getPlatformVarEnd() {
        return "";
    }

    public String getPlatformBeginLocal() {
        return "";
    }

    public String getPlatformEndLocal() {
        return "";
    }

    public String getPlatformFileDelim() {
        return "/";
    }

    public String getPlatformLineEnd() {
        return "\n";
    }

    public String addBackgroundCommand(String launchCommand) {
        launchCommand = launchCommand + " &";
        return launchCommand;
    }
}

