/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.ServantNotificationListener;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServantNotificationListenerManager {
    private static TraceComponent tc = Tr.register(ServantNotificationListenerManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private static ServantNotificationListenerManager manager = null;
    private Hashtable listeners = new Hashtable();

    public static synchronized ServantNotificationListenerManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (manager == null) {
            manager = new ServantNotificationListenerManager();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", manager);
        }
        return manager;
    }

    private ServantNotificationListenerManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ListenerIdentifier addServantNotificationListener(ConsolidatedFilter filter, ServantNotificationListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServantNotificationListener", listener);
        }
        AdminServiceDelegator adminService = new AdminServiceDelegator();
        ListenerIdentifier listenerId = adminService.addNotificationListener(filter, listener);
        this.listeners.put(listener.getServantStoken(), listenerId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServantNotificationListener", listenerId);
        }
        return listenerId;
    }

    public void cleanupServantJVM(String stoken) {
        block5: {
            ListenerIdentifier listenerId;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupServantJVM", stoken);
            }
            if ((listenerId = (ListenerIdentifier)this.listeners.remove(stoken)) != null) {
                AdminServiceDelegator adminService = new AdminServiceDelegator();
                try {
                    adminService.removeNotificationListener(listenerId);
                }
                catch (ReceiverNotFoundException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to remove listener for servant " + stoken, e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupServantJVM");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServantNotificationListenerManager:");
        Set entries = this.listeners.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            buf.append("servant=");
            buf.append((String)mapEntry.getKey());
            buf.append(",listenerId=");
            buf.append(((ListenerIdentifier)mapEntry.getValue()).toString());
            if (!iterator.hasNext()) continue;
            buf.append(";");
        }
        return buf.toString();
    }
}

