/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;

abstract class RemoteSender
implements WsNotifListener {
    private static TraceComponent _tc = Tr.register(RemoteSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int MAX_NOTIFICATIONS = 10000;
    protected final SecurityHelper _sh = SecurityHelper.getHelper();
    private ListenerIdentifier _id = new ListenerIdentifier();
    private List _eventQueue = new ArrayList();
    private ConsolidatedFilter _filter;
    private boolean _receiverUnavailable = false;
    private boolean _isActive = true;

    RemoteSender() {
    }

    public boolean isNotificationEnabled(Notification n) {
        return this._filter == null || this._filter.isNotificationEnabled(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification event2) {
        if (this.isNotificationEnabled(event2)) {
            if (this._receiverUnavailable) {
                throw new ReceiverPermanentlyUnavailableException();
            }
            if (this._sh.isSecurityServiceStarted() && this._sh.isSecurityServiceStopped()) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "Security Server was running but has been stopped.  Notification NOT queued.", new String[]{"ListenerID=" + this._id, "Notification=" + event2});
                }
                return;
            }
            List list = this._eventQueue;
            synchronized (list) {
                if (this._eventQueue.size() > 10000) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue size exceeded.", "ListenerID=" + this._id);
                    }
                } else if (this._isActive) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "handleNotification: Queuing event." + this._eventQueue.size() + ".", "Notification=" + event2);
                    }
                    this._eventQueue.add(event2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeueNotifications(Notification[] notifications) {
        List list = this._eventQueue;
        synchronized (list) {
            if (this._isActive) {
                for (int i = notifications.length - 1; i >= 0; --i) {
                    this._eventQueue.add(0, notifications[i]);
                }
            }
        }
    }

    protected void receiverPermanentlyUnavailable() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "receiverPermanentlyUnavailable", this._id);
        }
        this._receiverUnavailable = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "receiverPermanentlyUnavailable");
        }
    }

    public ListenerIdentifier getIdentifier() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumNotifications() {
        List list = this._eventQueue;
        synchronized (list) {
            return this._eventQueue.size();
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        this._isActive = false;
        this.discardNotifications();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardNotifications() {
        List list = this._eventQueue;
        synchronized (list) {
            this._eventQueue.clear();
        }
    }

    public void restart() {
        this._isActive = true;
    }

    public boolean isActive() {
        return this._isActive;
    }

    protected Notification[] getNotifications() {
        return this.getNotifications(this.getNumNotifications());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Notification[] getNotifications(int batchSize) {
        Notification[] notifications = null;
        List list = this._eventQueue;
        synchronized (list) {
            if (this._eventQueue.size() > batchSize) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getNotifications: Getting first " + batchSize + " notifications from queue.");
                }
                notifications = this.getFirstNotifications(batchSize);
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getNotifications: Getting all " + this._eventQueue.size() + " notifications from queue.");
                }
                notifications = new Notification[this._eventQueue.size()];
                notifications = this._eventQueue.toArray(notifications);
                this._eventQueue.clear();
            }
        }
        return notifications;
    }

    private Notification[] getFirstNotifications(int numNotifications) {
        Notification[] notifications = new Notification[numNotifications];
        for (int i = 0; !this._eventQueue.isEmpty() && i < numNotifications; ++i) {
            notifications[i] = (Notification)this._eventQueue.remove(0);
        }
        return notifications;
    }

    public ConsolidatedFilter getFilter() {
        return this._filter;
    }

    public void setFilter(ConsolidatedFilter filter) {
        this._filter = filter;
    }

    public String toString() {
        return this.getClass().getName() + ": [listenerId=" + this._id + "; filter=" + this._filter + "]";
    }
}

