/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.FilterChangeListener;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.event.WsNotifDelegator;
import com.ibm.ws.management.exception.ReceiverNotFoundException;

public abstract class RemoteReceiver
extends WsNotifDelegator
implements FilterChangeListener {
    private static TraceComponent tc = Tr.register(RemoteReceiver.class, "Admin", "com.ibm.ws.management.resources.event");
    private RemoteNotificationBroadcaster remoteNotificationService;
    private ConsolidatedFilter filter;
    private ListenerIdentifier id = null;

    protected RemoteReceiver(RemoteNotificationBroadcaster remoteNotificationService) {
        this.remoteNotificationService = remoteNotificationService;
    }

    public void setFilter(Object ignoredId, ConsolidatedFilter newFilter) throws ConnectorException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setFilter", newFilter);
            }
            ConsolidatedFilter oldFilter = this.filter;
            try {
                try {
                    this.filter = newFilter;
                    if (this.id == null) {
                        this.subscribe();
                        break block9;
                    }
                    this.resubscribe();
                }
                catch (ReceiverNotFoundException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.RemoteReceiver.setFilter", (String)"70", (Object)this);
                    try {
                        this.unsubscribe();
                    }
                    catch (ReceiverNotFoundException exc) {
                        // empty catch block
                    }
                    this.subscribe();
                }
            }
            catch (ConnectorException ex) {
                this.filter = oldFilter;
                throw ex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    public ConsolidatedFilter getFilter() {
        return this.filter;
    }

    protected void subscribe() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "subscribe");
        }
        this.id = this.remoteNotificationService.addNotificationListener(this.filter, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "subscribe", this.id);
        }
    }

    protected void resubscribe() throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resubscribe", this.id);
        }
        this.remoteNotificationService.resetFilter(this.id, this.filter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resubscribe");
        }
    }

    protected RemoteNotificationBroadcaster getRemoteNotificationService() {
        return this.remoteNotificationService;
    }

    protected ListenerIdentifier getListenerId() {
        return this.id;
    }

    public void unsetFilter(Object ignoredId) throws ConnectorException {
        try {
            this.unsubscribe();
        }
        catch (ReceiverNotFoundException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.RemoteReceiver.unsetFilter", (String)"113", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribe() throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsubscribe");
        }
        try {
            this.remoteNotificationService.removeNotificationListener(this.id);
        }
        finally {
            this.id = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsubscribe");
        }
    }

    protected boolean isActive() {
        return this.id != null;
    }
}

