/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.AbstractPushRemoteSender;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import javax.management.Notification;

public class PushRemoteSender
extends AbstractPushRemoteSender {
    private static TraceComponent tc = Tr.register(PushRemoteSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final long MAX_FAILURE_TIME = 300000L;
    private PushNotificationListener remoteListener;
    private long firstFailureTime = 0L;

    public PushRemoteSender(PushNotificationListener listener) {
        this.remoteListener = listener;
    }

    protected boolean pushNotifications(Notification[] notifications) throws ConnectorException {
        try {
            this.remoteListener.handleNotifications(notifications);
            this.firstFailureTime = 0L;
        }
        catch (ConnectorException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.event.PushRemoteSender.pushNotifications", (String)"61", (Object)this);
            if (this.firstFailureTime == 0L) {
                this.firstFailureTime = System.currentTimeMillis();
            } else {
                this.determineFailure();
            }
            throw exc;
        }
        return true;
    }

    private void determineFailure() {
        if (System.currentTimeMillis() - this.firstFailureTime > 300000L) {
            FFDCFilter.processException((Throwable)new ReceiverPermanentlyUnavailableException("Exception threshold reached for pushing notifications"), (String)"com.ibm.ws.management.event.PushRemoteSender.alarm", (String)"78", (Object)this);
            this.receiverPermanentlyUnavailable();
        }
    }
}

