/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.DownstreamServerManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.MBeanServerDelegateListener;
import com.ibm.ws.management.event.NotificationDispatcher;
import com.ibm.ws.management.event.NullDownstreamProcessManager;
import com.ibm.ws.management.event.ProcessListener;
import com.ibm.ws.management.event.PullRemoteSender;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteSender;
import com.ibm.ws.management.event.PushUpstreamServerSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.event.RemoteSender;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.management.event.ZControlNotificationManager;
import com.ibm.ws.management.event.ZServantListener;
import com.ibm.ws.management.event.ZServantNotificationManager;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.util.ThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.security.auth.Subject;

public class NotificationService
implements WsNotifListener,
WsNotifListenerContainer,
RemoteNotificationBroadcaster {
    private static TraceComponent tc = Tr.register(NotificationService.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final String CLASSNAME = "com.ibm.ws.management.event.NotificationService";
    private static final int DISPATCH_POOL_MIN = 1;
    private static final int DISPATCH_POOL_MAX = 100;
    private static final int CONTROL_JVM_LISTENER_BUFFER_MAX_SIZE = 0;
    private List listeners;
    private NotificationDispatcher dispatcher;
    private ThreadPool dispatchPool;
    private boolean listenersUpdated = true;
    private Map remoteSenders = new HashMap();
    private DownstreamProcessManager downstreamManager;
    private PushRemoteSender upstreamServerSender;
    private boolean _isServantJVM = false;
    private List<Notification> _controlJVMListenerNotificationBuffer = null;
    private Object _controlJVMListenerNotificationBufferLock = new Object();
    private DownstreamProcessManager servantProcessManager = null;
    private ListenerIdentifier controlJVMid = null;

    public NotificationService(MBeanServer mbeanServer) {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NotificationService.<init>:" + uuid);
        }
        this.listeners = new ArrayList();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                this._isServantJVM = true;
                this.downstreamManager = new ZControlNotificationManager();
                this._controlJVMListenerNotificationBuffer = new ArrayList<Notification>();
            } else if (processType.equals("DeploymentManager") || processType.equals("NodeAgent") || uuid != null) {
                this.downstreamManager = new DownstreamServerManager();
                new ProcessListener(this);
            } else {
                this.downstreamManager = new NullDownstreamProcessManager();
            }
            if (AdminHelper.getPlatformHelper().isControlJvm() && !processType.equals("NodeAgent")) {
                this.servantProcessManager = new ZServantNotificationManager();
                new ZServantListener(this);
            }
            new MBeanServerDelegateListener(mbeanServer, this);
        } else {
            this.downstreamManager = new DownstreamServerManager();
            new MBeanServerDelegateListener(mbeanServer, this);
            new ProcessListener(this);
        }
        this.dispatchPool = new ThreadPool("NotificationServiceDispatcher", 1, 100);
        this.dispatchPool.setContextClassLoader((ClassLoader)ExtClassLoader.getInstance());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NotificationService.<init>");
        }
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) {
        RemoteSender sender;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{filter, listener});
        }
        if (listener == null) {
            sender = new PullRemoteSender();
        } else {
            sender = new PushRemoteSender(listener);
            if (listener instanceof PushUpstreamServerSender) {
                this.replaceUpstreamServerSender((PushRemoteSender)sender);
            }
        }
        sender.setFilter(filter);
        this.addListener(sender);
        ListenerIdentifier id = sender.getIdentifier();
        this.downstreamManager.setFilter(id, filter);
        if (AdminHelper.getPlatformHelper().isZOS() && this.servantProcessManager != null) {
            this.servantProcessManager.setFilter(id, filter);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(WsNotifListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", listener);
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            ListenerIdentifier id = null;
            try {
                id = ((RemoteSender)listener).getIdentifier();
                this.remoteSenders.put(id, listener);
            }
            catch (ClassCastException exc) {
                // empty catch block
            }
        }
        boolean added = false;
        List list = this.listeners;
        synchronized (list) {
            added = this.listeners.add(listener);
        }
        if (added) {
            this.listenersUpdated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener", new Boolean(added));
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(WsNotifListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", listener);
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            ListenerIdentifier id = null;
            try {
                id = ((RemoteSender)listener).getIdentifier();
                RemoteSender sender = (RemoteSender)this.remoteSenders.remove(id);
                if (sender != null) {
                    sender.stop();
                }
            }
            catch (ClassCastException exc) {
                // empty catch block
            }
        }
        boolean removed = false;
        List list = this.listeners;
        synchronized (list) {
            removed = this.listeners.remove(listener);
        }
        if (removed) {
            this.listenersUpdated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener", new Boolean(removed));
        }
        return removed;
    }

    public boolean isNotificationEnabled(Notification n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", NotificationService.getInfo(event2));
        }
        Object currentListeners = null;
        Object object = this._controlJVMListenerNotificationBufferLock;
        synchronized (object) {
            if (this._isServantJVM && this.controlJVMid == null && this._controlJVMListenerNotificationBuffer != null) {
                this._controlJVMListenerNotificationBuffer.add(event2);
            }
            if (this.listenersUpdated) {
                List list = this.listeners;
                synchronized (list) {
                    WsNotifListener[] listenersCopy = null;
                    if (AdminHelper.getPlatformHelper().isZOS() && this.getControlJVMListener() != null) {
                        listenersCopy = new WsNotifListener[]{this.getControlJVMListener()};
                    } else {
                        listenersCopy = new WsNotifListener[this.listeners.size()];
                        listenersCopy = this.listeners.toArray(listenersCopy);
                    }
                    this.dispatcher = new NotificationDispatcher(this, listenersCopy, false, this.dispatchPool);
                }
            }
        }
        this.dispatcher.handleNotification(event2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoteNotification(Notification event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRemoteNotification", NotificationService.getInfo(event2));
        }
        if (this.listenersUpdated) {
            List list = this.listeners;
            synchronized (list) {
                WsNotifListener controlJVMListener = this.getControlJVMListener();
                WsNotifListener[] listenersCopy = null;
                if (controlJVMListener != null) {
                    boolean controlJVMListenerFound = false;
                    ArrayList<WsNotifListener> notifListeners = new ArrayList<WsNotifListener>();
                    for (WsNotifListener listener : this.listeners) {
                        if (listener == controlJVMListener) {
                            controlJVMListenerFound = true;
                            continue;
                        }
                        notifListeners.add(listener);
                    }
                    listenersCopy = notifListeners.toArray(new WsNotifListener[notifListeners.size()]);
                    if (tc.isDebugEnabled() && !controlJVMListenerFound) {
                        Tr.debug(tc, "unable to find control JVM listener");
                    }
                } else {
                    listenersCopy = new WsNotifListener[this.listeners.size()];
                    listenersCopy = this.listeners.toArray(listenersCopy);
                }
                this.dispatcher = new NotificationDispatcher(this, listenersCopy, false, this.dispatchPool);
            }
        }
        this.dispatcher.handleNotification(event2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRemoteNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerIdentifier addControlNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) {
        ListenerIdentifier id;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addControlNotificationListener", new Object[]{filter, listener});
        }
        RemoteSender sender = listener == null ? new PullRemoteSender() : new PushRemoteSender(listener);
        sender.setFilter(filter);
        Object object = this._controlJVMListenerNotificationBufferLock;
        synchronized (object) {
            if (this._controlJVMListenerNotificationBuffer != null) {
                block13: {
                    ArrayList<Notification> filteredBuffer = new ArrayList<Notification>();
                    for (Notification notif : this._controlJVMListenerNotificationBuffer) {
                        if (!filter.isNotificationEnabled(notif)) continue;
                        filteredBuffer.add(notif);
                    }
                    try {
                        int filteredBufferSize = filteredBuffer.size();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Preparing to send buffered notifications to controller.", new Object[]{"unfilteredBufferSize=" + this._controlJVMListenerNotificationBuffer.size(), "filteredBufferSize=" + filteredBufferSize});
                        }
                        if (filteredBufferSize > 0) {
                            Notification[] notifArray = new Notification[filteredBufferSize];
                            filteredBuffer.toArray(notifArray);
                            Thread notifThread = new Thread(new ControlNotificationHandler(notifArray, listener));
                            notifThread.start();
                        }
                    }
                    catch (Throwable th) {
                        FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.event.NotificationService.addControlNotificationListener", (String)"470", (Object)this);
                        if (!tc.isEventEnabled()) break block13;
                        Tr.event(tc, "Error occurred while sending buffered notifications to control JVM.", th);
                    }
                }
                this._controlJVMListenerNotificationBuffer = null;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Control JVM notifications buffer is null.");
            }
            this.addListener(sender);
        }
        this.controlJVMid = id = sender.getIdentifier();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addControlNotificationListener", id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceUpstreamServerSender(PushRemoteSender upstreamSender) {
        Map map = this.remoteSenders;
        synchronized (map) {
            if (this.upstreamServerSender != null) {
                try {
                    this.removeNotificationListener(this.upstreamServerSender.getIdentifier());
                }
                catch (ReceiverNotFoundException receiverNotFoundException) {
                    // empty catch block
                }
            }
            this.upstreamServerSender = upstreamSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ListenerIdentifier listenerId) throws ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", listenerId);
        }
        RemoteSender sender = null;
        Map map = this.remoteSenders;
        synchronized (map) {
            sender = (RemoteSender)this.remoteSenders.get(listenerId);
        }
        if (sender == null) {
            throw new ReceiverNotFoundException(listenerId);
        }
        this.removeListener(sender);
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            this.downstreamManager.unsetFilter(listenerId);
        } else {
            if (listenerId != null && listenerId.equals(this.controlJVMid)) {
                this.controlJVMid = null;
            } else {
                this.downstreamManager.unsetFilter(listenerId);
            }
            if (this.servantProcessManager != null) {
                this.servantProcessManager.unsetFilter(listenerId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws ReceiverNotFoundException {
        RemoteSender sender;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", new Object[]{listenerId, filter});
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            sender = (RemoteSender)this.remoteSenders.get(listenerId);
        }
        if (sender == null) {
            throw new ReceiverNotFoundException(listenerId);
        }
        sender.setFilter(filter);
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            this.downstreamManager.setFilter(listenerId, filter);
        } else {
            if (listenerId == null || !listenerId.equals(this.controlJVMid)) {
                this.downstreamManager.setFilter(listenerId, filter);
            }
            if (this.servantProcessManager != null) {
                this.servantProcessManager.setFilter(listenerId, filter);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ReceiverNotFoundException {
        PullRemoteSender sender;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", new Object[]{id, batchSize});
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            sender = (PullRemoteSender)this.remoteSenders.get(id);
        }
        if (sender == null) {
            throw new ReceiverNotFoundException(id);
        }
        Notification[] notifs = sender.pullNotifications(batchSize);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullNotifications");
        }
        return notifs;
    }

    public void stopUpstreamServerSending() {
    }

    public void restartUpstreamServerSending() {
    }

    public DownstreamProcessManager getDownstreamProcessManager() {
        return this.downstreamManager;
    }

    public DownstreamServerManager getDownstreamServerManager() {
        return (DownstreamServerManager)this.downstreamManager;
    }

    public DownstreamProcessManager getServantProcessManager() {
        return this.servantProcessManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WsNotifListener getControlJVMListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControlJVMListener");
        }
        WsNotifListener controlJVMListener = null;
        Map map = this.remoteSenders;
        synchronized (map) {
            controlJVMListener = (WsNotifListener)this.remoteSenders.get(this.controlJVMid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getControlJVMListener", controlJVMListener);
        }
        return controlJVMListener;
    }

    public static String getInfo(Notification ntfyObj) {
        StringBuffer buf = new StringBuffer();
        buf.append(ntfyObj.getType());
        buf.append(" [source=" + ntfyObj.getSource());
        buf.append(",userData=" + ntfyObj.getUserData() + "]");
        return buf.toString();
    }

    public static String getInfo(Notification[] ntfyObj) {
        StringBuffer buf = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (int i = 0; i < ntfyObj.length; ++i) {
            buf.append(NotificationService.getInfo(ntfyObj[i]));
            if (i + 1 >= ntfyObj.length) continue;
            buf.append(linesep);
        }
        return buf.toString();
    }

    public String toString() {
        return "NotificationService";
    }

    class ControlNotificationHandler
    implements Runnable {
        private Notification[] notifArray;
        private PushNotificationListener listener;
        private Subject subject;

        public ControlNotificationHandler(Notification[] newNotifArray, PushNotificationListener newListener) {
            this.notifArray = newNotifArray;
            this.listener = newListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.setServerCredentials();
                this.listener.handleNotifications(this.notifArray);
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.event.NotificationService.ControlNotificationHandler.run", (String)"725", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error occurred while sending buffered notifications to control JVM.", th);
                }
            }
            finally {
                this.unsetServerCredentials();
            }
        }

        private void setServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ControlNotificationHandler.this.subject = SecurityHelper.getServerSubject();
                    if (ControlNotificationHandler.this.subject != null) {
                        SecurityHelper.pushInvocationSubject(ControlNotificationHandler.this.subject);
                    }
                    return null;
                }
            });
        }

        private void unsetServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (ControlNotificationHandler.this.subject != null) {
                        SecurityHelper.popInvocationSubject(ControlNotificationHandler.this.subject);
                    }
                    return null;
                }
            });
        }
    }
}

