/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.PlatformMBeanServer;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.WsNotifDelegator;
import com.ibm.ws.management.event.WsNotifListener;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class MBeanServerDelegateListener
extends WsNotifDelegator
implements NotificationListener {
    private static TraceComponent tc = Tr.register(MBeanServerDelegateListener.class, "Admin", "com.ibm.ws.management.resources.event");
    private MBeanServer mbeanServer;

    public MBeanServerDelegateListener(MBeanServer mbeanServer, WsNotifListener delegate) {
        super(delegate);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.mbeanServer = mbeanServer;
        try {
            ObjectName mbeanServerMBean = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            mbeanServer.addNotificationListener(mbeanServerMBean, this, null, (Object)this);
        }
        catch (MalformedObjectNameException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.LocalNotificationListener.LocalNotificationListener", (String)"57", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to construct object name for mbeanserver", ex);
            }
        }
        catch (InstanceNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.LocalNotificationListener.LocalNotificationListener", (String)"63", (Object)this);
            Tr.warning(tc, "ADME0003W", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{NotificationService.getInfo(notification), handback});
            }
            if (handback == this) {
                MBeanServerNotification mbeanServerEvent = (MBeanServerNotification)notification;
                ObjectName mbean = mbeanServerEvent.getMBeanName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MBean activated:", mbean);
                }
                try {
                    MBeanNotificationInfo[] info;
                    if (!mbeanServerEvent.getType().equals("JMX.mbean.registered")) break block20;
                    if (this.mbeanServer instanceof PlatformMBeanServer) {
                        this.mbeanServer = ((PlatformMBeanServer)this.mbeanServer).getDefaultMBeanServer();
                    }
                    if ((info = this.mbeanServer.getMBeanInfo(mbean).getNotifications()) != null) {
                        if (info.length > 0) {
                            this.mbeanServer.addNotificationListener(mbean, this, null, (Object)mbean);
                        } else if (info.length == 0 && this.mbeanServer.isInstanceOf(mbean, "javax.management.NotificationBroadcaster")) {
                            this.mbeanServer.addNotificationListener(mbean, this, null, (Object)mbean);
                        }
                    }
                    break block20;
                }
                catch (InstanceNotFoundException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.LocalNotificationListener.handleNotification", (String)"100", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception is thrown", ex);
                    }
                    break block20;
                }
                catch (IntrospectionException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.LocalNotificationListener.handleNotification", (String)"112", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception is thrown", ex);
                    }
                    break block20;
                }
                catch (ReflectionException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.LocalNotificationListener.handleNotification", (String)"118", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception is thrown", ex);
                    }
                    break block20;
                }
            }
            if (handback instanceof ObjectName) {
                String nameValue = ((ObjectName)handback).getKeyProperty("name");
                if (Thread.currentThread().getName().contains("NotificationServiceDispatcher") && nameValue != null && nameValue.equals("RasLoggingService")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "handleNotification - Not re-propagating notification " + notification);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleNotification");
                    }
                    return;
                }
                notification.setSource(handback);
            }
        }
        this.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }
}

