/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.NotificationInfo;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.SecurityServiceMonitor;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ListenerInfo
implements WsNotifListener {
    private static TraceComponent _tc = Tr.register(ListenerInfo.class, "Admin", "com.ibm.ws.management.event");
    private final NotificationInfo _ntfyInfo;
    private final NotificationListener _listener;
    private final Object _handback;
    private final SecurityServiceMonitor _sh;
    private final Subject _listenerSubject;
    private final boolean _initPhaseRuntimeListener;

    ListenerInfo(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        boolean initPhaseRuntimeListener;
        Subject subj;
        block5: {
            this._sh = this.getSecurityMonitor();
            this._ntfyInfo = new NotificationInfo(name, filter);
            this._listener = listener;
            this._handback = handback;
            subj = null;
            initPhaseRuntimeListener = false;
            try {
                subj = SecurityHelper.retrieveSubject();
                if (subj == null) {
                    initPhaseRuntimeListener = this.isInitPhaseRuntimeListener();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "ListenerInfo: subject is null.", "runtimeInit=" + initPhaseRuntimeListener);
                    }
                } else {
                    Tr.debug(_tc, "ListenerInfo: subject is not null.");
                }
            }
            catch (Throwable t) {
                if (!_tc.isEventEnabled()) break block5;
                Tr.event(_tc, "ListenerInfo: could not obtain subject.  Listener will be invoked with no credentials.", t);
            }
        }
        this._initPhaseRuntimeListener = initPhaseRuntimeListener;
        this._listenerSubject = subj;
    }

    protected SecurityServiceMonitor getSecurityMonitor() {
        return SecurityHelper.getHelper();
    }

    public ObjectName getObjectName() {
        return this._ntfyInfo.getName();
    }

    public NotificationFilter getNotificationFilter() {
        return this._ntfyInfo.getFilter();
    }

    public NotificationListener getNotificationListener() {
        return this._listener;
    }

    public Object getHandback() {
        return this._handback;
    }

    public boolean isNotificationEnabled(Notification n) {
        return this._ntfyInfo.isNotificationEnabled(n);
    }

    public void handleNotification(Notification n) {
        if (this.isNotificationEnabled(n)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Listener enabled");
            }
            if (this._sh.isSecurityServiceStarted() && this._sh.isSecurityServiceStopped()) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "Security Server was running but has been stopped.  Listener NOT invoked", new String[]{"Listener=" + this._listener, "Notification=" + n});
                }
                return;
            }
            final Notification nFinal = n;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ListenerInfo.this._listener.handleNotification(nFinal, ListenerInfo.this._handback);
                    return null;
                }
            };
            try {
                ContextManager contextMgr = ContextManagerFactory.getInstance();
                if (this._initPhaseRuntimeListener) {
                    contextMgr.runAsSystem(action);
                } else {
                    contextMgr.runAsSpecified(this._listenerSubject, action);
                }
            }
            catch (PrivilegedActionException pae) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Exception occurred from handleNotification call.", new Object[]{this._ntfyInfo.getName(), this._handback, pae.getException()});
                }
                FFDCFilter.processException((Throwable)pae.getException(), (String)"com.ibm.ws.management.event.ListenerInfo.handleNotification", (String)"158", (Object)this);
            }
            catch (Throwable t) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Exception occurred setting up handleNotification call.", new Object[]{this._ntfyInfo.getName(), this._handback, t});
                }
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.event.ListenerInfo.handleNotification", (String)"165", (Object)this);
            }
        }
    }

    public boolean containsName(ObjectName givenName) {
        return this._ntfyInfo.containsName(givenName);
    }

    public boolean isMatching(ObjectName inName, NotificationListener inListener) {
        return (inName == null || this._ntfyInfo.getName().equals(inName)) && this._listener.equals(inListener);
    }

    public boolean isMatching(ObjectName inName, NotificationListener inListener, NotificationFilter filter, Object handback) {
        return (inName == null || this._ntfyInfo.getName().equals(inName)) && this._listener.equals(inListener) && this._ntfyInfo.getFilter().equals(filter) && this._handback.equals(handback);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == null) {
            result = false;
        } else {
            try {
                ListenerInfo info = (ListenerInfo)obj;
                if (this._listener.equals(info._listener) && this._ntfyInfo.getName().equals(info._ntfyInfo.getName())) {
                    result = this._handback == null && info._handback == null ? true : (this._handback == null && info._handback != null || this._handback != null && info._handback == null ? false : this._handback.equals(info._handback));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this._listener != null) {
            hashCode += this._listener.hashCode();
        }
        if (this._handback != null) {
            hashCode += this._handback.hashCode();
        }
        if (this._ntfyInfo.getName() != null) {
            hashCode += this._ntfyInfo.getName().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return "ListenerInfo: [listener=" + this._listener + ";ntfyInfo=" + this._ntfyInfo + ";handback=" + this._handback + "]";
    }

    private boolean isInitPhaseRuntimeListener() {
        if (AdminServiceFactory.getAdminService() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ListenerInfo: client process.");
            }
            return false;
        }
        if (this._sh.isSecurityServiceStarted() && !this._sh.isSecurityServiceStopped()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ListenerInfo: security service is started.");
            }
            return false;
        }
        return true;
    }
}

