/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.FilterChangeListener;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.LocalNotificationService;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ClientNotificationService
extends LocalNotificationService {
    private static TraceComponent tc = Tr.register(ClientNotificationService.class, "Admin", "com.ibm.ws.management.resources.event");
    private ConsolidatedFilter consolidatedFilter;
    private FilterChangeListener filterChangeListener;
    private Object filterId = new ListenerIdentifier();

    public ClientNotificationService() {
    }

    public ClientNotificationService(FilterChangeListener filterChangeListener) {
        this.setFilterChangeListener(filterChangeListener);
    }

    public void setFilterChangeListener(FilterChangeListener filterChangeListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilterChangeListener", filterChangeListener);
        }
        this.filterChangeListener = filterChangeListener;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilterChangeListener");
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{name, listener, filter, handback});
        }
        this.addClientListenerInternal(name, listener, filter, handback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListenerExtended", new Object[]{name, listener, filter, handback});
        }
        this.addClientListenerInternal(name, listener, filter, handback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListenerExtended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClientListenerInternal(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        boolean filterChanged = false;
        ClientNotificationService clientNotificationService = this;
        synchronized (clientNotificationService) {
            boolean added = super.addListenerInternal(name, listener, filter, handback);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Is listener added: " + added);
            }
            if (added) {
                if (this.consolidatedFilter == null) {
                    this.consolidatedFilter = new ConsolidatedFilter();
                }
                this.consolidatedFilter.addFilter(listener, name, filter);
                try {
                    this.filterChangeListener.setFilter(this.filterId, this.consolidatedFilter);
                }
                catch (ConnectorException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.event.ClientNotificationService.addClientListenerInternal", (String)"120", (Object)this);
                    try {
                        super.removeNotificationListenerExtended(name, listener);
                    }
                    catch (ListenerNotFoundException exc) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener});
        }
        super.removeListenerInternal(name, listener);
        this.updateRemoteFilter(name, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListenerExtended(ObjectName name, NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListenerExtended", new Object[]{name, listener});
        }
        super.removeListenerInternal(name, listener);
        this.updateRemoteFilter(null, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListenerExtended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteFilter(ObjectName name, NotificationListener listener) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRemoteFilter", new Object[]{name, listener});
        }
        ClientNotificationService clientNotificationService = this;
        synchronized (clientNotificationService) {
            if (this.getNumListeners() == 0) {
                this.consolidatedFilter = null;
                this.filterChangeListener.unsetFilter(this.filterId);
            } else {
                this.consolidatedFilter.removeFilter(name, listener);
                this.filterChangeListener.setFilter(this.filterId, this.consolidatedFilter);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRemoteFilter");
        }
    }
}

