/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.transport.TcpConnection;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class UnicastServer
implements Runnable {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(UnicastServer.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private ThreadPool threadPool = null;
    private ObjectPool connectionPool = null;
    private ServerSocket serverSocket;
    private boolean alive;
    private Thread acceptThread = null;
    private Endpoint endpoint;
    private int retryLimit = 4;
    private int retryInterval = 1000;

    public UnicastServer(Endpoint endpoint) {
        this.endpoint = endpoint;
        ThreadPoolMgr tpMgr = endpoint.getThreadPoolMgr();
        int maxThreads = 2;
        String threadString = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (threadString != null) {
            maxThreads = new Integer(threadString);
        }
        this.threadPool = this.getThreadPool(tpMgr, "ProcessDiscovery", maxThreads);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return UnicastServer.this.createTcpConnection();
            }
        };
        this.retryLimit = Integer.getInteger("com.ibm.websphere.management.discovery.unicast.retryLimit", 4);
        this.retryInterval = Integer.getInteger("com.ibm.websphere.management.discovery.unicast.retryInterval", 1000);
        if (this.retryInterval > 30000) {
            this.retryInterval = 30000;
        }
        if (this.retryInterval < 1000) {
            this.retryInterval = 1000;
        }
    }

    public void initialize(int port) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize @" + port);
        }
        this.alive = true;
        Boolean useMultiHome = AdminHelper.getInstance().useMultiHome();
        if (useMultiHome == null) {
            this.serverSocket = new ServerSocket(port);
        } else if (useMultiHome.booleanValue()) {
            this.serverSocket = new ServerSocket(port, 50, null);
        } else {
            InetAddress ia = InetAddress.getByName(this.endpoint.getEndpointAddress().getProtocolHost());
            this.serverSocket = new ServerSocket(port, 50, ia);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "useMultiHome == false: host name = " + ia);
            }
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize - successful");
        }
    }

    public void shutdown(boolean force) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "shutdown");
            }
            this.alive = false;
            try {
                try {
                    Socket s = new Socket("localhost", this.serverSocket.getLocalPort());
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.shutdown", (String)"78", (Object)this);
                    this.acceptThread.interrupt();
                }
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException ie) {
                FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.shutdown", (String)"83", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "failed to shutdown the UnicastServer", ie);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected TcpConnection createTcpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createTcpConnection");
        }
        return new TcpConnection();
    }

    public void handleConnection(TcpConnection c) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleConnection");
        }
        try {
            this.threadPool.execute((Runnable)c);
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.handleConnection", (String)"101", (Object)this);
        }
    }

    public TcpConnection allocateConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allocateConnection");
        }
        return (TcpConnection)this.connectionPool.remove();
    }

    public boolean freeConnection(TcpConnection conn) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "freeConnection");
        }
        return !this.connectionPool.add((Object)conn);
    }

    public void run() {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            int retryCount = 0;
            while (this.alive) {
                Socket socket;
                block20: {
                    if (retryCount >= this.retryLimit) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retry Count is: " + retryCount + " shutdown() called");
                        }
                        this.alive = false;
                        break;
                    }
                    if (this.acceptThread.isInterrupted()) break;
                    socket = null;
                    try {
                        socket = this.serverSocket.accept();
                        retryCount = 0;
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"118", (Object)this);
                        ++retryCount;
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Sleeping for: " + this.retryInterval + " milliseconds...");
                            }
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException ie) {
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Thread Interrupted.. shutting down");
                            break;
                        }
                        if (!this.alive) break block20;
                        Tr.warning(tc, "ADMD0020W", ioe.getMessage());
                    }
                }
                if (this.alive && socket != null) {
                    TcpConnection conn = null;
                    try {
                        conn = this.allocateConnection();
                        conn.init(this.endpoint, socket);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the connection is initialized");
                        }
                        this.handleConnection(conn);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"130", (Object)this);
                        if (conn != null) {
                            this.freeConnection(conn);
                        }
                        Tr.warning(tc, "ADMD0021W", t.getMessage());
                    }
                    continue;
                }
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"138", (Object)this);
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.discovery.transport.UnicastServer.run", (String)"147", (Object)this);
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "failed to cloase server socket", ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    private ThreadPool getThreadPool(ThreadPoolMgr tpMgr, String name, int maxThreads) {
        ThreadPool pool = null;
        pool = tpMgr.getThreadPool(name);
        if (pool == null) {
            pool = tpMgr.getThreadPool(name, null);
            pool.setMaximumPoolSize(maxThreads);
            pool.setGrowAsNeeded(true);
        }
        return pool;
    }
}

