/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;

public class UdpMessenger
implements EndpointMessenger {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private TraceComponent tc = Tr.register(UdpMessenger.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.discovery");
    protected TransportProtocol protocol;
    protected DatagramSocket socket;
    protected int port;
    protected EndpointAddress destination;
    protected EndpointAddress source;
    protected InetAddress inetAddress;
    protected Header header;

    protected UdpMessenger() {
    }

    public UdpMessenger(EndpointAddress address, TransportProtocol protocol) throws IOException {
        int portIndex;
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "UdpMessenger", address);
        }
        this.destination = address;
        this.protocol = protocol;
        this.header = new Header();
        this.source = protocol.getLocalAddress();
        String tmp = this.destination.getProtocolAddress();
        int ind = tmp.indexOf(93);
        if (ind < 0) {
            ind = 0;
        }
        if ((portIndex = tmp.indexOf(58, ind)) == -1) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "UdpMessenger - failed");
            }
            throw new IOException(this.nls.getString("ADMD0010E"));
        }
        this.port = Integer.valueOf(tmp.substring(portIndex + 1));
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "port = " + this.port);
        }
        this.inetAddress = InetAddress.getByName(tmp.substring(0, portIndex));
        if (!this.openSocket()) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "UdpMessenger - failed");
            }
            throw new IOException(this.nls.getFormattedMessage("ADMD0005E", new Object[]{new Integer(this.port)}, "can not open the UDP socket: {0}"));
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "UdpMessenger");
        }
    }

    public void sendMessage(Message message) throws IOException {
        block12: {
            byte[] nextBuffer;
            int readLength;
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "sendMessage");
            }
            if (this.destination == null) {
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, "sendMessage - failed");
                }
                throw new IOException(this.nls.getString("ADMD0006E"));
            }
            int msgSize = 0;
            int bufferSize = 4096;
            InputStream inputStream = message.getInputStream();
            Vector<byte[]> msgBuffers = new Vector<byte[]>();
            msgBuffers.addElement(new byte[Header.length]);
            while ((readLength = inputStream.read(nextBuffer = new byte[bufferSize])) != -1) {
                if (readLength == 0) continue;
                if (readLength < bufferSize) {
                    byte[] anotherBuffer = new byte[readLength];
                    System.arraycopy(nextBuffer, 0, anotherBuffer, 0, readLength);
                    nextBuffer = anotherBuffer;
                }
                msgSize += nextBuffer.length;
                msgBuffers.addElement(nextBuffer);
            }
            this.header.cmd = (byte)2;
            String h = this.protocol.getLocalAddress().getProtocolHost();
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "local host name is: " + h);
            }
            this.header.srcAddr = InetAddress.getByName(h).getAddress();
            this.header.srcPort = this.protocol.getPort();
            this.header.option = 2;
            this.header.size = msgSize;
            this.header.cipher((byte[])msgBuffers.elementAt(0), 0);
            byte[] buffer = new byte[Header.length + msgSize];
            int pos = 0;
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "header size: " + Header.length + " message size : " + msgSize);
            }
            for (int eachBuffer = 0; eachBuffer < msgBuffers.size(); ++eachBuffer) {
                byte[] data = (byte[])msgBuffers.elementAt(eachBuffer);
                System.arraycopy(data, 0, buffer, pos, data.length);
                pos += data.length;
                if (!this.tc.isDebugEnabled()) continue;
                Tr.debug(this.tc, "size for one pile: " + data.length + " offset: " + pos);
            }
            if (this.socket == null && !this.openSocket()) {
                throw new IOException(this.nls.getFormattedMessage("ADMD0005E", new Object[]{new Integer(this.port)}, "can not open the UDP socket: {0}"));
            }
            DatagramPacket dp = new DatagramPacket(buffer, buffer.length, this.inetAddress, this.port);
            try {
                this.socket.send(dp);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.UdpMessenger.sendMessage", (String)"183", (Object)this);
                if (!this.tc.isDebugEnabled()) break block12;
                Tr.debug(this.tc, "Failed to send out the datagram", e);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "sendMessage");
        }
    }

    public void close() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "close");
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.UdpMessenger.close", (String)"200", (Object)this);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "close");
        }
    }

    private boolean openSocket() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "openSocket");
        }
        this.socket = null;
        try {
            this.socket = new DatagramSocket();
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "openSocket - good");
            }
            return true;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.UdpMessenger.openSocket", (String)"218", (Object)this);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "openSocket - bad", e);
            }
            return false;
        }
    }
}

