/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.transport.MessengerFactory;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UnicastServer;
import java.io.IOException;
import java.net.InetAddress;

public class TcpTransport
implements TransportProtocol {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(TcpTransport.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private boolean initialized = false;
    protected int port;
    protected EndpointAddress localAddress;
    private UnicastServer unicastServer;

    public TcpTransport(TcpAdv tcpadv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TcpTransport");
        }
        InetAddress usingInterface = null;
        this.port = new Integer(tcpadv.getPort());
        String interfaceAddress = tcpadv.getLocalAddress();
        try {
            if (interfaceAddress == null) {
                usingInterface = AdminHelper.getInstance().getLocalHost();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In TcpTransport, the hostname or IP addr obtained from TcpAdv is null");
                }
            } else {
                usingInterface = InetAddress.getByName(interfaceAddress);
            }
            if (usingInterface.getHostAddress().equals("127.0.0.1")) {
                Tr.warning(tc, "ADMD0025W");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.TcpTransport.TcpTransport", (String)"60", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to initialize TcpTransport with exception: ", ex);
            }
            Tr.error(tc, "ADMD0018E", ex.getMessage());
        }
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName("TCP");
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.localAddress.setProtocolAddress(usingInterface.getHostAddress() + ":" + this.port);
        } else if (interfaceAddress == null) {
            this.localAddress.setProtocolAddress(usingInterface.getHostName() + ":" + this.port);
        } else {
            this.localAddress.setProtocolAddress(interfaceAddress + ":" + this.port);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TcpTransport");
        }
    }

    public boolean init(Endpoint ep) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.unicastServer = new UnicastServer(ep);
        this.unicastServer.initialize(this.port);
        return true;
    }

    public EndpointMessenger getMessenger(EndpointAddress dest) throws IOException {
        return MessengerFactory.createMessenger(dest, this);
    }

    public void close() {
        this.unicastServer.shutdown(true);
    }

    public String getProtocolName() {
        return "TCP";
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }
}

