/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import java.io.InputStream;
import java.net.Socket;

public class TcpConnection
implements Runnable {
    private static TraceComponent tc = Tr.register(TcpConnection.class);
    Endpoint endpoint;
    Socket socket;
    public static final int SoTimeout = 180000;

    public void init(Endpoint endpoint, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.endpoint = endpoint;
        this.socket = socket;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.socket.getInputStream();
            if (inputStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No InputStream");
                }
                this.socket.close();
                return;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"61", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " failed to create inputStream");
            }
            try {
                this.socket.close();
            }
            catch (Exception ignored) {
                FFDCFilter.processException((Throwable)ignored, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"66", (Object)this);
            }
            return;
        }
        while (true) {
            int size = 0;
            try {
                byte[] headerBuffer = new byte[Header.length];
                this.socket.setSoTimeout(180000);
                size = inputStream.read(headerBuffer, 0, Header.length);
                if (-1 == size) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " End of inputsteam. Closing socket");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (size != Header.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TcpHeader size mismatch( " + size + "," + Header.length + ")");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                Header header = new Header();
                if (!header.decipher(headerBuffer, 0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "can not understand the TcpHeader");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "message size = " + header.size);
                }
                int tmpSize = 0;
                byte[] buffer = new byte[header.size];
                for (size = 0; size < header.size; size += tmpSize) {
                    try {
                        tmpSize = inputStream.read(buffer, size, header.size - size);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"117", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "inputStream is broken");
                        }
                        inputStream.close();
                        this.socket.close();
                        return;
                    }
                    if (tmpSize != -1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no more bytes to receive - incomplete message");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (size != header.size) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "size mismatch, message corrupted");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                Message msg = new Message(buffer, 0, header.size);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " forward the message up to the endpoint");
                }
                this.endpoint.demux(msg);
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "run");
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.TcpConnection.run", (String)"150", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run - exception", e);
                }
                return;
            }
        }
    }
}

