/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper;
import com.ibm.ws.management.discovery.transport.UdpConnection;
import com.ibm.ws.management.discovery.transport.UdpServer;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class MulticastServer
extends UdpServer {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(MulticastServer.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private MulticastSocket serverSocket;
    private EndpointAddress mAddress;
    private InetAddress group;
    private String defaultAddr = "232.133.104.73";
    private int multicastSize;
    private boolean alive;
    private Thread acceptThread = null;
    private Endpoint endpoint;
    private static boolean rediscover_called;
    private static String configRoot;
    private static String cellName;
    private static String nodeName;
    private static String nodeAgentName;

    public MulticastServer(Endpoint endpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MulticastServer");
        }
        this.endpoint = endpoint;
        ThreadPoolMgr tpMgr = endpoint.getThreadPoolMgr();
        int maxThreads = 2;
        String threadString = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (threadString != null) {
            maxThreads = new Integer(threadString);
        }
        this.threadPool = this.getThreadPool(tpMgr, "ProcessDiscovery", maxThreads);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return MulticastServer.this.createUdpConnection();
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MulticastServer");
        }
    }

    public EndpointAddress getMulticastAddress() {
        return this.mAddress;
    }

    public boolean initialize(EndpointAddress maddress, int port, int msize) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize @" + port);
        }
        boolean init_succeeded = true;
        this.port = port;
        this.alive = true;
        this.mAddress = new EndpointAddress();
        this.mAddress.setProtocolName("MUDP");
        if (maddress.getProtocolAddress() != null) {
            this.mAddress.setProtocolAddress(maddress.getProtocolAddress());
        } else {
            this.mAddress.setProtocolAddress(this.defaultAddr);
        }
        this.multicastSize = msize <= 0 ? this.bufSize : msize;
        try {
            this.group = InetAddress.getByName(this.mAddress.getProtocolAddress());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the multicast group is " + this.group);
            }
        }
        catch (UnknownHostException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.initialize", (String)"89", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to initialize the mutlicast server", ex);
            }
            Tr.warning(tc, "ADMD0014W", new Integer(port));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - failed");
            }
            return false;
        }
        boolean joined = false;
        try {
            this.serverSocket = new MulticastSocket(port);
            this.serverSocket.joinGroup(this.group);
            joined = true;
        }
        catch (IOException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to join the multicast group", ex);
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "MulticastSocket Exception", e);
        }
        if (joined) {
            this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
            this.acceptThread.setDaemon(true);
            this.acceptThread.start();
        } else {
            init_succeeded = false;
            if (!rediscover_called) {
                rediscover_called = true;
                this.rediscover();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return init_succeeded;
    }

    public void shutdown(boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this.alive = false;
        try {
            try {
                this.serverSocket.leaveGroup(this.group);
                this.serverSocket.close();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"124", (Object)this);
                this.acceptThread.interrupt();
            }
            this.acceptThread.join(10000L);
        }
        catch (InterruptedException ie) {
            FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", (String)"129", (Object)this);
            Tr.warning(tc, "ADMD0016W", ie.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        DatagramPacket dp = null;
        int timeOut = 30000;
        int curAttempts = 0;
        String s = System.getProperty("com.ibm.websphere.management.multicastserver.sleepInterval", "15");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sleepInterval: " + s + " seconds.");
        }
        int sleepInterval = new Integer(s);
        s = System.getProperty("com.ibm.websphere.management.multicastserver.attemptsThreahold", "3");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attemptsThreshold: " + s);
        }
        int attemptsThreshold = new Integer(s);
        while (this.alive && !Thread.interrupted()) {
            block28: {
                boolean nofault;
                block27: {
                    nofault = true;
                    try {
                        this.serverSocket.setSoTimeout(timeOut);
                        byte[] buffer = new byte[this.multicastSize];
                        dp = new DatagramPacket(buffer, buffer.length);
                        this.serverSocket.receive(dp);
                    }
                    catch (IOException ioe) {
                        if (tc.isDebugEnabled()) {
                            Tr.warning(tc, "ADMD0017W", ioe.getMessage());
                            Tr.warning(tc, "...and the multicast address is " + this.mAddress.getProtocolAddress());
                        }
                        nofault = false;
                        if (curAttempts < 100) {
                            ++curAttempts;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempts: " + curAttempts);
                            Tr.debug(tc, "IO Exception received: " + ioe.getMessage());
                        }
                        if (rediscover_called) break block27;
                        rediscover_called = true;
                        this.rediscover();
                    }
                }
                timeOut = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Datagram packet(port, length): ", new Object[]{new Integer(dp.getPort()), new Integer(dp.getLength())});
                }
                if (this.alive && nofault) {
                    UdpConnection conn = null;
                    curAttempts = 0;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got good result - attempts: " + curAttempts);
                    }
                    try {
                        conn = this.allocateConnection();
                        conn.init(this.endpoint, dp);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The connection is initialized");
                        }
                        this.handleConnection(conn);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MulticastServer.run", (String)"185", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "connection  handling failure:", t);
                        }
                        if (conn == null) break block28;
                        this.freeConnection(conn);
                    }
                }
            }
            if (curAttempts < attemptsThreshold) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sleeping - attempts: " + curAttempts);
            }
            try {
                block29: {
                    Thread.sleep(sleepInterval * 1000);
                    try {
                        this.serverSocket.leaveGroup(this.group);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "left the Group.");
                        }
                        this.serverSocket.close();
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block29;
                        Tr.debug(tc, "Unable to leave the multicast group", ex);
                    }
                }
                System.out.println("Re-joining the Group.");
                try {
                    this.serverSocket = new MulticastSocket(this.port);
                    this.serverSocket.joinGroup(this.group);
                }
                catch (IOException ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unable to re-join the multicast group", ex);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "MulticastSocket Exception", e);
                }
            }
            catch (InterruptedException ie) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The MulticastServer sleep was interrupted: " + ie.getMessage());
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    void rediscover() {
        MBeanDiscoveryHelper helper;
        boolean success;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rediscover");
        }
        if (!(success = (helper = new MBeanDiscoveryHelper(configRoot, cellName, nodeName, nodeAgentName, null, "localhost", null)).discovery())) {
            Tr.warning(tc, "ADMD0024W", nodeAgentName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rediscover");
        }
    }

    public static void setupNodeAgentConnector(String theConfigRoot, String theCellName, String theNodeName, String theServerName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupNodeAgentConnector(" + theConfigRoot + "," + theCellName + "," + theNodeName + "," + theServerName + ")");
        }
        configRoot = theConfigRoot;
        cellName = theCellName;
        nodeName = theNodeName;
        nodeAgentName = theServerName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupNodeAgentConnector");
        }
    }
}

