/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.transport.MulticastServer;
import com.ibm.ws.management.discovery.transport.UdpTransport;
import java.io.IOException;

public class MUdpTransport
extends UdpTransport {
    private static TraceComponent tc = Tr.register(MUdpTransport.class);
    private int multicastPacketSize = 16384;
    private MulticastServer multicastServer;

    public MUdpTransport(MUdpAdv mudpadv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MUdpTransport");
        }
        this.port = Integer.parseInt(mudpadv.getPort());
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName(mudpadv.getProtocol());
        this.localAddress.setProtocolAddress(mudpadv.getMulticastAddr());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MUdpTransport");
        }
    }

    public boolean init(Endpoint ep) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.multicastServer = new MulticastServer(ep);
        return this.multicastServer.initialize(this.localAddress, this.port, this.multicastPacketSize);
    }

    public String getProtocolName() {
        return "MUDP";
    }

    public void close() {
        this.multicastServer.shutdown(true);
    }
}

