/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.transport.Header;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpMessenger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MUdpMessenger
extends UdpMessenger {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private TraceComponent tc = Tr.register(MUdpMessenger.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.discovery");

    public MUdpMessenger(EndpointAddress address, TransportProtocol protocol) throws IOException {
        int portIndex;
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "MUdpMessenger", address);
        }
        this.destination = address;
        this.protocol = protocol;
        this.header = new Header();
        this.source = protocol.getLocalAddress();
        String tmp = this.destination.getProtocolAddress();
        int ind = tmp.indexOf(93);
        if (ind < 0) {
            ind = 0;
        }
        if ((portIndex = tmp.indexOf(58, ind)) == -1) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "MUdpMessenger - failed");
            }
            throw new IOException(this.nls.getString("ADMD0010E"));
        }
        this.port = Integer.valueOf(tmp.substring(portIndex + 1));
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "multicast port is " + this.port);
        }
        this.inetAddress = InetAddress.getByName(tmp.substring(0, portIndex));
        if (!this.inetAddress.isMulticastAddress()) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "MUdpMessenger - failed");
            }
            throw new IOException(this.nls.getString("ADMD0002E", "only multicast address is allowed"));
        }
        if (!this.openSocket()) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "MUdpMessenger - failed");
            }
            throw new IOException(this.nls.getFormattedMessage("ADMD0003E", new Object[]{this.inetAddress}, "Failed to open the multicast socket to join multicast group: {0}"));
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "MUdpMessenger");
        }
    }

    public void close() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "close");
        }
        if (this.socket != null) {
            try {
                ((MulticastSocket)this.socket).leaveGroup(this.inetAddress);
                this.socket.close();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.MUdpMessenger.close", (String)"109", (Object)this);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "close");
        }
    }

    private boolean openSocket() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "openSocket");
        }
        this.socket = null;
        try {
            this.socket = new MulticastSocket();
            ((MulticastSocket)this.socket).joinGroup(this.inetAddress);
            ((MulticastSocket)this.socket).setTimeToLive(0);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "openSocket - good");
            }
            return true;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.discovery.transport.MUdpMessenger.openSocket", (String)"134", (Object)this);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "openSocket - bad", e);
            }
            return false;
        }
    }
}

