/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MBeanDiscoveryHelper {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(MBeanDiscoveryHelper.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.discovery");
    private Hashtable connectors = new Hashtable(connTypes.length);
    String localAdminProtocol = null;
    String remoteAdminProtocol = null;
    String preferredConnector = null;
    String serverName = null;
    private static String[] connTypes = new String[]{"SOAP", "RMI", "JSR160RMI", "IPC"};
    private static String[] typeNames = new String[]{"SOAPConnector", "RMIConnector", "JSR160RMIConnector", "IPCConnector"};
    private static String[] endpointNames = new String[]{"SOAP_CONNECTOR_ADDRESS", "RMI_CONNECTOR_ADDRESS", "JSR160RMI_CONNECTOR_ADDRESS", "IPC_CONNECTOR_ADDRESS"};
    private static Hashtable typeNameToConnType = new Hashtable(typeNames.length);

    public MBeanDiscoveryHelper(String configRoot, String cellName, String nodeName, String serverName, String uuid, String defaultHostName, String managedNodeName) {
        ConfigObject object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MBeanDiscoveryHelper constructor: configRoot: " + configRoot + ", cellName: " + cellName + ", nodeName: " + nodeName + ", serverName: " + serverName + ", managedNodeName: " + managedNodeName);
        }
        if (configRoot == null || cellName == null || nodeName == null || serverName == null) {
            Exception t = new Exception("Insufficient information to locate a server: configRoot: " + configRoot + ", cellName: " + cellName + ", nodeName: " + nodeName + ", serverName: " + serverName + ", managedNodeName: " + managedNodeName);
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"134", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MBeanDiscoveryHelper constructor: no information about server");
            }
            return;
        }
        this.serverName = serverName;
        for (int i = 0; i < typeNames.length; ++i) {
            ConnectorInfo info = new ConnectorInfo();
            info.endpointName = endpointNames[i];
            this.connectors.put(connTypes[i], info);
        }
        ConfigService configService = ConfigServiceFactory.createConfigService((String)configRoot, (String)cellName, (String)nodeName, (String)serverName);
        if (uuid == null && managedNodeName == null) {
            List serverObjs = null;
            try {
                serverObjs = configService.getDocumentObjects(configService.getScope(4), "server.xml");
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"145", (Object)this);
            }
            if (serverObjs == null || serverObjs.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can't find server.xml for server : " + serverName);
                }
            } else {
                object = (ConfigObject)serverObjs.get(0);
                List services = object.getObjectList("services");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object has: " + services.size() + " services");
                }
                for (ConfigObject service : services) {
                    List connectorsList;
                    ConfigObject preferredConnectorObj;
                    ConfigObject remoteAdminProtocolObj;
                    String typeName = service.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "services type: " + typeName);
                    }
                    if (!"AdminService".equals(typeName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "found Adminservice for server: " + serverName);
                    }
                    HashMap adminProtocols = new HashMap();
                    ConfigObject localAdminProtocolObj = service.getObject("localAdminProtocol");
                    if (localAdminProtocolObj != null) {
                        this.localAdminProtocol = (String)typeNameToConnType.get(localAdminProtocolObj.getTypeName());
                    }
                    if ((remoteAdminProtocolObj = service.getObject("remoteAdminProtocol")) != null) {
                        this.remoteAdminProtocol = (String)typeNameToConnType.get(remoteAdminProtocolObj.getTypeName());
                    }
                    if ((preferredConnectorObj = service.getObject("preferredConnector")) != null) {
                        this.preferredConnector = (String)typeNameToConnType.get(preferredConnectorObj.getTypeName());
                    }
                    if ((connectorsList = service.getObjectList("connectors")) == null || connectorsList.size() <= 0) break;
                    for (ConfigObject connector2 : connectorsList) {
                        ConnectorInfo info;
                        String type = (String)typeNameToConnType.get(connector2.getTypeName());
                        boolean enabled = connector2.getBoolean("enable", true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "connector type: " + type + " enabled: " + enabled);
                        }
                        if (type == null || (info = (ConnectorInfo)this.connectors.get(type)) == null) continue;
                        info.enabled = enabled;
                    }
                    break;
                }
            }
        } else {
            List managedNodeObjs = null;
            try {
                ConfigScope scope = configService.createScope(6);
                scope.set(6, managedNodeName);
                managedNodeObjs = configService.getDocumentObjects(scope, "managednode.xml");
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"145", (Object)this);
            }
            if (managedNodeObjs == null || managedNodeObjs.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can't find managednode.xml for node: " + nodeName);
                }
            } else {
                List connectorsList;
                ConfigObject preferredConnectorObj;
                ConfigObject remoteAdminProtocolObj;
                object = (ConfigObject)managedNodeObjs.get(0);
                List ass = object.getObjectList("adminService");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object has: " + ass.size() + " adminService");
                }
                ConfigObject as = (ConfigObject)ass.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found Adminservice for managedNode: " + managedNodeName);
                }
                HashMap adminProtocols = new HashMap();
                ConfigObject localAdminProtocolObj = as.getObject("localAdminProtocol");
                if (localAdminProtocolObj != null) {
                    this.localAdminProtocol = (String)typeNameToConnType.get(localAdminProtocolObj.getTypeName());
                }
                if ((remoteAdminProtocolObj = as.getObject("remoteAdminProtocol")) != null) {
                    this.remoteAdminProtocol = (String)typeNameToConnType.get(remoteAdminProtocolObj.getTypeName());
                }
                if ((preferredConnectorObj = as.getObject("preferredConnector")) != null) {
                    this.preferredConnector = (String)typeNameToConnType.get(preferredConnectorObj.getTypeName());
                }
                if ((connectorsList = as.getObjectList("connectors")) != null && connectorsList.size() > 0) {
                    for (ConfigObject connector3 : connectorsList) {
                        ConnectorInfo info;
                        String type = (String)typeNameToConnType.get(connector3.getTypeName());
                        boolean enabled = connector3.getBoolean("enable", true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "connector type: " + type + " enabled: " + enabled);
                        }
                        if (type == null || (info = (ConnectorInfo)this.connectors.get(type)) == null) continue;
                        info.enabled = enabled;
                    }
                }
            }
        }
        List serverIndex = null;
        try {
            serverIndex = configService.getDocumentObjects(configService.getScope(3), "serverindex.xml");
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"216", (Object)this);
        }
        if (serverIndex == null || serverIndex.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can't find serverindex for node: " + nodeName);
            }
        } else {
            String bootstrapEndpointName = null;
            if (uuid == null) {
                bootstrapEndpointName = "BOOTSTRAP_ADDRESS";
            }
            String bootstrapHost = null;
            String bootstrapPort = null;
            ConfigObject object2 = (ConfigObject)serverIndex.get(0);
            List serverEntries = object2.getObjectList("serverEntries");
            String secString = "false";
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                secString = "true";
            }
            for (ConfigObject serverEntry : serverEntries) {
                String tmpServerName = serverEntry.getString("serverName", "");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverEntries serverName: " + tmpServerName);
                }
                if (!serverName.equals(tmpServerName)) continue;
                List specialEndpoints = serverEntry.getObjectList("specialEndpoints");
                block11: for (ConfigObject namedEndpoint : specialEndpoints) {
                    String endpointName = namedEndpoint.getString("endPointName", "");
                    ConfigObject endPoint = namedEndpoint.getObject("endPoint");
                    String tmpHost = endPoint.getString("host", defaultHostName);
                    if (tmpHost == null || tmpHost.length() <= 0) {
                        tmpHost = defaultHostName;
                    }
                    String port = new Integer(endPoint.getInt("port", 0)).toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endpointName: " + endpointName + ", hostName: " + tmpHost + " port: " + port);
                    }
                    if (bootstrapEndpointName != null && bootstrapEndpointName.equals(endpointName)) {
                        bootstrapHost = tmpHost;
                        bootstrapPort = port;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found boostratpHost: " + bootstrapHost + " bootstrapPort: " + bootstrapPort);
                        continue;
                    }
                    for (int i = 0; i < connTypes.length; ++i) {
                        ConnectorInfo info = (ConnectorInfo)this.connectors.get(connTypes[i]);
                        String infoEndPointName = info.endpointName;
                        if (uuid != null && managedNodeName != null) {
                            infoEndPointName = infoEndPointName + "_" + managedNodeName;
                        }
                        if (!infoEndPointName.equals(endpointName) || !info.enabled) continue;
                        info.props = new Properties();
                        info.props.setProperty("type", connTypes[i]);
                        info.props.setProperty("host", tmpHost);
                        info.props.setProperty("port", port);
                        info.props.setProperty("securityEnabled", secString);
                        info.props.setProperty("isInternal", "true");
                        if (connTypes[i].equals(this.localAdminProtocol)) {
                            info.props.setProperty("localAdminProtocol", "true");
                        }
                        if (connTypes[i].equals(this.remoteAdminProtocol)) {
                            info.props.setProperty("remoteAdminProtocol", "true");
                        }
                        if (connTypes[i].equals(this.preferredConnector)) {
                            info.props.setProperty("preferred", "true");
                        }
                        if (!tc.isDebugEnabled()) continue block11;
                        Tr.debug(tc, "found connector properties: " + info.props);
                        continue block11;
                    }
                }
            }
            if (uuid == null && bootstrapHost != null && bootstrapPort != null) {
                ConnectorInfo jsr160rmiInfo;
                ConnectorInfo rmiInfo = (ConnectorInfo)this.connectors.get("RMI");
                if (rmiInfo != null && rmiInfo.enabled && rmiInfo.props == null) {
                    rmiInfo.props = new Properties();
                    rmiInfo.props.setProperty("type", "RMI");
                    rmiInfo.props.setProperty("host", bootstrapHost);
                    rmiInfo.props.setProperty("port", bootstrapPort);
                    rmiInfo.props.setProperty("securityEnabled", secString);
                    rmiInfo.props.setProperty("isInternal", "true");
                    if ("RMI".equals(this.localAdminProtocol)) {
                        rmiInfo.props.setProperty("localAdminProtocol", "true");
                    }
                    if ("RMI".equals(this.remoteAdminProtocol)) {
                        rmiInfo.props.setProperty("remoteAdminProtocol", "true");
                    }
                    if ("RMI".equals(this.preferredConnector)) {
                        rmiInfo.props.setProperty("preferred", "true");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using bootstrap host/port for RMI connector:" + rmiInfo.props);
                    }
                }
                if ((jsr160rmiInfo = (ConnectorInfo)this.connectors.get("JSR160RMI")) != null && jsr160rmiInfo.enabled && jsr160rmiInfo.props == null) {
                    jsr160rmiInfo.props = new Properties();
                    jsr160rmiInfo.props.setProperty("type", "JSR160RMI");
                    jsr160rmiInfo.props.setProperty("host", bootstrapHost);
                    jsr160rmiInfo.props.setProperty("port", bootstrapPort);
                    jsr160rmiInfo.props.setProperty("securityEnabled", secString);
                    jsr160rmiInfo.props.setProperty("isInternal", "true");
                    if ("JSR160RMI".equals(this.localAdminProtocol)) {
                        jsr160rmiInfo.props.setProperty("localAdminProtocol", "true");
                    }
                    if ("JSR160RMI".equals(this.remoteAdminProtocol)) {
                        jsr160rmiInfo.props.setProperty("remoteAdminProtocol", "true");
                    }
                    if ("JSR160RMI".equals(this.preferredConnector)) {
                        jsr160rmiInfo.props.setProperty("preferred", "true");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using bootstrap host/port for JSR160RMI connector:" + jsr160rmiInfo.props);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localAdminProtocol: " + this.localAdminProtocol + " remoteAdminProtocol: " + this.remoteAdminProtocol + "  preferredConnector: " + this.preferredConnector);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MBeanDiscoveryHelper constructor");
        }
    }

    AdminClient create() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        AdminClient client = null;
        Hashtable tried = new Hashtable();
        client = this.tryProtocol(this.localAdminProtocol, tried);
        if (client == null && tried.size() == 0) {
            client = this.tryProtocol(this.remoteAdminProtocol, tried);
        }
        if (client == null && tried.size() == 0) {
            client = this.tryProtocol(this.preferredConnector, tried);
        }
        if (client == null && tried.size() == 0) {
            for (int i = 0; i < connTypes.length && (client = this.tryProtocol(connTypes[i], tried)) == null && tried.size() <= 0; ++i) {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", client);
        }
        return client;
    }

    public boolean discovery() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discovery");
        }
        AdminClient client = null;
        boolean warning = false;
        boolean success = false;
        Subject subject = SecurityHelper.getServerSubject();
        if (subject != null) {
            SecurityHelper.pushInvocationSubject(subject);
        }
        try {
            client = this.create();
        }
        catch (ConnectorException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to create admin client to nodeagent", ex);
            }
            warning = true;
        }
        if (client != null) {
            ObjectName query = null;
            try {
                query = new ObjectName("*:*,type=Discovery,process=" + this.serverName);
            }
            catch (MalformedObjectNameException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper.discover", (String)"405", (Object)this);
                warning = true;
            }
            try {
                Set s = client.queryNames(query, null);
                if (s.iterator().hasNext()) {
                    ObjectName discoveryMBean = (ObjectName)s.iterator().next();
                    client.invoke(discoveryMBean, "query", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{ServerInfo.class.getName()});
                    success = true;
                } else {
                    warning = true;
                }
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to send out discover message", ex);
                }
                warning = true;
            }
        }
        if (warning) {
            Tr.warning(tc, "ADMD0024W", this.serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discovery", success);
        }
        return success;
    }

    private AdminClient tryProtocol(String connType, Hashtable tried) {
        AdminClient ret;
        block4: {
            ConnectorInfo info;
            ret = null;
            if (connType != null && tried.get(connType) == null && (info = (ConnectorInfo)this.connectors.get(connType)) != null && info.enabled && info.props != null) {
                try {
                    tried.put(connType, connType);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "trying to create admin client with properties:", info.props);
                    }
                    ret = AdminClientFactory.createAdminClient(info.props);
                    Tr.debug(tc, "admin client created");
                }
                catch (ConnectorException ex) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Unable to create Admin client", info.props);
                }
            }
        }
        return ret;
    }

    static {
        for (int i = 0; i < typeNames.length; ++i) {
            typeNameToConnType.put(typeNames[i], connTypes[i]);
        }
    }

    private static class ConnectorInfo {
        public Properties props = null;
        public boolean enabled = false;
        public String endpointName;

        private ConnectorInfo() {
        }
    }
}

