/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class Header {
    private static TraceComponent tc = Tr.register(Header.class);
    public byte cmd;
    public byte[] srcAddr = new byte[4];
    public int srcPort;
    public int size;
    public int option;
    public int packetId;
    public static int length = 20;
    public static final byte PROPAGATE = 1;
    public static final byte UNICAST = 2;
    public static final byte ACK = 3;
    public static final byte NACK = 4;
    public static final byte HANDCHECK = 1;
    public static final byte NONBLOCKING = 2;

    private static void cipherInt4(int v, byte[] buffer, int offset) {
        buffer[offset] = (byte)((v & 0xFF000000) >> 24);
        buffer[offset + 1] = (byte)((v & 0xFF0000) >> 16);
        buffer[offset + 2] = (byte)((v & 0xFF00) >> 8);
        buffer[offset + 3] = (byte)(v & 0xFF);
    }

    private static void cipherInt2(int v, byte[] buffer, int offset) {
        buffer[offset] = (byte)((v & 0xFF00) >> 8);
        buffer[offset + 1] = (byte)(v & 0xFF);
    }

    private static int decipherInt4(byte[] buffer, int offset) {
        return buffer[offset] << 24 & 0xFF000000 | buffer[offset + 1] << 16 & 0xFF0000 | buffer[offset + 2] << 8 & 0xFF00 | buffer[offset + 3] & 0xFF;
    }

    private static int decipherInt2(byte[] buffer, int offset) {
        return buffer[offset] << 8 & 0xFF00 | buffer[offset + 1] & 0xFF;
    }

    public boolean decipher(byte[] buffer, int offset) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decipher");
        }
        this.cmd = buffer[offset];
        if (this.cmd != 1 && this.cmd != 2 && this.cmd != 3 && this.cmd != 4) {
            return false;
        }
        this.srcAddr[0] = buffer[offset + 1];
        this.srcAddr[1] = buffer[offset + 2];
        this.srcAddr[2] = buffer[offset + 3];
        this.srcAddr[3] = buffer[offset + 4];
        this.srcPort = Header.decipherInt2(buffer, offset + 5);
        this.size = Header.decipherInt4(buffer, offset + 7);
        this.option = buffer[offset + 11];
        this.packetId = Header.decipherInt4(buffer, offset + 12);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "srcPort = " + this.srcPort + " size = " + this.size + " packetId = " + this.packetId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decipher");
        }
        return true;
    }

    public void cipher(byte[] buffer, int offset) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cipher");
        }
        int tmpOffset = offset;
        buffer[tmpOffset++] = this.cmd;
        buffer[tmpOffset++] = this.srcAddr[0];
        buffer[tmpOffset++] = this.srcAddr[1];
        buffer[tmpOffset++] = this.srcAddr[2];
        buffer[tmpOffset++] = this.srcAddr[3];
        Header.cipherInt2(this.srcPort, buffer, tmpOffset);
        Header.cipherInt4(this.size, buffer, tmpOffset += 2);
        tmpOffset += 4;
        buffer[tmpOffset++] = (byte)this.option;
        Header.cipherInt4(this.packetId, buffer, tmpOffset);
        tmpOffset += 4;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cipher");
        }
    }
}

