/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.ServiceAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PeerAdv
implements Advertisement {
    private static TraceComponent tc = Tr.register(PeerAdv.class);
    private String name = null;
    private String pid = null;
    private String cell = null;
    private String node = null;
    private String role = null;
    private String version = null;
    private EndpointAdv endpointAdv = null;
    private ServiceAdv serviceAdv = null;

    public String getAdvertisementType() {
        return "jxta:PeerAdvertisement";
    }

    public PeerAdv() {
    }

    public PeerAdv(ServerInfo info, ServiceAdv serviceAdv, EndpointAdv endpointAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PeerAdv", new Object[]{info, serviceAdv, endpointAdv});
        }
        this.name = info.getName();
        this.pid = info.getPid();
        this.cell = info.getCell();
        this.node = info.getNode();
        this.role = info.getRole();
        this.version = info.getVersion();
        this.serviceAdv = serviceAdv;
        this.endpointAdv = endpointAdv;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PeerAdv");
        }
    }

    public PeerAdv(Element root) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PeerAdv(Element)");
        }
        this.initialize(root);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PeerAdv(Element)");
        }
    }

    public void initialize(Node root) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node element = root.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + element.getNodeName() + " value = " + element.getFirstChild().getNodeValue());
            }
            if (element.getNodeName().equals("Name")) {
                this.name = element.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (element.getNodeName().equals("Pid")) {
                this.pid = element.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (element.getNodeName().equals("Version")) {
                this.version = element.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (element.getNodeName().equals("Cell")) {
                this.cell = element.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (element.getNodeName().equals("Node")) {
                this.node = element.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (element.getNodeName().equals("Role")) {
                this.role = element.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (element.getNodeName().equals("Service")) {
                this.serviceAdv = new ServiceAdv((Element)element);
                continue;
            }
            if (!element.getNodeName().equals("Endpoint")) continue;
            this.endpointAdv = new EndpointAdv((Element)element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public XMLDocument getXMLDocument() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument adv = new XMLDocument(this.getAdvertisementType());
        Element e = null;
        if (this.getName() != null) {
            e = adv.createElement("Name", this.getName());
            adv.appendChild(e);
        }
        if (this.getPid() != null) {
            e = adv.createElement("Pid", this.getPid());
            adv.appendChild(e);
        }
        if (this.getVersion() != null) {
            e = adv.createElement("Version", this.getVersion());
            adv.appendChild(e);
        }
        if (this.getCell() != null) {
            e = adv.createElement("Cell", this.getCell());
            adv.appendChild(e);
        }
        if (this.getNode() != null) {
            e = adv.createElement("Node", this.getNode());
            adv.appendChild(e);
        }
        if (this.getCell() != null) {
            e = adv.createElement("Role", this.getRole());
            adv.appendChild(e);
        }
        e = adv.createElement("Endpoint");
        EndpointAdv eadv = this.getEndpointAdv();
        XMLDocument xptDoc = eadv.getXMLDocument();
        adv.copyElements(xptDoc, e);
        adv.appendChild(e);
        e = adv.createElement("Service");
        ServiceAdv sadv = this.getServiceAdv();
        xptDoc = sadv.getXMLDocument();
        adv.copyElements(xptDoc, e);
        adv.appendChild(e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return adv;
    }

    public String getName() {
        return this.name;
    }

    public String getPid() {
        return this.pid;
    }

    public String getCell() {
        return this.cell;
    }

    public String getNode() {
        return this.node;
    }

    public String getRole() {
        return this.role;
    }

    public EndpointAdv getEndpointAdv() {
        return this.endpointAdv;
    }

    public ServiceAdv getServiceAdv() {
        return this.serviceAdv;
    }

    public void setServiceAdv(ServiceAdv adv) {
        this.serviceAdv = adv;
    }

    public String toString() {
        Properties props = new Properties();
        props.setProperty("Name", this.getName());
        props.setProperty("Cell", this.getCell());
        props.setProperty("Node", this.getNode());
        props.setProperty("Role", this.getRole());
        return props.toString();
    }

    public String getVersion() {
        return this.version;
    }
}

