/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.PeerAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import java.io.InputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoveryQueryMsg
implements Advertisement {
    private static TraceComponent tc = Tr.register(DiscoveryQueryMsg.class);
    private int type = 0;
    private long queryId = 0L;
    private PeerAdv peeradv = null;
    private String cell = null;
    private String node = null;
    private String role = null;

    public DiscoveryQueryMsg(int type, long queryId, ServerInfo info, PeerAdv peerAdv) {
        this.type = type;
        this.queryId = queryId;
        this.cell = info.getCell();
        this.node = info.getNode();
        this.role = info.getRole();
        this.peeradv = peerAdv;
    }

    public DiscoveryQueryMsg(InputStream stream) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DiscoveryQueryMsg(InputStream)");
        }
        XMLDocument doc = new XMLDocument(stream);
        this.readIt(doc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DiscoveryQueryMsg(InputStream)");
        }
    }

    public DiscoveryQueryMsg(XMLDocument document) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DiscoveryQueryMsg(XMLDocument)");
        }
        this.readIt(document);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DiscoveryQueryMsg(XMLDocument)");
        }
    }

    private void readIt(XMLDocument doc) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readIt");
        }
        Element root = doc.getDocumentElement();
        block0: for (Node elem = root.getFirstChild(); elem != null; elem = elem.getNextSibling()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + elem.getNodeName() + " value =" + (elem.getFirstChild() == null ? "**null first child**" : elem.getFirstChild().getNodeValue()));
            }
            if (elem.getNodeName().equals("Type")) {
                this.type = Integer.parseInt(elem.getFirstChild().getNodeValue());
                continue;
            }
            if (elem.getNodeName().equals("QueryId")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "query Id = " + elem.getFirstChild().getNodeValue());
                }
                this.queryId = Integer.parseInt(elem.getFirstChild().getNodeValue());
                continue;
            }
            if (elem.getNodeName().equals("PeerAdv")) {
                NodeList nl = elem.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node nd = nl.item(i);
                    if (!(nd instanceof Element)) continue;
                    this.peeradv = new PeerAdv((Element)nd);
                    continue block0;
                }
                continue;
            }
            if (elem.getNodeName().equals("Cell")) {
                this.cell = elem.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (elem.getNodeName().equals("Node")) {
                this.node = elem.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!elem.getNodeName().equals("Role")) continue;
            this.role = elem.getFirstChild().getNodeValue().trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readIt");
        }
    }

    public String getAdvertisementType() {
        return "jxta:DiscoveryQuery";
    }

    public int getDiscoveryType() {
        return this.type;
    }

    public PeerAdv getPeerAdv() {
        return this.peeradv;
    }

    public String getCell() {
        return this.cell;
    }

    public String getNode() {
        return this.node;
    }

    public String getRole() {
        return this.role;
    }

    public ServerInfo getServerInfo() {
        return new ServerInfo(this.cell, this.node, this.role);
    }

    public long getQueryId() {
        return this.queryId;
    }

    public XMLDocument getXMLDocument() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument adv = new XMLDocument(this.getAdvertisementType());
        Element e = adv.createElement("Type", Integer.toString(this.type));
        adv.appendChild(e);
        e = adv.createElement("QueryId", Long.toString(this.queryId));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "query Id = " + this.queryId);
        }
        adv.appendChild(e);
        e = adv.createElement("PeerAdv");
        adv.appendChild(e);
        adv.copyElements(this.getPeerAdv().getXMLDocument(), e);
        if (this.getCell() != null) {
            e = adv.createElement("Cell", this.getCell());
            adv.appendChild(e);
        }
        if (this.getNode() != null) {
            e = adv.createElement("Node", this.getNode());
            adv.appendChild(e);
        }
        if (this.getCell() != null) {
            e = adv.createElement("Role", this.getRole());
            adv.appendChild(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return adv;
    }
}

