/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper;
import java.util.Date;

public class MBeanDiscoveryService
implements AlarmListener {
    public static final String DISCOVERY_TIME_LIMIT = "com.ibm.websphere.management.MBeanDiscoveryService.timeout";
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(MBeanDiscoveryService.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private MBeanDiscoveryHelper discoveryHelper = null;
    private long startTime;
    private int timeout = 1200000;
    private int alarmInterval = 50;
    private String uuid = AdminContext.peek();

    public MBeanDiscoveryService(MBeanDiscoveryHelper discoveryHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MBeanDiscoveryService with uuid:" + this.uuid, discoveryHelper);
        }
        this.discoveryHelper = discoveryHelper;
        String timeoutProp = System.getProperty(DISCOVERY_TIME_LIMIT);
        if (timeoutProp != null) {
            try {
                int tmp = Integer.parseInt(timeoutProp);
                if (tmp > 0) {
                    this.timeout = tmp * 1000;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MBeanDiscoveryService will time out in " + this.timeout / 60000 + " minutes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MBeanDiscoveryService", discoveryHelper);
        }
    }

    public void startDiscovery() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDiscovery " + this.uuid);
        }
        this.startTime = new Date().getTime();
        AlarmManager.createNonDeferrable((long)this.alarmInterval, (AlarmListener)this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDiscovery " + this.uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alarm(Object alarmContext) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm uuid=" + this.uuid, this.discoveryHelper);
            }
            boolean pushed = false;
            try {
                if (this.uuid != null) {
                    pushed = AdminContext.push((String)this.uuid);
                }
                if (this.discoveryHelper.discovery()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "discovery succeeded", this.discoveryHelper);
                    }
                } else {
                    long currentTime;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "discovery failed ");
                    }
                    if ((currentTime = new Date().getTime()) > this.startTime + (long)this.timeout) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "discovery timed out");
                        }
                    } else {
                        this.alarmInterval = this.alarmInterval < 60000 ? 60000 : (this.alarmInterval += this.alarmInterval);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Will retry discovery in " + this.alarmInterval / 60000 + " minutes");
                        }
                        AlarmManager.createNonDeferrable((long)this.alarmInterval, (AlarmListener)this);
                    }
                }
                Object var6_4 = null;
                if (!pushed) break block14;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (pushed) {
                    AdminContext.pop();
                }
                throw throwable;
            }
            AdminContext.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }
}

