/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.QueryHandler;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.transport.MUdpTransport;
import com.ibm.ws.management.discovery.transport.TcpTransport;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpTransport;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Endpoint {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(Endpoint.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private Hashtable handlers = new Hashtable();
    private Hashtable transports = new Hashtable();
    private TransportProtocol primaryTransport;
    private EndpointAdv epadv;
    private String name;
    private EndpointAddress address;
    private ThreadPoolMgr tpMgr;

    public Endpoint(EndpointAdv adv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Endpoint");
        }
        this.epadv = adv;
        this.name = adv.getName();
        try {
            this.address = new EndpointAddress(adv.getEndpointAddress().trim());
        }
        catch (InvalidEndpointAddressException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.Endpoint.Endpoint", (String)"61", (Object)this);
            Tr.error(tc, "ADMD0010E");
            return;
        }
        TransportAdvertisement tadv = adv.getTransportAdvertisement();
        String protoName = tadv.getProtocol();
        if (protoName.equalsIgnoreCase("TCP")) {
            TcpTransport tcpp = new TcpTransport((TcpAdv)tadv);
            this.addProtocol(tcpp);
        } else if (protoName.equalsIgnoreCase("UDP")) {
            UdpTransport udpp = new UdpTransport((UdpAdv)tadv);
            this.addProtocol(udpp);
        } else if (protoName.equalsIgnoreCase("MUDP")) {
            MUdpTransport mudpp = new MUdpTransport((MUdpAdv)tadv);
            this.addProtocol(mudpp);
        } else {
            Tr.error(tc, "ADMD0011E");
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Endpoint");
        }
    }

    public ThreadPoolMgr getThreadPoolMgr() {
        return this.tpMgr;
    }

    public boolean initialize(ThreadPoolMgr tpm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        boolean init_succeeded = true;
        this.tpMgr = tpm;
        Enumeration vEnum = this.transports.elements();
        int nbr_protos = 0;
        while (vEnum.hasMoreElements()) {
            TransportProtocol proto = (TransportProtocol)vEnum.nextElement();
            if (tc.isDebugEnabled() && ++nbr_protos > 1) {
                Tr.debug(tc, "There are " + nbr_protos + " protocols for this Endpoint.");
            }
            try {
                init_succeeded = proto.init(this);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.Endpoint.initialize", (String)"101", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to initilize the transport", ex);
                }
                Tr.warning(tc, "ADMD0012E", proto.getProtocolName());
                init_succeeded = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return init_succeeded;
    }

    public void demux(Message incomingMsg) {
        EndpointAddress target;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "demux");
        }
        if (!this.addressMatched(target = incomingMsg.getDestinationAddress())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the incoming message is not for this endpoint", new Object[]{target, this.address});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "demux - failed");
            }
            return;
        }
        String serviceName = target.getServiceName();
        if (serviceName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The message doesn't specify the target service");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "demux - failed");
            }
            return;
        }
        QueryHandler handler = this.lookupHandler(serviceName);
        if (handler == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No handler is found for the incoming message", serviceName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "demux - failed");
            }
            return;
        }
        handler.demux(incomingMsg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "demux");
        }
    }

    public synchronized void registerHandler(String serviceName, QueryHandler handler) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerHandler", serviceName);
        }
        this.handlers.put(serviceName, handler);
    }

    public synchronized QueryHandler lookupHandler(String serviceName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lookupHandler", serviceName);
        }
        return (QueryHandler)this.handlers.get(serviceName);
    }

    public void addProtocol(TransportProtocol protocol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProtocol: " + protocol.getProtocolName());
        }
        if (this.primaryTransport == null) {
            this.primaryTransport = protocol;
        }
        this.transports.put(protocol.getProtocolName(), protocol);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProtocol");
        }
    }

    public TransportProtocol getProtocol(String name) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getProtocol", name);
        }
        return (TransportProtocol)this.transports.get(name);
    }

    public EndpointAddress getEndpointAddress() {
        return this.address;
    }

    public EndpointMessenger getMessenger(EndpointAddress addr) throws IOException {
        return this.primaryTransport.getMessenger(addr);
    }

    private boolean addressMatched(EndpointAddress target) {
        boolean matched;
        block7: {
            String host1;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addressMatched", target);
            }
            if ((matched = target.getProtocolName().equalsIgnoreCase(this.address.getProtocolName())) && !target.getProtocolAddress().equalsIgnoreCase(this.address.getProtocolAddress()) && !(host1 = target.getProtocolHost()).equals("127.0.0.1")) {
                String host2 = this.address.getProtocolHost();
                try {
                    if (!InetAddress.getByName(host1).equals(InetAddress.getByName(host2))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "target host does not match local host", new Object[]{host1, host2});
                        }
                        matched = false;
                    }
                }
                catch (UnknownHostException ex) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "can not get host inetaddress", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addressMatched", new Boolean(matched));
        }
        return matched;
    }
}

