/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.discovery.DiscoveryEvent;
import com.ibm.ws.management.discovery.DiscoveryListener;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.QueryHandler;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.exception.DiscardQueryException;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import com.ibm.ws.management.discovery.protocol.DiscoveryQueryMsg;
import com.ibm.ws.management.discovery.protocol.DiscoveryResponseMsg;
import com.ibm.ws.management.discovery.protocol.PeerAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import com.ibm.ws.management.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Element;

public class DiscoveryService
implements QueryHandler {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(DiscoveryService.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls;
    private static long querySerialNumber = 1L;
    private static HashSet unresolvableHosts = new HashSet();
    private Endpoint endpoint;
    private PeerAdv advertisement;
    private EndpointAddress serviceAddress;
    private ServerInfo serverInfo;
    private String adminType;
    private String cellName;
    private String nodeName;
    Vector discoveryListeners;

    public DiscoveryService(ServerInfo info, Endpoint endpoint, PeerAdv advertisement) {
        block4: {
            this.nls = TraceNLS.getTraceNLS(bundleName);
            this.discoveryListeners = new Vector();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DiscoveryService");
            }
            this.serverInfo = info;
            this.endpoint = endpoint;
            this.advertisement = advertisement;
            Properties configProps = AdminInitializer.getInstance().getProperties();
            this.adminType = (String)configProps.get("adminTypeProperty");
            this.cellName = (String)configProps.get("cellNameConfigProperty");
            this.nodeName = (String)configProps.get("nodeNameConfigProperty");
            try {
                this.serviceAddress = new EndpointAddress(endpoint.getEndpointAddress().getURI() + "DiscoveryService");
            }
            catch (InvalidEndpointAddressException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.DiscoveryService", (String)"92", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "invalide endpoint address", ex);
            }
        }
        endpoint.registerHandler("DiscoveryService", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DiscoveryService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDiscoveryListener");
        }
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            this.discoveryListeners.addElement(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDiscoveryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDiscoveryListener");
        }
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            this.discoveryListeners.removeElement(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDiscoveryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long sendQuery(EndpointAddress destination, ServerInfo target) {
        long queryId;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendQuery");
            }
            queryId = 0L;
            DiscoveryService discoveryService = this;
            // MONITORENTER : discoveryService
            queryId = querySerialNumber++;
            // MONITOREXIT : discoveryService
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Query Id Number: " + queryId + " Query Serial Number: " + querySerialNumber);
            }
            boolean resolvable = true;
            if (destination != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "End-2-end messaging: queryId: " + queryId);
                }
                Message message = null;
                try {
                    DiscoveryQueryMsg queryMsg = new DiscoveryQueryMsg(0, queryId, target, this.advertisement);
                    message = new Message(queryMsg.getXMLDocument().getInputStream(), this.serviceAddress, destination);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "message[src, dest]", new Object[]{this.serviceAddress, destination});
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"148", (Object)this);
                    Tr.warning(tc, "ADMD0007W", ex.getMessage());
                    queryId = -1L;
                    if (!tc.isEntryEnabled()) return queryId;
                    Tr.exit(tc, "sendQuery: " + queryId);
                    return queryId;
                }
                EndpointMessenger messenger = null;
                try {
                    String host2;
                    block29: {
                        try {
                            messenger = this.endpoint.getMessenger(destination);
                            if (messenger == null) break block29;
                            DiscoveryListener[] listeners = this.copyListener();
                            DiscoveryEvent de = new DiscoveryEvent(this, DiscoveryEvent.SENDING, queryId);
                            for (int i = 0; i < listeners.length; ++i) {
                                listeners[i].event(de);
                            }
                            messenger.sendMessage(message);
                        }
                        catch (UnknownHostException ex) {
                            String host2;
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"177", (Object)this);
                            queryId = -1L;
                            resolvable = false;
                            String host22 = destination.getProtocolHost();
                            if (!unresolvableHosts.contains(host22)) {
                                unresolvableHosts.add(host22);
                                Tr.warning(tc, "ADMD0022W", new Object[]{host22});
                            }
                            Object var13_19 = null;
                            if (resolvable && unresolvableHosts.contains(host2 = destination.getProtocolHost())) {
                                unresolvableHosts.remove(host2);
                            }
                            if (messenger != null) {
                                messenger.close();
                            }
                            break block30;
                        }
                        catch (IOException ioe) {
                            String host2;
                            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"189", (Object)this);
                            queryId = -1L;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IOExceiption occurs while sending messages", ioe);
                            }
                            Object var13_20 = null;
                            if (resolvable && unresolvableHosts.contains(host2 = destination.getProtocolHost())) {
                                unresolvableHosts.remove(host2);
                            }
                            if (messenger != null) {
                                messenger.close();
                            }
                            break block30;
                        }
                        catch (Throwable ex) {
                            String host2;
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.sendQuery", (String)"198", (Object)this);
                            DiscoveryListener[] listeners = this.copyListener();
                            DiscoveryEvent de = new DiscoveryEvent(this, DiscoveryEvent.ROLLBACK, queryId);
                            for (int i = 0; i < listeners.length; ++i) {
                                listeners[i].event(de);
                            }
                            queryId = -1L;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "unable to send out the discovery query message", ex);
                            }
                            Object var13_21 = null;
                            if (resolvable && unresolvableHosts.contains(host2 = destination.getProtocolHost())) {
                                unresolvableHosts.remove(host2);
                            }
                            if (messenger != null) {
                                messenger.close();
                            }
                        }
                    }
                    Object var13_18 = null;
                    if (resolvable && unresolvableHosts.contains(host2 = destination.getProtocolHost())) {
                        unresolvableHosts.remove(host2);
                    }
                    if (messenger != null) {
                        messenger.close();
                    }
                }
                catch (Throwable throwable) {
                    String host2;
                    Object var13_22 = null;
                    if (resolvable && unresolvableHosts.contains(host2 = destination.getProtocolHost())) {
                        unresolvableHosts.remove(host2);
                    }
                    if (messenger == null) throw throwable;
                    messenger.close();
                    throw throwable;
                }
            }
        }
        if (!tc.isEntryEnabled()) return queryId;
        Tr.exit(tc, "sendQuery: " + queryId);
        return queryId;
    }

    public DiscoveryResponseMsg processQuery(XMLDocument queryDocument) throws DiscardQueryException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processQuery");
        }
        DiscoveryQueryMsg query = null;
        DiscoveryResponseMsg response = null;
        try {
            query = new DiscoveryQueryMsg(queryDocument);
            PeerAdv padv = query.getPeerAdv();
            String localVersion = Utils.getProductVersion();
            String remoteVersion = padv.getVersion();
            String remoteNode = padv.getNode();
            String remoteRole = padv.getRole();
            int dif = Utils.compareVersions(localVersion, remoteVersion);
            if (this.adminType.equals("DeploymentManager") && dif < 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{localVersion, remoteNode + ", " + remoteVersion});
                throw new DiscardQueryException("The version of the Deployment Manager (" + localVersion + ") is earlier than that of the nodeagent (" + remoteVersion + ")");
            }
            if (!remoteRole.equals("ManagedProcess") && this.adminType.equals("NodeAgent") && dif > 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{remoteVersion, this.nodeName + ", " + localVersion});
                throw new DiscardQueryException("The version of the Deployment Manager (" + remoteVersion + ") is earlier than that of the nodeagent (" + localVersion + ")");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.processQuery", (String)"278", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQuery - can not rebuild the query", ex);
            }
            throw new DiscardQueryException("can not read the query document");
        }
        ServerInfo targetInfo = query.getServerInfo();
        if (targetInfo.match(this.serverInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "role matched", new Object[]{targetInfo, this.serverInfo});
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQuery - role not matched", new Object[]{targetInfo, this.serverInfo});
            }
            throw new DiscardQueryException("role not matched");
        }
        int type = query.getDiscoveryType();
        long queryId = query.getQueryId();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "query Id = " + queryId);
        }
        if (queryId <= 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQuery: discardQuery");
            }
            throw new DiscardQueryException("No queryId included with the query message");
        }
        PeerAdv peerAdv = query.getPeerAdv();
        DiscoveryListener[] listeners = this.copyListener();
        DiscoveryEvent de = new DiscoveryEvent(this, peerAdv, queryId, true);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].event(de);
        }
        ServerInfo inf = new ServerInfo(peerAdv.getCell(), peerAdv.getNode(), peerAdv.getRole());
        response = new DiscoveryResponseMsg(0, queryId, inf, this.advertisement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processQuery");
        }
        return response;
    }

    public void pushResponse(XMLDocument responseDocument) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushResponse");
        }
        DiscoveryResponseMsg response = null;
        try {
            response = new DiscoveryResponseMsg(responseDocument);
            PeerAdv padv = response.getResponse();
            String localVersion = Utils.getProductVersion();
            String remoteVersion = padv.getVersion();
            String remoteNode = padv.getNode();
            String remoteRole = padv.getRole();
            int dif = Utils.compareVersions(localVersion, remoteVersion);
            if (this.adminType.equals("DeploymentManager") && dif < 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{localVersion, remoteNode + ", " + remoteVersion});
                throw new DiscardQueryException("The version of the Deployment Manager (" + localVersion + ") is earlier than that of the nodeagent (" + remoteVersion + ")");
            }
            if (!remoteRole.equals("ManagedProcess") && this.adminType.equals("NodeAgent") && dif > 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{remoteVersion, this.nodeName + ", " + localVersion});
                throw new DiscardQueryException("The version of the Deployment Manager (" + remoteVersion + ") is earlier than that of the nodeagent (" + localVersion + ")");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.pushResponse", (String)"361", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "pushResponse - failed");
            }
            return;
        }
        ServerInfo targetInfo = response.getServerInfo();
        if (targetInfo.match(this.serverInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "role matched", new Object[]{targetInfo, this.serverInfo});
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "role not matched", new Object[]{targetInfo, this.serverInfo});
            }
            return;
        }
        int type = response.getDiscoveryType();
        long queryId = response.getQueryId();
        PeerAdv peerAdv = response.getResponse();
        DiscoveryListener[] listeners = this.copyListener();
        DiscoveryEvent de = new DiscoveryEvent(this, peerAdv, queryId, false);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].event(de);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respond(EndpointAddress destination, DiscoveryResponseMsg response) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "respond");
        }
        Message message = null;
        try {
            message = new Message(response.getXMLDocument().getInputStream(), this.serviceAddress, destination);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "message[src, dest]", new Object[]{this.serviceAddress, destination});
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.respond", (String)"412", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to send out the discovery response message", ex);
            }
            Tr.warning(tc, "ADMD0008W", ex.getMessage());
        }
        EndpointMessenger messenger = null;
        try {
            try {
                messenger = this.endpoint.getMessenger(destination);
                messenger.sendMessage(message);
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.discovery.DiscoveryService.respond", (String)"427", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to send out the discovery response message", ioe);
                }
                Object var7_7 = null;
                if (messenger != null) {
                    messenger.close();
                }
            }
            Object var7_6 = null;
            if (messenger != null) {
                messenger.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (messenger != null) {
                messenger.close();
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "respond");
        }
    }

    public void demux(Message message) {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "demux");
            }
            XMLDocument document = null;
            EndpointAddress from = message.getSourceAddress();
            try {
                InputStream stream = message.getDataInputStream();
                document = new XMLDocument(stream);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.DiscoveryService.demux", (String)"493", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to create an XML document from the message", ex);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "demux");
                }
                return;
            }
            if (document == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The discovery document is null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "demux");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the incoming discovery message is: ", document);
            }
            Element root = document.getDocumentElement();
            String mesgTag = root.getTagName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the opening tag is " + mesgTag);
            }
            if (mesgTag.equalsIgnoreCase("jxta:DiscoveryQuery")) {
                try {
                    DiscoveryResponseMsg response = this.processQuery(document);
                    if (response != null) {
                        this.respond(from, response);
                    }
                    break block21;
                }
                catch (DiscardQueryException ex1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "the query discarded");
                    }
                    break block21;
                }
                catch (IOException ex2) {
                    FFDCFilter.processException((Throwable)ex2, (String)"com.ibm.ws.management.discovery.DiscoveryService.demux", (String)"527", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IO error occurs while processing the query", ex2);
                    }
                    break block21;
                }
            }
            if (mesgTag.equalsIgnoreCase("jxta:DiscoveryResponse")) {
                this.pushResponse(document);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unsupported discovery message", mesgTag);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "demux");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveryListener[] copyListener() {
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            return this.discoveryListeners.toArray(new DiscoveryListener[0]);
        }
    }
}

