/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.management.discovery.DiscoveryEvent;
import com.ibm.ws.management.discovery.DiscoveryListener;
import com.ibm.ws.management.discovery.DiscoveryService;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.PeerAdv;
import com.ibm.ws.management.discovery.protocol.ServiceAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class DiscoveryAdapter
implements DiscoveryListener {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(DiscoveryAdapter.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private DiscoveryService discoveryService;
    protected PeerAdv peerAdv;
    protected ServerInfo serverInfo;
    private Endpoint endpoint;
    private HashSet queryIds = new HashSet();
    private boolean initialized = false;

    public DiscoveryAdapter(ServerInfo info, String discoveryPort, int protocol) {
        this(info, discoveryPort, protocol, null);
    }

    public DiscoveryAdapter(ServerInfo info, String discoveryPort, int protocol, String multicastAddr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DiscoveryAdapter");
        }
        this.serverInfo = info;
        String localhost = null;
        String epaddr = null;
        List endpoints = this.serverInfo.getEndPoints();
        if (endpoints.size() > 0) {
            Properties p = (Properties)endpoints.get(0);
            localhost = p.getProperty("host");
            if (localhost.indexOf(58) > -1 && localhost.indexOf(91) < 0) {
                localhost = "[" + localhost + "]";
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not get the local hostname - no endpoints in server info");
            }
            localhost = "localhost";
        }
        if (multicastAddr != null && multicastAddr.length() > 0) {
            if (multicastAddr.indexOf(58) > -1 && multicastAddr.indexOf(91) < 0) {
                multicastAddr = "[" + multicastAddr + "]";
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Warning: multicast address is not provided");
        }
        TransportAdvertisement tadv = null;
        String prot = null;
        if (protocol == 1) {
            prot = "tcp";
            tadv = new TcpAdv(discoveryPort, prot, localhost, localhost);
            epaddr = prot + "://" + localhost + ":" + discoveryPort;
        } else if (protocol == 0) {
            prot = "udp";
            tadv = new UdpAdv(discoveryPort, prot, localhost, localhost);
            epaddr = prot + "://" + localhost + ":" + discoveryPort;
        } else if (protocol == 2) {
            prot = "mudp";
            tadv = new MUdpAdv(prot, multicastAddr, discoveryPort);
            epaddr = prot + "://" + multicastAddr + ":" + discoveryPort;
        }
        EndpointAdv epadv = new EndpointAdv(prot, epaddr, tadv);
        ServiceAdv sadv = new ServiceAdv("AdminService", this.serverInfo.getServices());
        this.peerAdv = new PeerAdv(this.serverInfo, sadv, epadv);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DiscoveryAdapter");
        }
    }

    public boolean initialize(ThreadPoolMgr tpmgr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (this.initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - already done");
            }
            return false;
        }
        boolean init_succeeded = this.initializeEndpoint(tpmgr);
        this.initializeDiscoveryService();
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return init_succeeded;
    }

    private boolean initializeEndpoint(ThreadPoolMgr tpmgr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeEndpoint");
        }
        EndpointAdv epadv = this.peerAdv.getEndpointAdv();
        this.endpoint = new Endpoint(epadv);
        boolean init_succeeded = this.endpoint.initialize(tpmgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeEndpoint");
        }
        return init_succeeded;
    }

    private void initializeDiscoveryService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeDiscoveryService");
        }
        this.discoveryService = new DiscoveryService(this.serverInfo, this.endpoint, this.peerAdv);
        this.discoveryService.addDiscoveryListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeDiscoveryService");
        }
    }

    protected abstract void updateRoutingTable(ServerInfo var1);

    protected boolean qualifyQueryId(long qid, String role) {
        if (role.equals("ManagedProcess")) {
            return this.containQueryId(qid);
        }
        return this.removeQueryId(qid);
    }

    protected boolean unqualifyQueryId(long qid, String role) {
        if (role.equals("ManagedProcess")) {
            return false;
        }
        return this.removeQueryId(qid);
    }

    public void event(DiscoveryEvent event2) {
        int state;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "event");
        }
        if ((state = event2.getState()) == DiscoveryEvent.SENDING) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sending event...");
            }
            this.saveQueryId(event2.getQueryId());
        } else if (state == DiscoveryEvent.ROLLBACK) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rollback discovery...");
            }
            this.removeQueryId(event2.getQueryId());
        } else if (state == DiscoveryEvent.RECEIVED) {
            boolean isQuery = event2.isQuery();
            long qid = event2.getQueryId();
            PeerAdv padv = event2.getRemotePeerAdv();
            String role = padv.getRole();
            PeerAdv remotePeerAdv = event2.getRemotePeerAdv();
            ServerInfo serverInfo = new ServerInfo(remotePeerAdv.getPid(), remotePeerAdv.getCell(), remotePeerAdv.getNode(), remotePeerAdv.getName(), remotePeerAdv.getRole(), remotePeerAdv.getVersion(), remotePeerAdv.getServiceAdv().getAccessMethods());
            if (isQuery) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "it's a query event");
                }
                this.updateRoutingTable(serverInfo);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "it's a response event");
                }
                if (this.qualifyQueryId(qid, role)) {
                    this.updateRoutingTable(serverInfo);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event - unrecognized response");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveQueryId(long qid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveQueryId: " + qid);
        }
        HashSet hashSet = this.queryIds;
        synchronized (hashSet) {
            this.queryIds.add(new Long(qid));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveQueryId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeQueryId(long qid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQueryId: " + qid);
        }
        boolean removed = false;
        HashSet hashSet = this.queryIds;
        synchronized (hashSet) {
            removed = this.queryIds.remove(new Long(qid));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQueryId: " + removed);
        }
        return removed;
    }

    protected boolean containQueryId(long qid) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "containQueryId: " + qid);
            Iterator it = this.queryIds.iterator();
            while (it.hasNext()) {
                Tr.debug(tc, "id:  " + (Long)it.next());
            }
        }
        return this.queryIds.contains(new Long(qid));
    }

    public void discovery(String host, String port, int protocol, ServerInfo target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discovery", new Object[]{host, port, target});
        }
        EndpointAddress destination = new EndpointAddress(protocol, host, port, "DiscoveryService");
        DiscoveryTask task = new DiscoveryTask(destination, target, 0L);
        AlarmManager.createNonDeferrable((long)50L, (AlarmListener)new DiscoveryAlarm(task), (Object)this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discovery");
        }
    }

    protected Properties convertConnectorNameToProperties(String str) {
        Properties props = new Properties();
        StringTokenizer st = new StringTokenizer(str, ";=");
        while (st.hasMoreTokens()) {
            props.setProperty(st.nextToken(), st.nextToken());
        }
        return props;
    }

    class DiscoveryTask {
        EndpointAddress destination;
        ServerInfo target;
        long sequence;
        long queryId;
        boolean isSet;

        DiscoveryTask(EndpointAddress destination, ServerInfo target, long sequence) {
            this.destination = destination;
            this.target = target;
            this.sequence = sequence;
            this.isSet = false;
        }

        EndpointAddress getDestination() {
            return this.destination;
        }

        ServerInfo getTarget() {
            return this.target;
        }

        long getSequence() {
            return this.sequence;
        }

        void setSequence(long seq) {
            this.sequence = seq;
        }

        long getQueryId() {
            return this.queryId;
        }

        void setQueryId(long queryId) {
            this.queryId = queryId;
            this.isSet = true;
        }

        boolean isSet() {
            return this.isSet;
        }
    }

    class DiscoveryAlarm
    implements AlarmListener {
        DiscoveryTask task;

        DiscoveryAlarm(DiscoveryTask task) {
            this.task = task;
        }

        public void alarm(Object alarmContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DiscoveryAlarm.alarm");
            }
            DiscoveryAdapter da = (DiscoveryAdapter)alarmContext;
            if (this.task.isSet()) {
                long qid = this.task.getQueryId();
                if (da.unqualifyQueryId(qid, this.task.getTarget().getRole())) {
                    this.runIt();
                }
            } else {
                this.runIt();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DiscoveryAlarm.alarm");
            }
        }

        void runIt() {
            long queryId;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runIt");
            }
            if ((queryId = DiscoveryAdapter.this.discoveryService.sendQuery(this.task.getDestination(), this.task.getTarget())) != -1L) {
                this.task.setQueryId(queryId);
                DiscoveryAdapter.this.saveQueryId(queryId);
            }
            long seq = 2L * this.task.getSequence() + 1L;
            this.task.setSequence(seq);
            AlarmManager.createNonDeferrable((long)(seq * 60L * 1000L), (AlarmListener)new DiscoveryAlarm(this.task), (Object)DiscoveryAdapter.this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runIt");
            }
        }
    }
}

