/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.descriptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.DescriptorParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.MBeanExtensions;
import com.ibm.ws.management.descriptor.MBeanDescriptorLoader;
import com.ibm.ws.management.descriptor.MBeanDescriptorLoader2;
import com.ibm.ws.management.descriptor.WsDescriptorSupport;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public class MBeanDescriptorManager {
    private static MBeanDescriptorManager instance = null;
    private static String resourceBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS(resourceBundleName);
    private static TraceComponent tc = Tr.register(MBeanDescriptorManager.class, "MBeanFactory", resourceBundleName);
    private DescriptorClassLoader descriptorClassLoader;
    private List mbeanDescriptorBundles = new ArrayList();
    private HashMap infoCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MBeanDescriptorManager getInstance() {
        if (instance != null) return instance;
        Class<MBeanDescriptorManager> clazz = MBeanDescriptorManager.class;
        synchronized (MBeanDescriptorManager.class) {
            if (instance == null) {
                instance = new MBeanDescriptorManager();
            }
            try {
                instance.loadMasterDescriptorFile("com/ibm/ws/management/descriptor/xml/mbeans.xml");
            }
            catch (DescriptorParseException ex) {
                ex.printStackTrace(System.out);
            }
            return instance;
        }
    }

    private MBeanDescriptorManager() {
        this.descriptorClassLoader = new DescriptorClassLoader();
        this.obtainMBeanProviders();
    }

    private void obtainMBeanProviders() {
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extension registry is null");
            }
            return;
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".mbean-provider";
        IExtensionPoint point = registry.getExtensionPoint(epid);
        if (point == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extension point, " + epid + ", not found");
            }
            return;
        }
        IExtension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            this.mbeanDescriptorBundles.add(Platform.getBundle((String)extensions[i].getNamespace()));
        }
    }

    public synchronized ModelMBeanInfo getDescriptor(String type, String descriptor) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptor", type);
        }
        ModelMBeanInfo info = null;
        Object obj = this.infoCache.get(type);
        if (obj == null) {
            info = this.loadDescriptorFile(type, descriptor);
            this.infoCache.put(type, info);
        } else {
            info = (ModelMBeanInfo)this.deepClone((ModelMBeanInfo)obj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptor", info);
        }
        return info;
    }

    public synchronized void removeDescriptor(String type) {
        if (type != null && type.length() > 0) {
            Object obj = this.infoCache.remove(type);
            if (tc.isDebugEnabled()) {
                if (obj != null) {
                    Tr.debug(tc, "Descriptor of mbean type " + type + " removed from the cache");
                } else {
                    Tr.debug(tc, "Descriptor of mbean type " + type + " not in the cache");
                }
            }
        }
    }

    public synchronized ModelMBeanInfo getDescriptor(String type, String descriptor, byte[] descriptorBytes) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptor", new Object[]{type, descriptor, descriptorBytes});
        }
        ModelMBeanInfo info = null;
        Object obj = this.infoCache.get(type);
        if (obj == null) {
            MBeanDescriptorLoader loader = new MBeanDescriptorLoader();
            ByteArrayInputStream inStream = new ByteArrayInputStream(descriptorBytes);
            info = loader.loadDescriptor(inStream, descriptor);
            this.infoCache.put(type, info);
        } else {
            info = (ModelMBeanInfo)obj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptor", info);
        }
        return new ModelMBeanInfoSupport(info);
    }

    private InputStream getResourceAsStream(final String descriptorFileName) {
        Iterator it = this.mbeanDescriptorBundles.iterator();
        InputStream input = null;
        while (it.hasNext() && input == null) {
            final Bundle bundle = (Bundle)it.next();
            URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return bundle.getResource(descriptorFileName);
                }
            });
            if (url == null) continue;
            try {
                input = url.openStream();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorManager.getResourceAsStream", (String)"221", (Object)this);
            }
        }
        if (input == null) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(descriptorFileName);
        }
        return input;
    }

    public InputSource loadMBeanDescriptorFile(String type, String descriptor) {
        InputStream inStream;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMBeanDescriptorFile", new Object[]{type, descriptor});
        }
        String descriptorFileName = descriptor;
        if (descriptor == null) {
            descriptorFileName = "com/ibm/ws/management/descriptor/xml/" + type + ".xml";
        }
        if ((inStream = this.getResourceAsStream(descriptorFileName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not find the system descriptor file", descriptorFileName);
            }
            if (descriptor == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "consult the MBeanExtension for descriptor file");
                }
                MBeanExtensions mbeanExtensions = AdminInitializer.getInstance().getMBeanExtensions();
                descriptorFileName = mbeanExtensions.getDescriptorUri(type);
                List classpath = mbeanExtensions.getClasspath(type);
                if (descriptorFileName != null) {
                    String[] paths = classpath.toArray(new String[0]);
                    for (int i = 0; i < paths.length; ++i) {
                        this.descriptorClassLoader.addPath(paths[i]);
                    }
                    inStream = this.descriptorClassLoader.getResourceAsStream(descriptorFileName);
                }
            }
        }
        InputSource result = new InputSource(inStream);
        result.setSystemId(descriptorFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMBeanDescriptorFile", result);
        }
        return result;
    }

    public InputSource loadSecurityDescriptorFile(String type, String descriptor) {
        InputStream inStream;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityDescriptorFile", new Object[]{type, descriptor});
        }
        String descriptorFileName = descriptor;
        if (descriptor == null) {
            descriptorFileName = "com/ibm/ws/management/descriptor/xml/" + type + "Security.xml";
        }
        if ((inStream = this.getResourceAsStream(descriptorFileName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not find the system descriptor file", descriptorFileName);
            }
            if (descriptor == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "consult the MBeanExtension for descriptor file");
                }
                MBeanExtensions mbeanExtensions = AdminInitializer.getInstance().getMBeanExtensions();
                descriptorFileName = mbeanExtensions.getDescriptorUri(type);
                List classpath = mbeanExtensions.getClasspath(type);
                if (descriptorFileName != null) {
                    descriptorFileName = this.toSecurityMBeanDescriptor(descriptorFileName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying MBeanExtension security descriptor file:" + descriptorFileName);
                    }
                    String[] paths = classpath.toArray(new String[0]);
                    for (int i = 0; i < paths.length; ++i) {
                        this.descriptorClassLoader.addPath(paths[i]);
                    }
                    inStream = this.descriptorClassLoader.getResourceAsStream(descriptorFileName);
                }
            }
        }
        InputSource result = new InputSource(inStream);
        result.setSystemId(descriptorFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityDescriptorFile", result);
        }
        return result;
    }

    private String toSecurityMBeanDescriptor(String descriptorUri) {
        int index = descriptorUri.lastIndexOf(".xml");
        descriptorUri = index == -1 ? descriptorUri + "Security" : descriptorUri.substring(0, index) + "Security.xml";
        return descriptorUri;
    }

    public ModelMBeanInfo loadDescriptorFile(String type, String descriptor) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptorFile", descriptor);
        }
        InputSource inSource = this.loadMBeanDescriptorFile(type, descriptor);
        InputStream inStream = inSource.getByteStream();
        String descriptorFileName = inSource.getSystemId();
        if (inStream == null) {
            throw new DescriptorParseException(new FileNotFoundException(descriptorFileName), descriptorFileName);
        }
        MBeanDescriptorLoader loader = new MBeanDescriptorLoader();
        ModelMBeanInfo info = loader.loadDescriptor(inStream, descriptorFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDescriptorFile", descriptorFileName);
        }
        return info;
    }

    public synchronized void loadMasterDescriptorFile(String path) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMasterDescriptorFile", path);
        }
        MBeanDescriptorLoader2 loader = new MBeanDescriptorLoader2();
        InputStream is = this.getResourceAsStream(path);
        loader.load(is, path);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMasterDescriptorFile", path);
        }
    }

    void populateCache(String type, ModelMBeanInfo info) {
        this.infoCache.put(type, info);
    }

    protected Object deepClone(ModelMBeanInfo model) {
        int i;
        ModelMBeanAttributeInfo[] modelMBeanAttributes = null;
        ModelMBeanConstructorInfo[] modelMBeanConstructors = null;
        ModelMBeanNotificationInfo[] modelMBeanNotifications = null;
        ModelMBeanOperationInfo[] modelMBeanOperations = null;
        Descriptor modelMBeanDescriptor = null;
        if (model.getAttributes() != null) {
            MBeanAttributeInfo[] attributes = model.getAttributes();
            modelMBeanAttributes = new ModelMBeanAttributeInfo[attributes.length];
            for (i = 0; i < attributes.length; ++i) {
                MBeanAttributeInfo attribute = attributes[i];
                modelMBeanAttributes[i] = attribute instanceof ModelMBeanAttributeInfo ? new ModelMBeanAttributeInfo((ModelMBeanAttributeInfo)attribute) : new ModelMBeanAttributeInfo(attribute.getName(), attribute.getType(), attribute.getDescription(), attribute.isReadable(), attribute.isWritable(), attribute.isIs());
            }
        }
        if (model.getConstructors() != null) {
            MBeanConstructorInfo[] constructors = model.getConstructors();
            modelMBeanConstructors = new ModelMBeanConstructorInfo[constructors.length];
            for (i = 0; i < constructors.length; ++i) {
                MBeanConstructorInfo constructor = constructors[i];
                modelMBeanConstructors[i] = new ModelMBeanConstructorInfo(constructor.getName(), constructor.getDescription(), constructor.getSignature());
            }
        }
        if (model.getOperations() != null) {
            MBeanOperationInfo[] operations = model.getOperations();
            modelMBeanOperations = new ModelMBeanOperationInfo[operations.length];
            for (i = 0; i < operations.length; ++i) {
                MBeanOperationInfo operation = operations[i];
                modelMBeanOperations[i] = operation instanceof ModelMBeanOperationInfo ? new ModelMBeanOperationInfo((ModelMBeanOperationInfo)operation) : new ModelMBeanOperationInfo(operation.getName(), operation.getDescription(), operation.getSignature(), operation.getReturnType(), operation.getImpact());
            }
        }
        if (model.getNotifications() != null) {
            MBeanNotificationInfo[] notifications = model.getNotifications();
            modelMBeanNotifications = new ModelMBeanNotificationInfo[notifications.length];
            for (i = 0; i < notifications.length; ++i) {
                MBeanNotificationInfo notification = notifications[i];
                modelMBeanNotifications[i] = notification instanceof ModelMBeanNotificationInfo ? new ModelMBeanNotificationInfo((ModelMBeanNotificationInfo)notification) : new ModelMBeanNotificationInfo(notification.getNotifTypes(), notification.getName(), notification.getDescription());
            }
        }
        try {
            Descriptor mbeandescriptor = model.getMBeanDescriptor();
            if (mbeandescriptor == null) {
                this.createDefaultDescriptor(model);
            } else {
                modelMBeanDescriptor = (Descriptor)mbeandescriptor.clone();
            }
        }
        catch (MBeanException e) {
            this.createDefaultDescriptor(model);
        }
        return new ModelMBeanInfoSupport(model.getClassName(), model.getDescription(), modelMBeanAttributes, modelMBeanConstructors, modelMBeanOperations, modelMBeanNotifications, modelMBeanDescriptor);
    }

    private Descriptor createDefaultDescriptor(ModelMBeanInfo model) {
        WsDescriptorSupport mDesc = null;
        mDesc = new WsDescriptorSupport(new String[]{"name=" + model.getClassName(), "descriptorType=mbean", "displayName=" + model.getClassName(), "persistPolicy=never", "log=F", "visibility=1"});
        return mDesc;
    }

    class DescriptorClassLoader
    extends URLClassLoader {
        private ArrayList descriptorPath;

        DescriptorClassLoader() {
            super(new URL[0]);
            this.descriptorPath = new ArrayList();
        }

        public void addPath(String path) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addPath", path);
            }
            if (path != null) {
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    File f = new File(st.nextToken());
                    try {
                        f = f.getCanonicalFile();
                    }
                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorManager.DescriptorClassLoader.addPath", (String)"210", (Object)this);
                    }
                    try {
                        URL url = f.toURL();
                        if (this.descriptorPath.contains(url)) continue;
                        this.descriptorPath.add(url);
                        super.addURL(url);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.descriptor.MBeanDescriptorManager.DescriptorClassLoader.addPath", (String)"221", (Object)this);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPath", path);
            }
        }
    }
}

