/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deploymentmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.sync.SyncResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.deploymentmanager.DeploymentManager;
import com.ibm.ws.management.deploymentmanager.MultiSyncEvent;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MultiSyncManager {
    private static TraceComponent tc = Tr.register(MultiSyncManager.class, "Admin", "com.ibm.ws.management.resources.sync");
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.sync";
    private ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private int maxNodes = 5;
    private long SLEEP_TIMEOUT = 30000L;
    private boolean isRunning;
    private DeploymentManager dmgr;
    private HashMap autoSyncStates = new HashMap();
    private static ManagedObjectMetadataHelper metaObjectHelper = null;

    public MultiSyncManager(DeploymentManager dmgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiSyncManager", new Object[]{dmgr});
        }
        this.dmgr = dmgr;
        this.maxNodes = Integer.getInteger("com.ibm.websphere.multisync.maxnodes", 5);
        this.SLEEP_TIMEOUT = Long.getLong("com.ibm.websphere.multisync.timeout", 30L);
        this.SLEEP_TIMEOUT *= 1000L;
        if (metaObjectHelper == null) {
            try {
                ManagedObjectMetadataAccessor metaObjectAccess = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                metaObjectHelper = new ManagedObjectMetadataHelper(metaObjectAccess);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.<init>", (String)"103", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate Exception", e);
                }
                metaObjectHelper = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiSyncManager", new Object[]{new Integer(this.maxNodes), new Long(this.SLEEP_TIMEOUT)});
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void begin(boolean sync2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "begin");
        }
        if (!sync2) {
            Subject subject = SecurityHelper.getInvocationSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation subject", subject);
            }
            if (subject == null) {
                subject = SecurityHelper.getReceivedSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Recieved subject", subject);
                }
            }
            MultiSyncManagerThread manThread = new MultiSyncManagerThread(subject);
            manThread.setDaemon(true);
            manThread.start();
        } else {
            MultiSyncManagerThread manThread = new MultiSyncManagerThread(null);
            manThread.run();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "begin");
        }
    }

    public String getFormattedMessage(String key, Object[] args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage", new Object[]{key, args});
        }
        String result = TraceNLS.getStringFromBundle(BUNDLE_NAME, key, (String)null);
        if (args != null) {
            result = TraceNLS.getFormattedMessageFromLocalizedMessage(result, args, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFormattedMessage", new Object[]{result});
        }
        return result;
    }

    private Boolean getAutoSyncEnabled(ObjectName nodeSync) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoSyncEnabled", new Object[]{nodeSync});
        }
        Boolean ret = null;
        if (nodeSync != null) {
            try {
                ret = (Boolean)AdminServiceFactory.getAdminService().getAttribute(nodeSync, "autoSyncEnabled");
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.getAutoSyncEnabled", (String)"365", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAutoSyncEnabled", ret);
        }
        return ret;
    }

    private Boolean setAutoSyncEnabled(ObjectName nodeSync, Boolean set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoSyncEnabled", new Object[]{nodeSync, set});
        }
        Boolean ret = null;
        if (nodeSync != null) {
            try {
                Attribute attr = new Attribute("autoSyncEnabled", set);
                AdminServiceFactory.getAdminService().setAttribute(nodeSync, attr);
                ret = Boolean.TRUE;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.setAutoSyncEnabled", (String)"390", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error setting AutoSyncEnabled", e);
                }
                ret = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", new Object[]{set});
        }
        return ret;
    }

    private boolean isV5Node(String node) {
        boolean result;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isV5Node", node);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "metadatahelper", metaObjectHelper);
            }
            result = true;
            if (metaObjectHelper != null) {
                try {
                    String ver = metaObjectHelper.getNodeMajorVersion(node);
                    int version = Integer.parseInt(ver);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "version " + version);
                    }
                    result = version == 5;
                }
                catch (AdminException ae) {
                    FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.isV5Node", (String)"218", (Object)this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "error getting Node Version", ae);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isV5Node", new Boolean(result));
        }
        return result;
    }

    private class MultiSyncManagerThread
    extends Thread
    implements NotificationListener {
        Subject subject = null;
        Set togo = new HashSet();
        Set inProgress = new HashSet();
        Set complete = new HashSet();
        Set failed = new HashSet();
        Set doubtful = new HashSet();

        public MultiSyncManagerThread(Subject subj) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MultiSyncManagerThread", new Object[]{subj});
            }
            this.subject = subj;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MultiSyncManagerThread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block55: {
                MultiSyncEvent mse4;
                String comp;
                Object nodeSync;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                Subject pushed = null;
                if (this.subject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pushing subject");
                    }
                    pushed = SecurityHelper.pushInvocationSubject(this.subject);
                }
                try {
                    try {
                        String nodeName;
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                        }
                        MultiSyncManager.this.isRunning = true;
                        String result = MultiSyncManager.this.getFormattedMessage("ADMS0200I", null);
                        MultiSyncEvent mse = new MultiSyncEvent("ADMS0200I", result, 2);
                        MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse);
                        HashSet nodes = new HashSet();
                        AdminService admin = AdminServiceFactory.getAdminService();
                        ObjectName on = null;
                        try {
                            on = new ObjectName("WebSphere:*,type=NodeSync,process=nodeagent");
                        }
                        catch (MalformedObjectNameException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync", (String)"153", (Object)this);
                        }
                        Set agents = admin.queryNames(on, null);
                        Iterator autoSync = agents.iterator();
                        while (autoSync.hasNext()) {
                            String msg;
                            Boolean auto;
                            nodeSync = (ObjectName)autoSync.next();
                            nodeName = ObjectNameHelper.getNodeName((ObjectName)nodeSync);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking AutoSync for Node:", nodeName);
                            }
                            if ((auto = MultiSyncManager.this.getAutoSyncEnabled((ObjectName)nodeSync)) == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Cannot get autosync enabled removing this node", nodeSync);
                                }
                                msg = "Cannot get autosync enabled for this node: " + nodeName + "  Make sure user logged is granted atleast operator role. If the user has operator role, make sure the nodeagent has been restarted after mapping user to the role.";
                                MultiSyncEvent autofail = new MultiSyncEvent("ADMS0206I", msg, 0);
                                MultiSyncManager.this.dmgr.sendMultiSyncNotification(autofail);
                                autoSync.remove();
                                this.failed.add(nodeSync);
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "AutoSync for Node is currently:", auto);
                            }
                            MultiSyncManager.this.autoSyncStates.put(nodeSync, auto);
                            if (!auto.booleanValue()) continue;
                            MultiSyncManager.this.setAutoSyncEnabled((ObjectName)nodeSync, new Boolean(false));
                            msg = MultiSyncManager.this.getFormattedMessage("ADMS0202I", new Object[]{nodeName});
                            MultiSyncEvent mse2 = new MultiSyncEvent("ADMS0202I", msg, 2);
                            MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse2);
                        }
                        this.togo.addAll(agents);
                        while (this.togo.size() > 0) {
                            Object msg2;
                            Boolean valid;
                            block53: {
                                nodeSync = (ObjectName)this.togo.iterator().next();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "NodeSync", nodeSync);
                                }
                                nodeName = ObjectNameHelper.getNodeName((ObjectName)nodeSync);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Node", nodeName);
                                }
                                NotificationFilterSupport filter = new NotificationFilterSupport();
                                admin.addNotificationListenerExtended((ObjectName)nodeSync, this, null, nodeSync);
                                valid = null;
                                try {
                                    valid = (Boolean)admin.invoke((ObjectName)nodeSync, "requestSync", null, null);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Sync requested", valid);
                                    }
                                    if (!valid.booleanValue()) {
                                        this.inProgress.add(nodeSync);
                                        this.doubtful.add(nodeSync);
                                    }
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.run", (String)"178", (Object)this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception invoking requestSync", e);
                                    }
                                    valid = new Boolean(false);
                                    try {
                                        admin.removeNotificationListenerExtended((ObjectName)nodeSync, this);
                                    }
                                    catch (ListenerNotFoundException l) {
                                        FFDCFilter.processException((Throwable)l, (String)"com.ibm.ws.management.deploymentmanager.MultiSyncManager.run", (String)"293", (Object)this);
                                        if (!tc.isDebugEnabled()) break block53;
                                        Tr.debug(tc, "Listener not found exception", l);
                                    }
                                }
                            }
                            this.togo.remove(nodeSync);
                            if (valid.booleanValue()) {
                                this.inProgress.add(nodeSync);
                            } else {
                                this.failed.add(nodeSync);
                                msg2 = MultiSyncManager.this.getFormattedMessage("ADMS0204E", new Object[]{nodeName});
                                MultiSyncEvent mse3 = new MultiSyncEvent("ADMS0204E", (String)msg2, 0);
                                MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse3);
                            }
                            if (this.inProgress.size() < MultiSyncManager.this.maxNodes) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "In Progress", this.inProgress);
                            }
                            try {
                                msg2 = this;
                                synchronized (msg2) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Checking doubtful set", this.doubtful);
                                    }
                                    Map doubtMap = this.checkCurrentSyncs(this.doubtful);
                                    this.sendSyncStatus(doubtMap);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Waiting 1...");
                                    }
                                    this.wait(MultiSyncManager.this.SLEEP_TIMEOUT);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Check the status of the inProgress...");
                                    }
                                    Map map = this.checkCurrentSyncs(this.inProgress);
                                    this.sendSyncStatus(map);
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.run", (String)"206", (Object)this);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Exception waiting", e);
                            }
                        }
                    }
                    catch (Exception e) {
                        MultiSyncEvent autofail = new MultiSyncEvent("ADMS0206I", e.toString(), 0);
                        autofail.setComplete(true);
                        MultiSyncManager.this.dmgr.sendMultiSyncNotification(autofail);
                        Object var19_24 = null;
                        if (this.subject != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "poping subject");
                            }
                            SecurityHelper.popInvocationSubject(pushed);
                        }
                        break block55;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    if (this.subject != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "poping subject");
                        }
                        SecurityHelper.popInvocationSubject(pushed);
                    }
                    throw throwable;
                }
                while (this.inProgress.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In Progress", this.inProgress);
                    }
                    try {
                        nodeSync = this;
                        synchronized (nodeSync) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking doubtful set", this.doubtful);
                            }
                            Map doubtMap = this.checkCurrentSyncs(this.doubtful);
                            this.sendSyncStatus(doubtMap);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Waiting 2...");
                            }
                            this.wait(MultiSyncManager.this.SLEEP_TIMEOUT);
                            Map map = this.checkCurrentSyncs(this.inProgress);
                            this.sendSyncStatus(map);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.run", (String)"223", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Exception waiting -2", e);
                    }
                }
                if (this.failed.size() > 0) {
                    comp = MultiSyncManager.this.getFormattedMessage("ADMS0209W", null);
                    mse4 = new MultiSyncEvent("ADMS0209W", comp, 1);
                    mse4.setComplete(true);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse4);
                } else {
                    comp = MultiSyncManager.this.getFormattedMessage("ADMS0208I", null);
                    mse4 = new MultiSyncEvent("ADMS0208I", comp, 2);
                    mse4.setComplete(true);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse4);
                }
                MultiSyncManager.this.isRunning = false;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                Object var19_23 = null;
                if (this.subject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "poping subject");
                    }
                    SecurityHelper.popInvocationSubject(pushed);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
        }

        /*
         * Unable to fully structure code
         */
        private void sendSyncStatus(Map statList) {
            if (MultiSyncManager.access$000().isEntryEnabled()) {
                Tr.entry(MultiSyncManager.access$000(), "sendSyncStatus", statList);
            }
            entry = statList.entrySet();
            for (Map.Entry<K, V> ent : entry) {
                block14: {
                    nodeSync = (ObjectName)ent.getKey();
                    nodeName = ObjectNameHelper.getNodeName(nodeSync);
                    sync = ent.getValue();
                    stat = null;
                    auto = null;
                    if (MultiSyncManager.access$000().isDebugEnabled()) {
                        Tr.debug(MultiSyncManager.access$000(), "SyncResult", sync);
                    }
                    if (sync == null) break block14;
                    admin = AdminServiceFactory.getAdminService();
                    result = -1;
                    result = sync instanceof SyncResult != false ? ((SyncResult)sync).getResult() : ((com.ibm.ws.management.sync.SyncResult)sync).getResult();
                    stat = MultiSyncManager.this.getFormattedMessage("ADMS0207I", new Object[]{nodeName, ent.getValue()});
                    mse = new MultiSyncEvent("ADMS0207I", stat, 2);
                    MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(mse);
                    switch (result) {
                        case 0: {
                            if (!MultiSyncManager.access$000().isDebugEnabled()) break;
                            Tr.debug(MultiSyncManager.access$000(), "Still in Progress");
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (MultiSyncManager.access$000().isDebugEnabled()) {
                                Tr.debug(MultiSyncManager.access$000(), "Shouldn't I be declared done?");
                            }
                            this.inProgress.remove(nodeSync);
                            this.doubtful.remove(nodeSync);
                            this.complete.add(nodeSync);
                            comp = MultiSyncManager.this.getFormattedMessage("ADMS0205I", new Object[]{nodeName});
                            compmse = new MultiSyncEvent("ADMS0205I", comp, 2);
                            MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(compmse);
                            try {
                                admin.removeNotificationListenerExtended(nodeSync, this);
                            }
                            catch (ListenerNotFoundException l) {
                                if (!MultiSyncManager.access$000().isDebugEnabled()) ** GOTO lbl42
                                Tr.debug(MultiSyncManager.access$000(), "Listener not found exception", l);
                            }
lbl42:
                            // 3 sources

                            auto = (Boolean)MultiSyncManager.access$400(MultiSyncManager.this).get(nodeSync);
                            if (!auto.booleanValue()) break;
                            MultiSyncManager.access$500(MultiSyncManager.this, nodeSync, new Boolean(true));
                            break;
                        }
                        case 3: 
                        case 4: {
                            fail = MultiSyncManager.this.getFormattedMessage("ADMS0206I", new Object[]{nodeName});
                            fail2 = new MultiSyncEvent("ADMS0206I", fail, 0);
                            MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(fail2);
                            this.inProgress.remove(nodeSync);
                            this.doubtful.remove(nodeSync);
                            this.failed.add((ObjectName)ent.getKey());
                            try {
                                admin.removeNotificationListenerExtended(nodeSync, this);
                            }
                            catch (ListenerNotFoundException l) {
                                if (!MultiSyncManager.access$000().isDebugEnabled()) ** GOTO lbl63
                                Tr.debug(MultiSyncManager.access$000(), "Listener not found exception", l);
                            }
lbl63:
                            // 3 sources

                            auto = (Boolean)MultiSyncManager.access$400(MultiSyncManager.this).get(nodeSync);
                            if (!auto.booleanValue()) break;
                            MultiSyncManager.access$500(MultiSyncManager.this, nodeSync, new Boolean(true));
                        }
                    }
                    continue;
                }
                stat = MultiSyncManager.this.getFormattedMessage("ADMS0210E", new Object[]{nodeName});
                this.failed.add((ObjectName)ent.getKey());
                this.inProgress.remove(nodeSync);
                this.doubtful.remove(nodeSync);
                fail2 = new MultiSyncEvent("ADMS0210E", stat, 0);
                MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(fail2);
            }
            if (MultiSyncManager.access$000().isEntryEnabled()) {
                Tr.exit(MultiSyncManager.access$000(), "sendSyncStatus");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map checkCurrentSyncs(Set setToCheck) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkCurrentSyncs", null);
            }
            AdminService admin = AdminServiceFactory.getAdminService();
            HashMap<ObjectName, Object> map = new HashMap<ObjectName, Object>();
            Set set = this.inProgress;
            synchronized (set) {
                for (ObjectName nodeSync : setToCheck) {
                    String nodeName = ObjectNameHelper.getNodeName(nodeSync);
                    Object result = null;
                    String operation = "getSyncResult";
                    if (!MultiSyncManager.this.isV5Node(nodeName)) {
                        operation = "getResult";
                    }
                    try {
                        result = admin.invoke(nodeSync, operation, null, null);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.deploymentmanager.MultiSyncManager.checkCurrentSyncs", (String)"483", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "error getting syncResult", e);
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.checkCurrentSyncs", (String)"297", (Object)this);
                        result = null;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result", result);
                    }
                    map.put(nodeSync, result);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCurrentSyncs", new Object[]{map});
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object handback) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notification, handback});
            }
            Object notifToSend = null;
            String type = notification.getType();
            if (type.equals("websphere.nodesync.initiated")) {
                String node = ObjectNameHelper.getNodeName((ObjectName)handback);
                String start = MultiSyncManager.this.getFormattedMessage("ADMS0201I", new Object[]{node});
                MultiSyncEvent mse = new MultiSyncEvent("ADMS0201I", start, 2);
                MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse);
            } else if (type.equals("websphere.nodesync.complete")) {
                block14: {
                    this.inProgress.remove(handback);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In Progress", this.inProgress);
                    }
                    this.complete.add(handback);
                    AdminService admin = AdminServiceFactory.getAdminService();
                    try {
                        admin.removeNotificationListenerExtended((ObjectName)handback, this);
                    }
                    catch (ListenerNotFoundException l) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Listener not found exception", l);
                    }
                }
                String node = ObjectNameHelper.getNodeName((ObjectName)handback);
                Boolean success = (Boolean)notification.getUserData();
                MultiSyncEvent mse = null;
                String successMsg = null;
                if (success.booleanValue()) {
                    successMsg = MultiSyncManager.this.getFormattedMessage("ADMS0205I", new Object[]{node});
                    mse = new MultiSyncEvent("ADMS0205I", successMsg, 2);
                } else {
                    successMsg = MultiSyncManager.this.getFormattedMessage("ADMS0206I", new Object[]{node});
                    mse = new MultiSyncEvent("ADMS0206I", successMsg, 0);
                }
                MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse);
                Boolean auto = (Boolean)MultiSyncManager.this.autoSyncStates.get((ObjectName)handback);
                if (auto.booleanValue()) {
                    MultiSyncManager.this.setAutoSyncEnabled((ObjectName)handback, new Boolean(true));
                    String msg = MultiSyncManager.this.getFormattedMessage("ADMS0203I", new Object[]{node});
                    MultiSyncEvent mse2 = new MultiSyncEvent("ADMS0203I", msg, 2);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification(mse2);
                }
                MultiSyncManagerThread multiSyncManagerThread = this;
                synchronized (multiSyncManagerThread) {
                    this.notify();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }
    }
}

