/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deploymentmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.deploymentmanager.DeploymentManagerDiagnosticHelper;
import com.ibm.ws.management.deploymentmanager.MultiSyncEvent;
import com.ibm.ws.management.deploymentmanager.MultiSyncManager;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import java.io.File;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class DeploymentManager
extends RuntimeCollaborator
implements NotificationListener,
DiagnosticProvider {
    private static TraceComponent tc = Tr.register(DeploymentManager.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static final Integer DISCOVERY_LISTENER = new Integer(0);
    private static final Integer NODEAGENT_LISTENER = new Integer(1);
    private static final String DIAGNOSTIC_BUNDLE = "com.ibm.ws.management.resources.DiagnosticProviderText";
    private static long ntfySeqNum = 0L;
    private MBeanFactory mbeanFactory;
    private String cellName;
    private String repositoryRootURI;
    private DiagnosticProviderInfo dpInfo = null;
    public static final String sDPName = "DeploymentManagerDP";
    private Set stoppingNodeAgents = Collections.synchronizedSet(new HashSet());
    private Set currentNodeAgents = Collections.synchronizedSet(new HashSet());
    private MultiSyncManager multiSync;

    public DeploymentManager(String repositoryRootURI, String cellName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor", new Object[]{repositoryRootURI, cellName});
        }
        this.cellName = cellName;
        this.repositoryRootURI = repositoryRootURI;
        this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            Properties diagnosticProps = new Properties();
            diagnosticProps.setProperty("diagnosticProvider", "true");
            this.mbeanFactory.activateMBean("DeploymentManager", this, "DeploymentManager", null, diagnosticProps);
        }
        catch (AdminException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.DeploymentManager", (String)"77", (Object)this);
        }
        this.registerToDiscoveryMBean();
        this.listenForJ2EEStateStoppingNotifications();
        DiagnosticProviderHelper.registerMBeanWithDiagnosticService(sDPName, this.getObjectName());
        this.multiSync = new MultiSyncManager(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public void bindMBean(ModelMBeanInfo info, ModelMBean bean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMBean");
        }
        super.bindMBean(info, bean);
        if (info != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "info:", info);
            }
            Descriptor mBeanDescriptor = info.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanDescriptor", mBeanDescriptor);
            }
            String displayName = "DeploymentManager";
            mBeanDescriptor.setField("displayName", displayName);
            String type = (String)mBeanDescriptor.getFieldValue("type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type:" + type);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindMBean");
        }
    }

    public Set restartActiveNodes(Boolean syncFirst, Boolean restartServers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restartActiveNodes");
        }
        HashSet<String> nodes = new HashSet<String>();
        AdminService admin = AdminServiceFactory.getAdminService();
        ObjectName on2 = null;
        try {
            on2 = new ObjectName("WebSphere:*,type=NodeAgent");
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.restartActiveNodes", (String)"153", (Object)this);
        }
        Set agents = admin.queryNames(on2, null);
        for (ObjectName on2 : agents) {
            String nodeName = ObjectNameHelper.getNodeName(on2);
            Tr.audit(tc, "ADMN0026I", new Object[]{nodeName, syncFirst});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeagent object name", on2);
            }
            Object[] params = new Object[]{syncFirst, restartServers};
            String[] signatures = new String[]{syncFirst.getClass().getName(), restartServers.getClass().getName()};
            boolean succeeded = true;
            try {
                admin.invoke(on2, "restart", params, signatures);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.restartActiveNodes", (String)"143", (Object)this);
                if (e instanceof MBeanException) {
                    e = ((MBeanException)e).getTargetException();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to invoke ripple on node", new Object[]{nodeName, syncFirst});
                }
                Tr.warning(tc, "ADMN0030W", new Object[]{nodeName, e.getMessage()});
                succeeded = false;
            }
            if (!succeeded) continue;
            nodes.add(nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restartActiveNodes");
        }
        return nodes;
    }

    public void multiSync(Boolean synchronous) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "multiSync");
        }
        this.multiSync.begin(synchronous);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "multiSync");
        }
    }

    protected void sendMultiSyncNotification(MultiSyncEvent mse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMultiSyncNotification", new Object[]{mse});
        }
        Tr.audit(tc, mse.toString());
        Notification notifToSend = new Notification("websphere.multisync.event", this.getObjectName(), ntfySeqNum++);
        notifToSend.setUserData(mse);
        try {
            this.sendNotification(notifToSend);
        }
        catch (MBeanException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception sening Notification", ex);
            }
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.handleNotification", (String)"411", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMultiSyncNotification");
        }
    }

    public Set syncActiveNodes(Boolean synchronous) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "syncActiveNodes");
        }
        HashSet<String> nodes = new HashSet<String>();
        AdminService admin = AdminServiceFactory.getAdminService();
        ObjectName on2 = null;
        try {
            on2 = new ObjectName("WebSphere:*,type=NodeSync,process=nodeagent");
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.syncActiveNodes", (String)"153", (Object)this);
        }
        Set agents = admin.queryNames(on2, null);
        for (ObjectName on2 : agents) {
            String nodeName = ObjectNameHelper.getNodeName(on2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeagent object name", on2);
            }
            boolean succeeded = true;
            try {
                if (synchronous.booleanValue()) {
                    admin.invoke(on2, "sync", null, null);
                } else {
                    admin.invoke(on2, "requestSync", null, null);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.syncActiveNodes", (String)"143", (Object)this);
                if (e instanceof MBeanException) {
                    e = ((MBeanException)e).getTargetException();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to do file sync on node", new Object[]{nodeName, synchronous});
                }
                succeeded = false;
            }
            if (!succeeded) continue;
            nodes.add(nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "syncActiveNodes");
        }
        return nodes;
    }

    public void stopNodeAgent(String nodeName) throws Exception {
        AdminClient nodeClient;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNodeAgent");
        }
        if ((nodeClient = RoutingTable.getInstance().getAdminClient(nodeName)) == null) {
            throw new AdminException("no entry found in the routing table for node:" + nodeName);
        }
        ObjectName mbean = nodeClient.getServerMBean();
        nodeClient.invoke(mbean, "stop", null, null);
        RoutingTable.getInstance().removeChild(nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNodeAgent");
        }
    }

    public void stopNode(String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNode");
        }
        ObjectName mbean = null;
        AdminClient nodeClient = RoutingTable.getInstance().getAdminClient(nodeName);
        if (nodeClient == null) {
            throw new AdminException("no entry found in the routing table for node:" + nodeName);
        }
        try {
            mbean = new ObjectName("WebSphere:*,type=NodeAgent");
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.cellmanager.DeploymentManager.stopNode", (String)"305", (Object)this);
        }
        Set s = nodeClient.queryNames(mbean, null);
        ObjectName objectName = mbean = s.iterator().hasNext() ? (ObjectName)s.iterator().next() : null;
        if (mbean == null) {
            throw new AdminException("no NodeAgent mbean found at node: " + nodeName);
        }
        nodeClient.invoke(mbean, "stopNode", null, null);
        RoutingTable.getInstance().removeChild(nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNode");
        }
    }

    private void registerToDiscoveryMBean() {
        block2: {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String query = "WebSphere:type=Discovery,node=" + adminService.getNodeName() + ",process=" + adminService.getProcessName() + ",*";
                ObjectName queryName = new ObjectName(query);
                Set s = adminService.queryNames(queryName, null);
                Iterator it = s.iterator();
                queryName = (ObjectName)it.next();
                adminService.addNotificationListener(queryName, this, null, (Object)DISCOVERY_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.registerToDiscoveryMBean", (String)"358", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "can not register as a listener to DiscoveryMBean", ex);
            }
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName nodeagent = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("j2ee.state.stopping");
            adminService.addNotificationListenerExtended(nodeagent, this, filter, NODEAGENT_LISTENER);
        }
        catch (JMException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.listenForJ2EEStateStoppingNotifications", (String)"373", (Object)this);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        Notification notifToSend = null;
        String type = notification.getType();
        Thread collectorThread = null;
        if (handback.equals(DISCOVERY_LISTENER)) {
            Properties userData;
            if (type.equals("websphere.discovery.process.found")) {
                notifToSend = new Notification("websphere.process.running", this.getObjectName(), ntfySeqNum++);
                notifToSend.setUserData(notification.getUserData());
                this.checkRemoteClock((Properties)notification.getUserData());
                try {
                    userData = (Properties)notification.getUserData();
                    String nodeName = userData.getProperty("nodeName");
                    ManagedObjectMetadataHelper momHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                    if (momHelper.compareNodeVersion(nodeName, "5") == 0) {
                        Properties props = new Properties();
                        props.put("local.node", nodeName);
                        AdminClient nodeClient = RoutingTable.getInstance().getAdminClient(nodeName);
                        ObjectName oName = nodeClient.getServerMBean();
                        collectorThread = new Version5NodeMetadataCollector(props, nodeClient, oName);
                    }
                    this.currentNodeAgents.add(nodeName);
                }
                catch (Throwable t) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Could not create collector thread:", t);
                    }
                }
            } else if (type.equals("websphere.discovery.process.lost")) {
                userData = (Properties)notification.getUserData();
                NodeAgentInfo info = new NodeAgentInfo(userData.getProperty("nodeName"), userData.getProperty("processName"));
                String notifType = "websphere.process.failed";
                if (this.stoppingNodeAgents.remove(info)) {
                    notifType = "websphere.process.stopped";
                }
                notifToSend = new Notification(notifType, this.getObjectName(), ntfySeqNum++);
                notifToSend.setUserData(userData);
            }
        } else if (handback.equals(NODEAGENT_LISTENER) && type.equals("j2ee.state.stopping")) {
            notifToSend = new Notification("websphere.process.stopping", this.getObjectName(), ntfySeqNum++);
            ObjectName source = (ObjectName)notification.getSource();
            NodeAgentInfo info = new NodeAgentInfo(source.getKeyProperty("node"), source.getKeyProperty("name"));
            this.stoppingNodeAgents.add(info);
            Properties userData = new Properties();
            userData.setProperty("processName", info.getServerName());
            userData.setProperty("nodeName", info.getNodeName());
            notifToSend.setUserData(userData);
        }
        if (notifToSend != null) {
            try {
                this.sendNotification(notifToSend);
            }
            catch (MBeanException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.handleNotification", (String)"411", (Object)this);
            }
            if (collectorThread != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting v5 metadata collector thread.");
                }
                collectorThread.start();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void checkRemoteClock(Properties p) {
        try {
            String node = p.getProperty("nodeName");
            String process = p.getProperty("processName");
            ObjectName jvm = null;
            AdminService as = AdminServiceFactory.getAdminService();
            Set s = as.queryNames(new ObjectName("WebSphere:*,type=JVM,node=" + node + ",process=" + process), null);
            if (!s.isEmpty()) {
                jvm = (ObjectName)s.iterator().next();
                if (!jvm.getKeyProperty("version").equals("5.0") && !Utils.isClockInSync(null, jvm)) {
                    Tr.warning(tc, "ADMN0035W", node);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JVM MBean not found for nodeagent on " + node);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.deploymentmanager.DeploymentManager.checkRemoteClock", (String)"465", (Object)this);
        }
    }

    public String getDiagnosticProviderName() {
        return sDPName;
    }

    public String getDiagnosticProviderId() {
        return this.getObjectName().toString();
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegisteredDiagnostics");
        }
        if (this.dpInfo == null) {
            InputStream regIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/management/deploymentmanager/DeploymentManagerDiagnosticProvider.xml");
            this.dpInfo = DiagnosticProviderHelper.loadRegistry(regIS, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegisteredDiagnostics", this.dpInfo);
        }
        return this.dpInfo;
    }

    public DiagnosticEvent[] configDump(String aLocalId, boolean aRegisteredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{aLocalId, new Boolean(aRegisteredOnly)});
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        DiagnosticTypedValue dtv = new DiagnosticTypedValue(System.getProperty("os.name"), "os.name.key");
        result.put(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PLATFORM, dtv);
        result = new HashMap(2);
        try {
            DiagnosticTypedValue.addCollectionToHashMap(result, DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_CHILDREN, this.getNodes(), "DeploymentManager.nodes.key");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception getting nodes", e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.nodeagent.configDump", (String)"2019", (Object)this);
            result.put(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_CHILDREN, e.getMessage());
        }
        DiagnosticEvent de = DiagnosticEventFactory.createConfigDump(this.getObjectName().toString(), DeploymentManager.class.getName(), "configDump", result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configDump", de);
        }
        return new DiagnosticEvent[]{de};
    }

    public DiagnosticEvent[] stateDump(String aLocalId, boolean aRegisteredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{aLocalId, new Boolean(aRegisteredOnly)});
        }
        HashMap result = new HashMap(2);
        DiagnosticTypedValue.addCollectionToHashMap(result, DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_DISCOVERED_NODEAGENTS, this.currentNodeAgents, "DeploymentManager.discovered.nodes.key");
        DiagnosticEvent de = DiagnosticEventFactory.createStateDump(this.getObjectName().toString(), DeploymentManager.class.getName(), "stateDump", result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateDump", de);
        }
        return new DiagnosticEvent[]{de};
    }

    public DiagnosticEvent[] selfDiagnostic(String aLocalId, boolean aRegisteredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfDiagnostic", new Object[]{aLocalId, aRegisteredOnly});
        }
        if (this.dpInfo == null) {
            this.getRegisteredDiagnostics();
        }
        HashMap<String, DiagnosticTypedValue> total = null;
        if (aLocalId != null && (DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PING_NODEAGENTS.matches(aLocalId) || aLocalId.startsWith(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PING_NODEAGENTS))) {
            total = new HashMap<String, DiagnosticTypedValue>();
            HashSet<String> clone = null;
            int index = aLocalId.lastIndexOf(46);
            if (index > -1) {
                String nodeagent = aLocalId.substring(index + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeagent is " + nodeagent);
                }
                if ("*".equals(nodeagent)) {
                    try {
                        HashSet nodes = this.getNodeAgentNodes();
                        clone = new HashSet(nodes);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    clone = new HashSet<String>(1);
                    clone.add(nodeagent);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clone is " + clone.toArray().toString());
            }
            Iterator it = clone.iterator();
            String nodeagent = null;
            String state = "j2ee.state.stopped";
            while (it.hasNext()) {
                nodeagent = (String)it.next();
                state = "j2ee.state.stopped";
                try {
                    AdminClient ac = RoutingTable.getInstance().getAdminClient(nodeagent);
                    if (ac != null && ac.isAlive() != null) {
                        state = "j2ee.state.running";
                    }
                }
                catch (ConnectorException ce) {
                    Tr.debug(tc, "ConnectorException checking AdminClient.isAlive", ce);
                }
                DiagnosticTypedValue dtv = new DiagnosticTypedValue(state, "DeploymentManager.node.state");
                total.put(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PING_NODEAGENTS + "." + nodeagent, dtv);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalid local id", aLocalId);
        }
        DiagnosticEvent de = DiagnosticEventFactory.createDiagnosticEvent(this.getObjectName().toString(), "selfDiagnostic", 10, DeploymentManager.class.getName(), "selfDiagnostic", this.dpInfo.resourceBundleName, "DeploymentManager.ping.respondingProperly.descriptionKey", null, total);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfDiagnostic", de);
        }
        return new DiagnosticEvent[]{de};
    }

    public String[] localize(String[] aKeys, Locale aLocale) {
        ResourceBundle bundle = ResourceBundle.getBundle(DIAGNOSTIC_BUNDLE, aLocale);
        String[] localized = new String[aKeys.length];
        for (int i = 0; i < aKeys.length; ++i) {
            localized[i] = bundle.getString(aKeys[i]);
        }
        return localized;
    }

    private Vector getNodes() throws Exception {
        Vector<String> v = new Vector<String>();
        String ndir = this.repositoryRootURI + "/cells/" + this.cellName + "/nodes";
        File nodeContexts = new File(ndir);
        File[] nodes = nodeContexts.listFiles();
        String nodeName = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].isDirectory()) continue;
            nodeName = nodes[i].getName();
            v.add(nodeName);
        }
        return v;
    }

    private HashSet getNodeAgentNodes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeAgentNodes");
        }
        HashSet<String> v = new HashSet<String>();
        String ndir = this.repositoryRootURI + "/cells/" + this.cellName + "/nodes";
        File nodeContexts = new File(ndir);
        File[] nodes = nodeContexts.listFiles();
        String nodeName = null;
        block0: for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].isDirectory()) continue;
            nodeName = nodes[i].getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node name is " + nodeName);
            }
            String sdir = this.repositoryRootURI + "/cells/" + this.cellName + "/nodes/" + nodeName + "/servers/";
            File serverContexts = new File(sdir);
            File[] servers = serverContexts.listFiles();
            Object serverName = null;
            for (int j = 0; j < servers.length; ++j) {
                String sName = servers[j].getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server name is " + sName);
                }
                if (sName.equals("dmgr")) continue;
                v.add(nodeName);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAgentNodes ", v.toString());
        }
        return v;
    }

    class Version5NodeMetadataCollector
    extends Thread {
        private Properties _collectorMgrProps;
        private AdminClient _adminClient;
        private ObjectName _svrMBeanName;

        public Version5NodeMetadataCollector(Properties collectorMgrProps, AdminClient adminClient, ObjectName svrMBeanName) {
            this._collectorMgrProps = collectorMgrProps;
            this._adminClient = adminClient;
            this._svrMBeanName = svrMBeanName;
        }

        public void run() {
            block4: {
                try {
                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ManagedObjectMetadataCollectorManager collMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager((Properties)Version5NodeMetadataCollector.this._collectorMgrProps, (AdminClient)Version5NodeMetadataCollector.this._adminClient);
                            Properties newMetadata = collMgr.updateVersion5Metadata(Version5NodeMetadataCollector.this._svrMBeanName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "New v5 metadata props:", newMetadata);
                            }
                            return newMetadata;
                        }
                    };
                    try {
                        SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                }
                catch (Throwable t) {
                    if (!tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Could not collect v5 data:", t);
                }
            }
        }
    }

    private final class NodeAgentInfo {
        private String nodeName;
        private String serverName;

        NodeAgentInfo(String nodeName, String serverName) {
            this.nodeName = nodeName;
            this.serverName = serverName;
        }

        String getNodeName() {
            return this.nodeName;
        }

        String getServerName() {
            return this.serverName;
        }

        public boolean equals(Object o) {
            if (o != null && o.getClass().equals(this.getClass())) {
                NodeAgentInfo entry = (NodeAgentInfo)o;
                return this.nodeName.equals(entry.getNodeName()) && this.serverName.equals(entry.getServerName());
            }
            return false;
        }

        public int hashCode() {
            return this.nodeName.hashCode() + this.serverName.hashCode();
        }
    }
}

