/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.interop.JMXObjectInputStream;
import com.ibm.ws.management.connector.interop.JMXObjectOutputStream;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPUtils {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPUtils.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    public static final QName targetExceptionType = new QName("admin", "TargetExceptionType");
    public static final QName targetExceptionMessage = new QName("admin", "TargetExceptionMessage");
    public static final QName securityEnabled = new QName("admin", "SecurityEnabled");
    public static final String adminServiceURI = "urn:AdminService";

    public static Call extractSoapCall(InputStream is, int contentLength, String contentType, SOAPContext reqCtx, SOAPMappingRegistry smr) throws SOAPException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractCall");
        }
        Call msg = null;
        try {
            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
            Envelope callEnv = ServerUtils.readEnvelopeFromInputStream((DocumentBuilder)xdb, (InputStream)is, (int)contentLength, (String)contentType, null, (SOAPContext)reqCtx);
            reqCtx.setProperty("JMXRemoteVersion", (Object)JMXVersionValidation.getRemoteVersion(callEnv.getHeader()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Incoming Soap Envelope: " + callEnv);
            }
            Body body = callEnv.getBody();
            Vector bodyEntries = body.getBodyEntries();
            Element root = (Element)bodyEntries.elementAt(0);
            String declEnvEncStyle = callEnv.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String declBodyEncStyle = body.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String actualEncStyle = declBodyEncStyle != null ? declBodyEncStyle : declEnvEncStyle;
            String declMsgEncStyle = DOMUtils.getAttributeNS((Element)root, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"encodingStyle");
            String actualMsgEncStyle = declMsgEncStyle != null ? declMsgEncStyle : actualEncStyle;
            String methodName = root.getLocalName();
            String fullTargetObjectURI = root.getNamespaceURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI=" + fullTargetObjectURI + " method=" + methodName);
            }
            Element tempEl = DOMUtils.getFirstChildElement((Element)root);
            Vector<Parameter> params = new Vector<Parameter>();
            while (tempEl != null) {
                String declParamEncStyle = DOMUtils.getAttributeNS((Element)tempEl, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"encodingStyle");
                String actualParamEncStyle = declParamEncStyle != null ? declParamEncStyle : actualMsgEncStyle;
                Bean paramBean = smr.unmarshall(actualParamEncStyle, RPCConstants.Q_ELEM_PARAMETER, (Node)tempEl, reqCtx);
                Parameter param = (Parameter)paramBean.value;
                if (declParamEncStyle != null) {
                    param.setEncodingStyleURI(declParamEncStyle);
                }
                params.addElement(param);
                tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
            }
            msg = new Call(fullTargetObjectURI, methodName, params, null, declMsgEncStyle, reqCtx);
            msg.setSOAPMappingRegistry(smr);
            msg.setHeader(callEnv.getHeader());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unmarshalled RPC call is " + msg);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.extractSoapCall", (String)"157");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to extract the SOAP Call", ex);
            }
            SOAPException e = new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception", nls.getString("ADMC0011E", "The Soap RPC call can't be unmarshalled"), (Throwable)ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractCall");
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractCall");
        }
        return msg;
    }

    public static String convertObjectToString(Object src, String jmxRemoteVersion) throws IllegalArgumentException {
        byte[] bytes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertObjectToString");
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new JMXObjectOutputStream(baos);
            ((JMXObjectOutputStream)oos).jmxWriteObject(src, jmxRemoteVersion);
            bytes = baos.toByteArray();
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertObjectToString", (String)"187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to convert object to string", ioe);
            }
            throw new IllegalArgumentException(ioe.getMessage());
        }
        catch (JMXTransformException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertObjectToString", (String)"187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JMX transformation failed for this object", ioe);
            }
            throw new IllegalArgumentException(ioe.getMessage());
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertObjectToString", (String)"219");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertObjectToString");
        }
        return Base64.encode((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertStringToObject(String str, String remoteJMXVersion) throws IllegalArgumentException {
        Object obj;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertStringToObject");
            }
            ObjectInputStream ois = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)str));
                if (JMXVersionValidation.isRemoteVersionTmx4j(remoteJMXVersion)) {
                    Thread ct = Thread.currentThread();
                    ClassLoader wscl = ct.getContextClassLoader();
                    ct.setContextClassLoader(GenericSerializer.getJMXClassLoader());
                    try {
                        JMXObjectInputStream jmxois = new JMXObjectInputStream(bais);
                        obj = jmxois.jmxReadObject();
                        break block21;
                    }
                    finally {
                        ct.setContextClassLoader(wscl);
                    }
                }
                ois = new WsObjectInputStream((InputStream)bais);
                obj = ois.readObject();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", (String)"248");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to convert string to object", ioe);
                }
                throw new IllegalArgumentException(ioe.getMessage());
            }
            catch (ClassNotFoundException cne) {
                FFDCFilter.processException((Throwable)cne, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", (String)"257");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no class definition for to-be-serialized object", cne);
                }
                throw new IllegalArgumentException(cne.getMessage());
            }
            catch (JMXTransformException cne) {
                FFDCFilter.processException((Throwable)cne, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", (String)"257");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JMX transformation failed for this object", cne);
                }
                throw new IllegalArgumentException(cne.getMessage());
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", (String)"269");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertStringToObject");
        }
        return obj;
    }

    public static String encodeDataString(String iString) {
        if (iString == null) {
            return "";
        }
        boolean addLen = false;
        int strLen = iString.length();
        if (strLen < 1) {
            return iString;
        }
        StringBuffer retString = new StringBuffer(strLen * 2);
        block12: for (int i = 0; i < strLen; ++i) {
            switch (iString.charAt(i)) {
                case '<': {
                    retString.append("&lt;");
                    continue block12;
                }
                case '>': {
                    retString.append("&gt;");
                    continue block12;
                }
                case '&': {
                    retString.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    retString.append("&quot;");
                    continue block12;
                }
                case '+': {
                    retString.append("&#43;");
                    continue block12;
                }
                case '(': {
                    retString.append("&#40;");
                    continue block12;
                }
                case ')': {
                    retString.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    retString.append("&#39;");
                    continue block12;
                }
                case '%': {
                    retString.append("&#37;");
                    continue block12;
                }
                case ';': {
                    retString.append("&#59;");
                    continue block12;
                }
                default: {
                    retString.append(iString.charAt(i));
                }
            }
        }
        return retString.toString();
    }
}

