/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.util.ThreadPool;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SOAPServer
extends HttpServer
implements SSLConfigChangeListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPServer.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private HttpTransport transport = null;
    private String soapSslAlias = null;
    Map connectionInfo = new HashMap();
    private String port;
    private String host;
    private String profileKey;

    public SOAPServer(ThreadPool threadPool) {
        this(threadPool, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SoapServer");
        }
    }

    public SOAPServer(ThreadPool threadPool, String profileKey) {
        super(threadPool);
        this.profileKey = profileKey;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SoapServer " + profileKey);
        }
    }

    public void stateChanged(SSLConfigChangeEvent e) {
        block3: {
            try {
                if (ManagementScopeManager.getInstance().getServerType().equals("DEPLOYMENT_MANAGER")) {
                    Thread.sleep(10000L);
                }
                Properties sslSetting = JSSEHelper.getInstance().getProperties(this.soapSslAlias, this.connectionInfo, this);
                this.transport.reinitialize(sslSetting);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SoapServer.reinitialize", (String)"84", (Object)this);
                Tr.error(tc, ex.toString());
                if (!tc.isEntryEnabled()) break block3;
                Tr.exit(tc, "reinitialize - failed");
            }
        }
    }

    public void initialize(Properties props, boolean isSecure, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{alias, props});
        }
        if (this.transport == null) {
            this.transport = new HttpTransport();
        }
        String useMultiHomeHostName = props.getProperty("com.ibm.websphere.network.useMultiHomeHostName");
        Boolean useMultiHome = null;
        useMultiHome = useMultiHomeHostName == null ? AdminHelper.getInstance().useMultiHome() : Boolean.valueOf(useMultiHomeHostName);
        if (useMultiHome != null) {
            if (useMultiHome.booleanValue()) {
                this.transport.setHost(null);
            } else {
                this.host = props.getProperty("host");
                if (this.host == null) {
                    try {
                        this.host = AdminHelper.getInstance().getHostName();
                    }
                    catch (UnknownHostException uhe) {
                        Tr.error(tc, uhe.toString());
                        throw uhe;
                    }
                }
                this.transport.setHost(this.host);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "useMultiHomeHost == false: Host name = " + this.host);
                }
            }
        }
        this.port = props.getProperty("port");
        if (this.port == null || this.port.trim().length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - no port");
            }
            throw new IllegalArgumentException(nls.getString("ADMC0006E", "no port number specified for SOAP connector"));
        }
        this.transport.setPort(this.port);
        try {
            if (isSecure) {
                this.soapSslAlias = alias;
                this.connectionInfo.put("com.ibm.ssl.direction", "inbound");
                this.connectionInfo.put("com.ibm.ssl.endPointName", "SOAP_CONNECTOR_ADDRESS");
                Properties sslSetting = JSSEHelper.getInstance().getProperties(this.soapSslAlias, this.connectionInfo, this);
                this.transport.initialize((HttpServer)this, true, sslSetting);
            } else {
                this.transport.initialize((HttpServer)this, null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP connector transport initialized at port: " + this.port);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.soap.SoapServer.initialize", (String)"71", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - failed");
            }
            throw ex;
        }
        this.addTransport(this.transport);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getConfiguredPort() {
        return this.port;
    }

    protected HttpConnection createHttpConnection() {
        SOAPConnection conn = null;
        conn = this.profileKey == null ? new SOAPConnection() : new SOAPConnection(this.profileKey);
        return conn;
    }
}

