/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.soap.SOAPServer;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.ThreadPool;
import java.util.Properties;

public class JMXSoapAdapter
implements JMXConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(JMXSoapAdapter.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private SOAPServer soapServer = null;
    private Properties connectorProps = new Properties();
    private boolean started = false;
    private boolean isSecure = false;

    public JMXSoapAdapter(ThreadPool threadPool, String profileKey) {
        this.soapServer = profileKey == null ? new SOAPServer(threadPool) : new SOAPServer(threadPool, profileKey);
    }

    public JMXSoapAdapter(ThreadPool threadPool) {
        this(threadPool, null);
    }

    public void initialize(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", props);
        }
        this.connectorProps = props;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getType() {
        return "SOAP";
    }

    public void start() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (!this.started) {
            try {
                String soapSslAlias = this.connectorProps.getProperty("sslConfig");
                this.isSecure = ContextManagerFactory.getInstance().isCellSecurityEnabled();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using sslConfig: " + soapSslAlias);
                }
                this.soapServer.initialize(this.connectorProps, this.isSecure, soapSslAlias);
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.connector.soap.JMXSoapAdapter.start", (String)"79", (Object)this);
                Tr.warning(tc, "ADMC0015W", th.getMessage());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start");
                }
                throw new ConnectorNotAvailableException("", th);
            }
            this.started = true;
            Tr.audit(tc, "ADMC0013I", this.soapServer.getConfiguredPort());
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOAP Connector already started");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop - SOAP Connector already stopped");
            }
            return;
        }
        this.soapServer.shutdown();
        this.started = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public Properties getProperties() {
        return this.connectorProps;
    }

    public String getName() {
        return "type=SOAP;host=" + this.connectorProps.getProperty("host") + ";" + "port" + "=" + this.connectorProps.getProperty("port");
    }
}

