/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.rmi.RMIConnectorService;
import com.ibm.ws.orb.GlobalORBFactory;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RMIConnectorController
implements JMXConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RMIConnectorController.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private RMIConnectorService connector;
    private Properties connectorProps;
    private boolean started = false;
    private static final String JNDI_NAME = "RMIConnector";
    private String profileKey;
    private int port;
    private String jndiNameWithSuffix;
    private String createOrbListener;

    public void initialize(Properties props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", props);
        }
        this.connectorProps = props;
        this.profileKey = AdminContext.peek();
        this.port = Integer.parseInt(this.connectorProps.getProperty("port"));
        this.jndiNameWithSuffix = JNDI_NAME + String.valueOf(this.port);
        this.createOrbListener = this.connectorProps.getProperty("createOrbListener");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start - Connector already started");
            }
            return;
        }
        InitialContext ic = null;
        ORB orb = GlobalORBFactory.globalORB();
        try {
            Properties env = new Properties();
            env.put("java.naming.corba.orb", orb);
            env.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
            ic = new InitialContext(env);
        }
        catch (NamingException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.start", (String)"77", (Object)this);
            Tr.warning(tc, "ADMC0021W", ex);
            throw new ConnectorNotAvailableException("", ex);
        }
        try {
            this.connector = RMIConnectorService.getInstance();
            ic.rebind(this.jndiNameWithSuffix, (Object)this.connector);
            if (this.profileKey == null || this.profileKey.length() < 1) {
                ic.rebind(JNDI_NAME, (Object)this.connector);
            }
        }
        catch (RemoteException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.start", (String)"90", (Object)this);
            Tr.warning(tc, "ADMC0022W", ex);
            throw new ConnectorNotAvailableException("", ex);
        }
        catch (NamingException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.start", (String)"98", (Object)this);
            Tr.warning(tc, "ADMC0021W", ex);
            throw new ConnectorNotAvailableException("", ex);
        }
        if (this.profileKey != null && this.createOrbListener != null && this.createOrbListener.equals("true")) {
            orb.createListener(this.port);
        }
        this.connector.start();
        this.started = true;
        Tr.audit(tc, "ADMC0026I", this.connectorProps.getProperty("port"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start - RMI Connector started successfully");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop - RMI Connector already stopped");
            }
            return;
        }
        this.connector.stop();
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            ic.unbind(this.jndiNameWithSuffix);
            if (this.profileKey == null || this.profileKey.length() < 1) {
                ic.unbind(JNDI_NAME);
            }
            this.started = false;
        }
        catch (NamingException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.stop", (String)"132", (Object)this);
            Tr.warning(tc, "ADMC0023W", ex);
        }
        try {
            if (this.profileKey != null) {
                if ("true".equals(this.createOrbListener)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempting to stop RMI port " + this.port);
                    }
                    ORB orb = GlobalORBFactory.globalORB();
                    orb.destroyListener(this.port);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopped RMI port " + this.port);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.connector.rmi.RMIConnectorController.stop", (String)"180", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public String getType() {
        return "RMI";
    }

    public Properties getProperties() {
        return this.connectorProps;
    }

    public String getName() {
        return "type=RMI;host=" + this.connectorProps.getProperty("host") + ";" + "port" + "=" + this.connectorProps.getProperty("port");
    }
}

