/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.ipc.ClientAccessor;
import com.ibm.ws.management.connector.ipc.ConnectionPool;
import com.ibm.ws.management.connector.ipc.ConnectionPoolMgr;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import java.util.Arrays;
import java.util.Hashtable;

public class UnitTestClient {
    private static TraceComponent tc = Tr.register(UnitTestClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private int NUM_THREADS = 1;
    private int MSG_SIZE = 1;
    private String SERVER = "localhost";
    private String PORT = "1234";
    private int NUM_ITERATIONS = 1;
    private int NUM_REQ_PER_CONN = 1;
    private Hashtable dd = null;
    private ConnectionPool connPool;

    public static void main(String[] args) {
        new UnitTestClient().go(args);
    }

    private void parseArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equalsIgnoreCase("-threads")) {
                this.NUM_THREADS = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-server")) {
                this.SERVER = argv[++i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-port")) {
                this.PORT = argv[++i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-msgsize")) {
                this.MSG_SIZE = Integer.parseInt(argv[++i]);
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-iterations")) continue;
            this.NUM_ITERATIONS = Integer.parseInt(argv[++i]);
        }
        String msgStr = "B";
        byte[] msg = new byte[this.MSG_SIZE];
        byte[] closemsg = new byte[this.MSG_SIZE];
        Arrays.fill(msg, (byte)65);
        msg[0] = 66;
        msg[this.MSG_SIZE - 1] = 10;
        msg[this.MSG_SIZE - 2] = 69;
        Arrays.fill(closemsg, (byte)90);
        closemsg[0] = 66;
        closemsg[this.MSG_SIZE - 1] = 10;
        closemsg[this.MSG_SIZE - 2] = 67;
        this.dd = new Hashtable();
        this.dd.put("entity1", msg);
        this.dd.put("ENTITY3", closemsg);
        System.out.println(">>> Hashtable object=" + this.dd);
    }

    private void go(String[] args) {
        this.parseArgs(args);
        boolean portIncrement = true;
        boolean secEnabled = false;
        this.connPool = ConnectionPoolMgr.getInstance(secEnabled).getConnectionPool(this.SERVER, this.PORT, null, null, null);
        for (int i = 0; i < this.NUM_THREADS; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "------------ * THREAD " + i + " * ------------");
            }
            AccessorRunnable r = new AccessorRunnable(this.connPool, i);
            new Thread(r).start();
            System.out.println();
            System.out.println(">>> Client thread " + i + " launched");
        }
    }

    class AccessorRunnable
    implements Runnable {
        private ConnectionPool connPool = null;
        private int threadId;

        AccessorRunnable(ConnectionPool pool, int id) {
            this.connPool = pool;
            this.threadId = id;
        }

        public void run() {
            for (int i = 0; i < UnitTestClient.this.NUM_ITERATIONS; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "On thread " + this.threadId + ", iteration " + i + " started");
                }
                OutboundVirtualConnection ovc = null;
                try {
                    ovc = (OutboundVirtualConnection)this.connPool.getConnection();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connection obtained from pool: " + ovc);
                    }
                    ClientAccessor accessor = (ClientAccessor)ovc.getChannelAccessor();
                    Object result = accessor.request(UnitTestClient.this.dd);
                    this.connPool.putConnection(ovc);
                    continue;
                }
                catch (Exception e) {
                    StackTraceElement[] ste = e.getStackTrace();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "On thread " + this.threadId + ", iteration " + i + " failed due to " + e, ste);
                }
            }
        }
    }
}

