/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.ipc.Arrayster;
import com.ibm.ws.management.connector.ipc.CallData;
import com.ibm.ws.management.connector.ipc.CallRouter;
import com.ibm.ws.management.connector.ipc.IPCConnectorServer;
import com.ibm.ws.management.connector.ipc.IPCProtocol;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.SocketTimeoutException;
import java.util.Stack;

public class IPCConnectorInboundLink
extends InboundApplicationLink {
    private static TraceComponent tc = Tr.register(IPCConnectorInboundLink.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final int READ_TIMEOUT = -1;
    private static final int WRITE_TIMEOUT = -1;
    private static final int bufferSize = 8192;
    private boolean privateDebug = false;
    private boolean shortCircuit = false;
    private CallRouter router;
    private TCPReadCompletedCallback myRC;
    private TCPWriteCompletedCallback myWC;
    private boolean asynch;
    private String profileKey;
    private IPCProtocol.IPCCHeader header;
    private WsByteBuffer headerBuffer;
    private WsByteBuffer[] outputBuffers = new WsByteBuffer[2];
    private TCPConnectionContext tsc;
    private TCPReadRequestContext rtsc;
    private TCPWriteRequestContext wtsc;
    private WsByteBuffer bb;
    private Arrayster yster;
    private boolean quitConnection;
    private int msgSerial;

    public IPCConnectorInboundLink(VirtualConnection vc, boolean asynch, String profileKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IPCConnectorInboundLink<init>, profileKey=" + profileKey);
        }
        this.init(vc);
        this.myRC = new IPCConnectorReadCallback(this);
        this.myWC = new IPCConnectorWriteCallback(this);
        this.outputBuffers[0] = this.headerBuffer = IPCProtocol.allocateHeaderBuffer();
        this.asynch = IPCConnectorServer.ASYNCH;
        this.router = new CallRouter(profileKey);
        this.profileKey = profileKey;
        if (IPCConnectorServer.UNIT_TEST) {
            this.shortCircuit = true;
            this.privateDebug = true;
        }
    }

    protected void destroyLink(Exception e) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "destroyLink exception: " + e);
        }
    }

    public void ready(VirtualConnection vc) {
        block2: {
            block3: {
                this.quitConnection = false;
                this.yster = new Arrayster();
                this.yster.setBufferSize(8192);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "**** ready (New Connection) ****");
                }
                this.tsc = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
                this.rtsc = this.tsc.getReadInterface();
                this.wtsc = this.tsc.getWriteInterface();
                this.msgSerial = 0;
                if (!this.asynch) break block3;
                this.doWork(1);
                if (!this.quitConnection) break block2;
                this.close(vc, null);
                break block2;
            }
            do {
                this.doWork(2);
                if (!this.quitConnection) continue;
                this.close(vc, null);
                break block2;
            } while (!this.readMoreData(1));
            this.close(vc, null);
        }
    }

    public void close(VirtualConnection vc, Exception e) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "close; bb=" + this.bb + ", Message " + this.msgSerial + ", rtsc=" + this.rtsc);
        }
        if (this.bb != null) {
            this.bb.release();
        }
        super.close(vc, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doWork(int mode) {
        Stack currentStack2222;
        Stack savedStack;
        Object result;
        block40: {
            byte[] received;
            if (this.privateDebug && tc.isDebugEnabled()) {
                switch (mode) {
                    case 1: {
                        Tr.debug(tc, "doWork called asynch from ready");
                        break;
                    }
                    case 2: {
                        Tr.debug(tc, "doWork called from the forever loop in ready");
                        break;
                    }
                    case 3: {
                        Tr.debug(tc, "doWork called asynch from ReadCallback.complete");
                        break;
                    }
                }
            }
            this.bb = this.rtsc.getBuffer();
            if (this.bb == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The TCPReadRequestContext buffer is null; fatal error");
                }
                this.quitConnection = true;
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message " + this.msgSerial + " (re)entering doWork, bb=" + this.bb + ", rtsc=" + this.rtsc);
            }
            boolean bodyComplete = false;
            this.bb.flip();
            try {
                int count;
                block41: {
                    block42: {
                        if (this.header == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "*** new request: Message " + this.msgSerial + "; rtsc=" + this.rtsc);
                            }
                            this.header = IPCProtocol.readMessageHeader(this.bb);
                            if (this.header.headerComplete) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Header complete in first read; header=" + this.header + ", Message " + this.msgSerial + "; rtsc=" + this.rtsc);
                                }
                                this.yster.resetMerge(this.header.dataLength);
                            }
                        }
                        if (this.header.headerComplete) break block41;
                        if (this.privateDebug && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Header not complete...");
                        }
                        if (!this.asynch) break block42;
                        if (this.bb.remaining() > 0) {
                            IPCProtocol.readMessageHeader(this.header, this.bb);
                            if (this.header.headerComplete) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Header complete through multiple asynch reads; header=" + this.header);
                                }
                                this.yster.resetMerge(this.header.dataLength);
                            }
                        }
                        break block41;
                    }
                    while (!this.header.headerComplete) {
                        this.readMoreData(2);
                        this.bb.flip();
                        IPCProtocol.readMessageHeader(this.header, this.bb);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Header complete through multiple reads; header=" + this.header);
                    }
                    this.yster.resetMerge(this.header.dataLength);
                }
                if (this.privateDebug && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message " + this.msgSerial + ", bb=" + this.bb + ", rtsc=" + this.rtsc);
                }
                if ((count = this.bb.remaining()) > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message " + this.msgSerial + " getting " + count + " bytes; rtsc=" + this.rtsc);
                    }
                    received = new byte[count];
                    this.bb.get(received);
                    bodyComplete = this.yster.merge(received);
                }
            }
            catch (Throwable e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fatal error " + e + ", Message " + this.msgSerial + ", rtsc=" + this.rtsc);
                }
                Tr.error(tc, "ADMC0074E", e);
                this.quitConnection = true;
                return;
            }
            if (!bodyComplete) {
                if (!this.asynch) return;
                this.readMoreData(2);
                return;
            }
            received = this.yster.getByteArray();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message " + this.msgSerial + " complete; length of body=" + received.length + ", rtsc=" + this.rtsc);
            }
            Object request = null;
            result = null;
            boolean pushed = false;
            savedStack = null;
            try {
                try {
                    savedStack = AdminContext.exportStack();
                    if (this.profileKey != AdminContext.peek()) {
                        pushed = AdminContext.push((String)this.profileKey);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(received);
                    WsObjectInputStream ois = new WsObjectInputStream((InputStream)bais);
                    request = ois.readObject();
                    bais.close();
                    ois.close();
                    result = this.shortCircuit ? request : this.router.route((CallData)request);
                }
                catch (Throwable e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fatal error " + e + ", Message " + this.msgSerial + ", rtsc=" + this.rtsc);
                    }
                    Tr.error(tc, "ADMC0074E", e);
                    this.quitConnection = true;
                    Object var11_15 = null;
                    if (pushed) {
                        AdminContext.pop();
                    }
                    if (savedStack == null) return;
                    Stack currentStack2222 = AdminContext.exportStack();
                    if (savedStack.equals(currentStack2222)) return;
                    AdminContext.importStack((Stack)savedStack);
                    Tr.error(tc, "AdminContext Stack incorrectly used in IPC connector", new Object[]{savedStack, currentStack2222});
                    Exception ex = new Exception("AdminContext Stack incorrectly used in IPC connector");
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.ipc.CallRouter.route", (String)"300", (Object)((Object)this));
                    return;
                }
                Object var11_14 = null;
                if (!pushed) break block40;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (pushed) {
                    AdminContext.pop();
                }
                if (savedStack == null) throw throwable;
                Stack currentStack2222 = AdminContext.exportStack();
                if (savedStack.equals(currentStack2222)) throw throwable;
                AdminContext.importStack((Stack)savedStack);
                Tr.error(tc, "AdminContext Stack incorrectly used in IPC connector", new Object[]{savedStack, currentStack2222});
                Exception ex = new Exception("AdminContext Stack incorrectly used in IPC connector");
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.ipc.CallRouter.route", (String)"300", (Object)((Object)this));
                throw throwable;
            }
            AdminContext.pop();
        }
        if (savedStack != null && !savedStack.equals(currentStack2222 = AdminContext.exportStack())) {
            AdminContext.importStack((Stack)savedStack);
            Tr.error(tc, "AdminContext Stack incorrectly used in IPC connector", new Object[]{savedStack, currentStack2222});
            Exception ex = new Exception("AdminContext Stack incorrectly used in IPC connector");
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.ipc.CallRouter.route", (String)"300", (Object)((Object)this));
        }
        byte[] reply = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(result);
            oos.flush();
            reply = baos.toByteArray();
            baos.close();
            oos.close();
            this.header = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing out response to Message " + this.msgSerial + "; length of body will be " + reply.length + "; rtsc=" + this.rtsc);
            }
            ++this.msgSerial;
            this.writeData(reply);
            return;
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fatal error " + e + ", Message " + this.msgSerial + ", rtsc=" + this.rtsc);
            }
            Tr.error(tc, "ADMC0074E", e);
            this.quitConnection = true;
            return;
        }
    }

    public boolean readMoreData(int mode) {
        if (this.privateDebug && tc.isDebugEnabled()) {
            switch (mode) {
                case 1: {
                    Tr.debug(tc, "readMoreData called from the forever loop");
                    break;
                }
                case 2: {
                    Tr.debug(tc, "readMoreData called from doWork");
                    break;
                }
                case 3: {
                    Tr.debug(tc, "readMoreData called from WriteCallback.complete");
                    break;
                }
                case 4: {
                    Tr.debug(tc, "readMoreData called from ReadCallback.error (timeout)");
                    break;
                }
            }
        }
        this.bb.clear();
        boolean done = false;
        if (this.asynch) {
            VirtualConnection vc = null;
            vc = this.rtsc.read(1L, this.myRC, true, 60000);
            if (this.privateDebug && tc.isDebugEnabled()) {
                Tr.debug(tc, "readMoreData; asynch read queued, Message " + this.msgSerial + ", rtsc=" + this.rtsc);
            }
        } else {
            try {
                long nn = this.rtsc.read(1L, -1);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "readMoreData; bytes read=" + nn);
                }
            }
            catch (IOException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "readMoreData; exception from rtsc.read: " + ex);
                    Tr.debug(tc, "readMoreData; the client socket is probably closed; will close the server side");
                }
                done = true;
            }
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(byte[] reply) throws Exception {
        IPCProtocol.setDataLength(this.headerBuffer, reply.length);
        this.outputBuffers[1] = WsByteBufferPoolManagerImpl.getRef().wrap(reply);
        this.wtsc.setBuffers(this.outputBuffers);
        if (this.asynch) {
            VirtualConnection vc = null;
            vc = this.wtsc.write(-1L, this.myWC, true, 60000);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeData; asynch write queued");
            }
        } else {
            try {
                this.wtsc.write(-1L, -1);
                Object var4_3 = null;
                this.cleanupForNextWrite();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.cleanupForNextWrite();
                throw throwable;
            }
        }
    }

    public void cleanupForNextWrite() {
        if (this.outputBuffers[1] != null) {
            this.outputBuffers[1].release();
        }
        this.headerBuffer.rewind();
        this.wtsc.setBuffers(null);
    }

    public class IPCConnectorReadCallback
    implements TCPReadCompletedCallback {
        IPCConnectorInboundLink myLink = null;

        public IPCConnectorReadCallback(IPCConnectorInboundLink link) {
            this.myLink = link;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "myLink in ReadCallback=" + (Object)((Object)link));
            }
        }

        public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ReadCallback.complete; Message " + this.myLink.msgSerial + ", rtsc=" + this.myLink.rtsc);
            }
            this.myLink.doWork(3);
            if (this.myLink.quitConnection) {
                this.myLink.close(vc, null);
            }
        }

        public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException t) {
            if (t instanceof SocketTimeoutException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ReadCallback with timeout; Message " + this.myLink.msgSerial + ", rtsc=" + this.myLink.rtsc);
                }
                this.myLink.readMoreData(4);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ReadCallback.error; Message " + this.myLink.msgSerial + ", rtsc=" + this.myLink.rtsc + "; error=" + t);
                }
                boolean ready = vc.requestPermissionToClose(10000L);
                this.myLink.close(vc, null);
            }
        }
    }

    public class IPCConnectorWriteCallback
    implements TCPWriteCompletedCallback {
        IPCConnectorInboundLink myLink = null;

        public IPCConnectorWriteCallback(IPCConnectorInboundLink link) {
            this.myLink = link;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "myLink in WriteCallback=" + (Object)((Object)link));
            }
        }

        public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WriteCallback.complete; response to Message " + (this.myLink.msgSerial - 1) + ", rtsc=" + this.myLink.rtsc);
            }
            this.myLink.cleanupForNextWrite();
            this.myLink.readMoreData(3);
        }

        public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WriteCallback.error; response to Message " + (this.myLink.msgSerial - 1) + ", rtsc=" + this.myLink.rtsc + "; error=" + t);
            }
            IPCConnectorInboundLink.this.msgSerial--;
            this.myLink.close(vc, null);
        }
    }
}

