/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.ipc.IPCConnectorInboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.util.Map;

public class IPCConnectorInbound
extends InboundApplicationChannel
implements Discriminator {
    private static TraceComponent tc = Tr.register(IPCConnectorInbound.class, "Admin", "com.ibm.ws.management.resources.connector");
    private String profileKey;
    public boolean asynch = false;

    public IPCConnectorInbound(ChannelData config) {
        super(config);
        Map prop;
        String asynchProp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "IPCConnectorInbound");
        }
        if ((asynchProp = (String)(prop = config.getPropertyBag()).get("asynch")) != null && asynchProp.equals("true")) {
            this.asynch = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property asynch is true");
            }
        }
        String tmp = config.getExternalName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Channel name is " + tmp);
        }
        if (tmp.indexOf(".Default") > 0) {
            this.profileKey = null;
        } else if (tmp.indexOf("LC_IPCCInboundChannel.") == 0) {
            this.profileKey = tmp.substring("LC_IPCCInboundChannel.".length());
        } else if (tmp.indexOf("IPCCInboundChannel.") == 0) {
            this.profileKey = tmp.substring("IPCCInboundChannel.".length());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "profileKey set to " + this.profileKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "IPCConnectorInbound");
        }
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        WsByteBuffer[] buffs;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Discriminating against " + vc + " with " + discrimData);
        }
        if (null == (buffs = (WsByteBuffer[])discrimData) || 0 == buffs.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No data provided, returning MAYBE");
            }
            return -1;
        }
        int i = 0;
        int j = 3;
        int magic = 0;
        block0: for (i = 0; i < buffs.length; ++i) {
            if (magic == 0 && buffs[i].remaining() >= 4) {
                magic = buffs[i].getInt(0);
                break;
            }
            if (j <= 0) break;
            for (int k = 0; k < buffs[i].remaining(); ++k) {
                if (j > 0) {
                    magic |= buffs[i].get(k) << 8 * j;
                    --j;
                    continue;
                }
                magic |= buffs[i].get(k);
                continue block0;
            }
        }
        if (i > 0 && j > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not enough bytes provided, returning MAYBE");
            }
            return -1;
        }
        if (magic != 1229996867) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Incoming header does not match; returning NO");
            }
            return 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning YES");
        }
        return 1;
    }

    public Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public Map getProperties() {
        return null;
    }

    public int getWeight() {
        return this.config.getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        return new IPCConnectorInboundLink(vc, this.asynch, this.profileKey);
    }

    public Class getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public void update(ChannelData cc) {
    }

    public void start() {
    }

    public void stop(long millisec) {
    }

    public void init() {
    }

    public void destroy() {
    }

    public void cleanUpState(VirtualConnection vc) {
    }
}

