/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.connector.ipc.CallData;
import com.ibm.ws.management.connector.ipc.IPCConnectorClient;
import com.ibm.ws.management.connector.ipc.ResultData;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;

public class CallRouter {
    private static TraceComponent tc = Tr.register(CallRouter.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static AdminServiceDelegator targetObject = new AdminServiceDelegator();
    private boolean securityEnabled = SecurityHelper.getHelper().isSecurityEnabled();
    private String profileKey;

    public CallRouter() {
    }

    public CallRouter(String profileKey) {
        this.profileKey = profileKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultData route(CallData callData) {
        ResultData result;
        block128: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "route", callData);
            }
            String opName = callData.opName;
            result = new ResultData();
            boolean pushed = false;
            boolean secPushed = false;
            Object savedStack = null;
            try {
                block127: {
                    try {
                        ListenerIdentifier li;
                        ObjectName on;
                        Object tmp;
                        secPushed = SecurityObjectLocator.getThreadLocal().pushResource(new SecurityConfigResource("IPCConnector", "admin"));
                        if (callData.secDataFilled) {
                            Subject authSubject = null;
                            authSubject = callData.authByToken ? this.tokenBasedAuth(callData.token) : this.basicAuth(callData.user, callData.password);
                            SecurityHelper.resetContext();
                            if (authSubject != null) {
                                SecurityHelper.setReceivedSubject(authSubject);
                                SecurityHelper.pushInvocationSubject(authSubject);
                            }
                        }
                        if (opName.equals("serverSecurityEnabled")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: boolean serverSecurityEnabled()");
                            }
                            try {
                                boolean tmp2 = targetObject.serverSecurityEnabled();
                                result.obj = new Boolean(tmp2);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getAdminRSAPropagationCertificate")) {
                            try {
                                result.obj = targetObject.getAdminRSAPropagationCertificate();
                            }
                            catch (Exception ex) {
                                result.isException = true;
                                result.obj = ex;
                            }
                            break block127;
                        }
                        if (opName.equals("isAlive")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Session isAlive()");
                            }
                            try {
                                result.obj = tmp = targetObject.isAlive();
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("isAlive_i")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Session isAlive(int timeout)");
                            }
                            try {
                                int timeout = (Integer)callData.paramObj1;
                                Session tmp3 = targetObject.isAlive(timeout);
                                result.obj = tmp3;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("queryNames")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Set queryNames(ObjectName name, QueryExp query)");
                            }
                            try {
                                on = callData.objName;
                                QueryExp qe = (QueryExp)callData.paramObj1;
                                Set tmp4 = targetObject.queryNames(on, qe);
                                result.obj = tmp4;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getAttribute")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Object getAttribute(ObjectName name, String attribute)");
                            }
                            try {
                                Object tmp5;
                                on = callData.objName;
                                String att = (String)callData.paramObj1;
                                result.obj = tmp5 = targetObject.getAttribute(on, att);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getAttributes")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: AttributeList getAttributes(ObjectName name, String[] attributes)");
                            }
                            try {
                                on = callData.objName;
                                String[] att = (String[])callData.paramObj1;
                                AttributeList tmp6 = targetObject.getAttributes(on, att);
                                result.obj = tmp6;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("setAttribute")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void setAttribute(ObjectName name, Attribute attribute)");
                            }
                            try {
                                on = callData.objName;
                                Attribute att = (Attribute)callData.paramObj1;
                                targetObject.setAttribute(on, att);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("setAttributes")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: AttributeList setAttributes(ObjectName name, AttributeList attributes)");
                            }
                            try {
                                on = callData.objName;
                                AttributeList att = (AttributeList)callData.paramObj1;
                                AttributeList tmp7 = targetObject.setAttributes(on, att);
                                result.obj = tmp7;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("invoke")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Object invoke(ObjectName name, String operationName, Object params[], String signature[])");
                            }
                            try {
                                Object tmp8;
                                on = callData.objName;
                                String invokeOpName = callData.invokeOpName;
                                Object[] params = (Object[])callData.paramObj1;
                                String[] signature = (String[])callData.paramObj2;
                                result.obj = tmp8 = targetObject.invoke(on, invokeOpName, params, signature);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getDefaultDomain")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: String getDefaultDomain()");
                            }
                            try {
                                result.obj = tmp = targetObject.getDefaultDomain();
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getDomainName")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: String getDomainName()");
                            }
                            try {
                                result.obj = tmp = targetObject.getDomainName();
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getMBeanCount")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Integer getMBeanCount()");
                            }
                            try {
                                result.obj = tmp = targetObject.getMBeanCount();
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getServerMBean")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: ObjectName getServerMBean()");
                            }
                            try {
                                result.obj = tmp = targetObject.getServerMBean();
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getMBeanInfo")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: MBeanInfo getMBeanInfo(ObjectName name)");
                            }
                            try {
                                on = callData.objName;
                                MBeanInfo tmp9 = targetObject.getMBeanInfo(on);
                                result.obj = tmp9;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("isRegistered")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: boolean isRegistered(ObjectName name)");
                            }
                            try {
                                on = callData.objName;
                                boolean tmp10 = targetObject.isRegistered(on);
                                result.obj = new Boolean(tmp10);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getClassLoaderFor")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: ClassLoader getClassLoaderFor(ObjectName name)");
                            }
                            try {
                                on = callData.objName;
                                ClassLoader tmp11 = targetObject.getClassLoaderFor(on);
                                result.obj = tmp11;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getClassLoader")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: ClassLoader getClassLoader(ObjectName name)");
                            }
                            try {
                                on = callData.objName;
                                ClassLoader tmp12 = targetObject.getClassLoader(on);
                                result.obj = tmp12;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("isInstanceOf")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: boolean isInstanceOf(ObjectName name, String className)");
                            }
                            try {
                                on = callData.objName;
                                String cname = (String)callData.paramObj1;
                                boolean tmp13 = targetObject.isInstanceOf(on, cname);
                                result.obj = new Boolean(tmp13);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("queryMBeans")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Set queryMBeans(ObjectName name, QueryExp query)");
                            }
                            try {
                                on = callData.objName;
                                QueryExp qe = (QueryExp)callData.paramObj1;
                                Set tmp14 = targetObject.queryMBeans(on, qe);
                                result.obj = tmp14;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("getObjectInstance")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: ObjectInstance getObjectInstance(ObjectName name)");
                            }
                            try {
                                on = callData.objName;
                                ObjectInstance tmp15 = targetObject.getObjectInstance(on);
                                result.obj = tmp15;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("addNotificationListener_ON_ON_NF_O")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)");
                            }
                            try {
                                on = callData.objName;
                                ObjectName li2 = (ObjectName)callData.paramObj1;
                                NotificationFilter nf = (NotificationFilter)callData.paramObj2;
                                Object ha = callData.paramObj3;
                                targetObject.addNotificationListener(on, li2, nf, ha);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("removeNotificationListener_ON_ON")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void removeNotificationListener(ObjectName name, ObjectName listener)");
                            }
                            try {
                                on = callData.objName;
                                ObjectName li3 = (ObjectName)callData.paramObj1;
                                targetObject.removeNotificationListener(on, li3);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("removeNotificationListener_ON_ON_NF_O")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)");
                            }
                            try {
                                on = callData.objName;
                                ObjectName li4 = (ObjectName)callData.paramObj1;
                                NotificationFilter nf = (NotificationFilter)callData.paramObj2;
                                Object ha = callData.paramObj3;
                                targetObject.removeNotificationListener(on, li4, nf, ha);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("addNotificationListener_CF_PNL")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener)");
                            }
                            try {
                                ConsolidatedFilter cf = (ConsolidatedFilter)callData.paramObj1;
                                PushNotificationListener pnl = (PushNotificationListener)callData.paramObj2;
                                ListenerIdentifier tmp16 = targetObject.addNotificationListener(cf, pnl);
                                result.obj = tmp16;
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("removeNotificationListener_LI")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void removeNotificationListener(ListenerIdentifier listenerId)");
                            }
                            try {
                                li = (ListenerIdentifier)callData.paramObj1;
                                targetObject.removeNotificationListener(li);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("resetFilter")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filters)");
                            }
                            try {
                                li = (ListenerIdentifier)callData.paramObj1;
                                ConsolidatedFilter cf = (ConsolidatedFilter)callData.paramObj2;
                                targetObject.resetFilter(li, cf);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("pullNotifications")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize)");
                            }
                            try {
                                Notification[] tmp17;
                                li = (ListenerIdentifier)callData.paramObj1;
                                Integer bs = (Integer)callData.paramObj2;
                                result.obj = tmp17 = targetObject.pullNotifications(li, bs);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                            break block127;
                        }
                        if (opName.equals("removeNotificationListener_ON_NL")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Routing to: void removeNotificationListener(ObjectName name, NotificationListener listener)");
                            }
                            try {
                                on = callData.objName;
                                NotificationListener nl = (NotificationListener)callData.paramObj1;
                                targetObject.removeNotificationListener(on, nl);
                            }
                            catch (Exception e) {
                                result.isException = true;
                                result.obj = e;
                            }
                        } else {
                            result.isException = true;
                            result.obj = new Exception("Operation name " + opName + " not recognized");
                        }
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting result to exception ", ex);
                        }
                        result.isException = true;
                        result.obj = ex;
                        Object var13_77 = null;
                        if (secPushed) {
                            SecurityObjectLocator.getThreadLocal().popResource();
                        }
                        break block128;
                    }
                }
                Object var13_76 = null;
                if (!secPushed) break block128;
            }
            catch (Throwable throwable) {
                Object var13_78 = null;
                if (secPushed) {
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
                throw throwable;
            }
            SecurityObjectLocator.getThreadLocal().popResource();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "route", result);
        }
        return result;
    }

    private Subject basicAuth(String username, String password) {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "basicAuth");
            }
            subject = null;
            try {
                if (username.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                    username = RealmSecurityName.getSecurityName((String)username);
                }
                subject = SecurityHelper.authenticate(username, password);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.ipc.CallRouter.basicAuth", (String)"406", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unable to authenticate incoming request:", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicAuth");
        }
        return subject;
    }

    private Subject tokenBasedAuth(byte[] token) throws Exception {
        Subject subject;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "tokenBasedAuth");
            }
            byte[] bytes = token;
            WSSecurityContext ctx = SecurityHelper.getHelper().getWSSecurityContext();
            subject = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attemping to extract subject from a V6+ token.");
                }
                WSSecurityContextResult result = ctx.acceptSecContext(bytes);
                subject = result.getSubject();
            }
            catch (Exception ex) {
                if (IPCConnectorClient.isCertPathValidatorException(ex)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got CertPathValidatorException", ex);
                    }
                    throw ex;
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to extract subject from V6+ token, attempting to extract using the pre-V6 format.");
                    }
                    subject = SecurityHelper.validate(bytes);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to extract subject using the pre-V6 format.");
                    }
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.connector.ipc.CallRouter.tokenBasedAuth", (String)"415", (Object)this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "unable to authenticate incoming request", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "tokenBasedAuth");
        }
        return subject;
    }
}

