/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.interop.JMXClassLoader;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXTransformReader;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class JMXObjectInputStream
extends ObjectInputStream {
    private static TraceComponent tc = Tr.register(JMXObjectInputStream.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static JMXTransformReader jmxTransform = GenericSerializer.getJMXTransformReader();
    private static JMXClassLoader classLoader = GenericSerializer.getJMXClassLoader();

    public JMXObjectInputStream(InputStream A) throws IOException {
        super(A);
        this.enableResolveObject(true);
    }

    public Object jmxReadObject() throws IOException, ClassNotFoundException, JMXTransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jmxReadObject");
        }
        Object object = null;
        object = this.readObject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ToTMX4jOutputStream out = new ToTMX4jOutputStream(baos);
        out.writeObject(object);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        object = in.readObject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jmxReadObject");
        }
        return object;
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveClass", new Object[]{osc.getName()});
        }
        String name = osc.getName();
        Class<?> cls = null;
        cls = Class.forName(name, false, classLoader);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveClass");
        }
        return cls;
    }

    public static class ToTMX4jOutputStream
    extends ObjectOutputStream {
        public ToTMX4jOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        public Object replaceObject(Object object) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ToTMX4jOutputStream.replaceObject, object=" + object);
            }
            try {
                object = jmxTransform.transform(object);
            }
            catch (JMXTransformException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ToTMX4jOutputStream.replaceObject, object=" + object);
            }
            return object;
        }
    }
}

