/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ConnectorHelper {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(ConnectorHelper.class, "Admin", "com.ibm.ws.management.resources.connector");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private HashMap connectors = new HashMap(connTypes.length);
    private String localAdminProtocol = null;
    private String remoteAdminProtocol = null;
    private String preferredConnector = null;
    private String serverName = null;
    private String nodeName = null;
    private VariableMap variableMap = null;
    private static String[] connTypes = new String[]{"SOAP", "RMI", "JSR160RMI", "IPC"};
    private static String[] typeNames = new String[]{"SOAPConnector", "RMIConnector", "JSR160RMIConnector", "IPCConnector"};
    private static String[] endpointNames = new String[]{"SOAP_CONNECTOR_ADDRESS", "RMI_CONNECTOR_ADDRESS", "JSR160RMI_CONNECTOR_ADDRESS", "IPC_CONNECTOR_ADDRESS"};
    private static Hashtable typeNameToConnType = new Hashtable(typeNames.length);

    public ConnectorHelper(String configRoot, String cellName, String nodeName, String serverName, String uuid, String defaultHostName, String managedNodeName, boolean isInternal, String username, String password) {
        if (configRoot == null || cellName == null || nodeName == null || serverName == null) {
            Exception t = new Exception("Insufficient information to locate a server: configRoot: " + configRoot + ", cellName: " + cellName + ", nodeName: " + nodeName + ", serverName: " + serverName + ", managedNodeName: " + managedNodeName);
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"134", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnectorHelper constructor: no information about server");
            }
            return;
        }
        ConfigService configService = ConfigServiceFactory.createConfigService((String)configRoot, (String)cellName, (String)nodeName, (String)serverName);
        Repository rep = RepositoryFactory.createRepository((String)"ws-server", (String)configRoot, (String)cellName, (String)nodeName, (String)serverName);
        VariableMap varMap = null;
        try {
            varMap = VariableMapFactory.createVariableMap((Repository)rep);
            varMap.initialize(null);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error initializing variableMap", t);
            }
            varMap = null;
        }
        this.initialize(configService, varMap, uuid, defaultHostName, managedNodeName, isInternal, username, password);
    }

    public ConnectorHelper(ConfigService configService, VariableMap variableMap, String uuid, String defaultHostName, String managedNodeName, boolean isInternal, String username, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConnectorHelper constructor:  managedNodeName: " + managedNodeName);
        }
        this.initialize(configService, variableMap, uuid, defaultHostName, managedNodeName, isInternal, username, password);
    }

    private void initialize(ConfigService configService, VariableMap variableMap, String uuid, String defaultHostName, String managedNodeName, boolean isInternal, String username, String password) {
        ConnectorInfo info;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (configService == null) {
            Exception t = new Exception("ConfigService is null");
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"134", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnectorHelper constructor: no ConfigService");
            }
            return;
        }
        this.serverName = configService.getServerName();
        this.nodeName = configService.getNodeName();
        for (i = 0; i < typeNames.length; ++i) {
            info = new ConnectorInfo();
            info.endpointName = endpointNames[i];
            this.connectors.put(connTypes[i], info);
        }
        if (uuid == null && managedNodeName == null) {
            List serverObjs = null;
            try {
                serverObjs = configService.getDocumentObjects(configService.getScope(4), "server.xml");
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"145", (Object)this);
            }
            if (serverObjs == null || serverObjs.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can't find server.xml for server : " + this.serverName);
                }
            } else {
                ConfigObject object = (ConfigObject)serverObjs.get(0);
                List services = object.getObjectList("services");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object has: " + services.size() + " services");
                }
                for (ConfigObject service : services) {
                    List connectorsList;
                    ConfigObject preferredConnectorObj;
                    ConfigObject remoteAdminProtocolObj;
                    String typeName = service.getTypeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "services type: " + typeName);
                    }
                    if (!"AdminService".equals(typeName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "found Adminservice for server: " + this.serverName);
                    }
                    HashMap adminProtocols = new HashMap();
                    ConfigObject localAdminProtocolObj = service.getObject("localAdminProtocol");
                    if (localAdminProtocolObj != null) {
                        this.localAdminProtocol = (String)typeNameToConnType.get(localAdminProtocolObj.getTypeName());
                    }
                    if ((remoteAdminProtocolObj = service.getObject("remoteAdminProtocol")) != null) {
                        this.remoteAdminProtocol = (String)typeNameToConnType.get(remoteAdminProtocolObj.getTypeName());
                    }
                    if ((preferredConnectorObj = service.getObject("preferredConnector")) != null) {
                        this.preferredConnector = (String)typeNameToConnType.get(preferredConnectorObj.getTypeName());
                    }
                    if ((connectorsList = service.getObjectList("connectors")) == null || connectorsList.size() <= 0) break;
                    for (ConfigObject connector2 : connectorsList) {
                        ConnectorInfo info2;
                        String type = (String)typeNameToConnType.get(connector2.getTypeName());
                        boolean enabled = connector2.getBoolean("enable", false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "connector type: " + type + " enabled: " + enabled);
                        }
                        if (type == null || (info2 = (ConnectorInfo)this.connectors.get(type)) == null) continue;
                        info2.enabled = enabled;
                    }
                    break;
                }
            }
        } else {
            for (i = 0; i < connTypes.length; ++i) {
                info = (ConnectorInfo)this.connectors.get(connTypes[i]);
                info.enabled = true;
            }
        }
        String secString = "false";
        if (isInternal) {
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                secString = "true";
            }
        } else {
            List security = null;
            try {
                security = configService.getDocumentObjects(configService.getScope(0), "security.xml");
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"308", (Object)this);
            }
            if (security == null || security.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can't find security.xml");
                }
            } else {
                ConfigObject object = (ConfigObject)security.get(0);
                boolean secEnabled = object.getBoolean("enabled", false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "secEnabled in security.xml: " + secEnabled);
                }
                if (secEnabled) {
                    secString = "true";
                }
            }
        }
        List serverIndex = null;
        try {
            serverIndex = configService.getDocumentObjects(configService.getScope(3), "serverindex.xml");
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.discovery.transport.MBeanDiscoveryHelper", (String)"216", (Object)this);
        }
        if (serverIndex == null || serverIndex.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can't find serverindex for node: " + this.nodeName);
            }
        } else {
            String bootstrapEndpointName = null;
            if (uuid == null) {
                bootstrapEndpointName = "BOOTSTRAP_ADDRESS";
            }
            String bootstrapHost = null;
            String bootstrapPort = null;
            ConfigObject object = (ConfigObject)serverIndex.get(0);
            List serverEntries = object.getObjectList("serverEntries");
            for (ConfigObject serverEntry : serverEntries) {
                String tmpServerName = serverEntry.getString("serverName", "");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverEntries serverName: " + tmpServerName);
                }
                if (!this.serverName.equals(tmpServerName)) continue;
                List specialEndpoints = serverEntry.getObjectList("specialEndpoints");
                block11: for (ConfigObject namedEndpoint : specialEndpoints) {
                    String endpointName = namedEndpoint.getString("endPointName", "");
                    ConfigObject endPoint = namedEndpoint.getObject("endPoint");
                    String tmpHost = endPoint.getUnexpandedString("host", defaultHostName);
                    if (variableMap != null) {
                        tmpHost = variableMap.expand(tmpHost);
                    }
                    if (tmpHost == null || tmpHost.length() <= 0) {
                        tmpHost = defaultHostName;
                    }
                    String port = endPoint.getUnexpandedString("port", "0");
                    if (variableMap != null) {
                        port = variableMap.expand(port);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endpointName: " + endpointName + ", hostName: " + tmpHost + " port: " + port);
                    }
                    if (bootstrapEndpointName != null && bootstrapEndpointName.equals(endpointName)) {
                        bootstrapHost = tmpHost;
                        bootstrapPort = port;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "found boostratpHost: " + bootstrapHost + " bootstrapPort: " + bootstrapPort);
                        continue;
                    }
                    for (int i2 = 0; i2 < connTypes.length; ++i2) {
                        ConnectorInfo info3 = (ConnectorInfo)this.connectors.get(connTypes[i2]);
                        String infoEndPointName = info3.endpointName;
                        if (uuid != null && managedNodeName != null) {
                            infoEndPointName = infoEndPointName + "_" + managedNodeName;
                        }
                        if (!infoEndPointName.equals(endpointName) || !info3.enabled) continue;
                        info3.props = new Properties();
                        info3.props.setProperty("type", connTypes[i2]);
                        info3.props.setProperty("host", tmpHost);
                        info3.props.setProperty("port", port);
                        info3.props.setProperty("securityEnabled", secString);
                        if (isInternal) {
                            info3.props.setProperty("isInternal", "true");
                        }
                        if (connTypes[i2].equals(this.localAdminProtocol)) {
                            info3.props.setProperty("localAdminProtocol", "true");
                        }
                        if (connTypes[i2].equals(this.remoteAdminProtocol)) {
                            info3.props.setProperty("remoteAdminProtocol", "true");
                        }
                        if (connTypes[i2].equals(this.preferredConnector)) {
                            info3.props.setProperty("preferred", "true");
                        }
                        if (username != null && password != null) {
                            info3.props.setProperty("username", username);
                            info3.props.setProperty("password", password);
                        }
                        if (!tc.isDebugEnabled()) continue block11;
                        Tr.debug(tc, "found connector properties: ");
                        this.debugProps(info3.props, "    ");
                        continue block11;
                    }
                }
            }
            if (uuid == null && bootstrapHost != null && bootstrapPort != null) {
                ConnectorInfo jsr160rmiInfo;
                ConnectorInfo rmiInfo = (ConnectorInfo)this.connectors.get("RMI");
                if (rmiInfo != null && rmiInfo.enabled && rmiInfo.props == null) {
                    rmiInfo.props = new Properties();
                    rmiInfo.props.setProperty("type", "RMI");
                    rmiInfo.props.setProperty("host", bootstrapHost);
                    rmiInfo.props.setProperty("port", bootstrapPort);
                    rmiInfo.props.setProperty("securityEnabled", secString);
                    if (isInternal) {
                        rmiInfo.props.setProperty("isInternal", "true");
                    }
                    if ("RMI".equals(this.localAdminProtocol)) {
                        rmiInfo.props.setProperty("localAdminProtocol", "true");
                    }
                    if ("RMI".equals(this.remoteAdminProtocol)) {
                        rmiInfo.props.setProperty("remoteAdminProtocol", "true");
                    }
                    if ("RMI".equals(this.preferredConnector)) {
                        rmiInfo.props.setProperty("preferred", "true");
                    }
                    if (username != null && password != null) {
                        rmiInfo.props.setProperty("username", username);
                        rmiInfo.props.setProperty("password", password);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using bootstrap host/port for RMI connector:");
                        this.debugProps(rmiInfo.props, "    ");
                    }
                }
                if ((jsr160rmiInfo = (ConnectorInfo)this.connectors.get("JSR160RMI")) != null && jsr160rmiInfo.enabled && jsr160rmiInfo.props == null) {
                    jsr160rmiInfo.props = new Properties();
                    jsr160rmiInfo.props.setProperty("type", "JSR160RMI");
                    jsr160rmiInfo.props.setProperty("host", bootstrapHost);
                    jsr160rmiInfo.props.setProperty("port", bootstrapPort);
                    jsr160rmiInfo.props.setProperty("securityEnabled", secString);
                    if (isInternal) {
                        jsr160rmiInfo.props.setProperty("isInternal", "true");
                    }
                    if ("JSR160RMI".equals(this.localAdminProtocol)) {
                        jsr160rmiInfo.props.setProperty("localAdminProtocol", "true");
                    }
                    if ("JSR160RMI".equals(this.remoteAdminProtocol)) {
                        jsr160rmiInfo.props.setProperty("remoteAdminProtocol", "true");
                    }
                    if ("JSR160RMI".equals(this.preferredConnector)) {
                        jsr160rmiInfo.props.setProperty("preferred", "true");
                    }
                    if (username != null && password != null) {
                        jsr160rmiInfo.props.setProperty("username", username);
                        jsr160rmiInfo.props.setProperty("password", password);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using bootstrap host/port for JSR160RMI connector:");
                        this.debugProps(jsr160rmiInfo.props, "    ");
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localAdminProtocol: " + this.localAdminProtocol + " remoteAdminProtocol: " + this.remoteAdminProtocol + "  preferredConnector: " + this.preferredConnector);
        }
        this.debug();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public AdminClient createConnector(boolean tryAll) throws ConnectorException {
        ArrayList<String> list = new ArrayList<String>();
        if (this.localAdminProtocol != null) {
            list.add(this.localAdminProtocol);
        }
        if (this.remoteAdminProtocol != null) {
            list.add(this.remoteAdminProtocol);
        }
        if (this.preferredConnector != null) {
            list.add(this.preferredConnector);
        }
        return this.createConnector(list, tryAll);
    }

    public AdminClient createConnector(List list, boolean tryAll) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnector", new Object[]{list, new Boolean(tryAll)});
        }
        ConnectorException savedEx = null;
        AdminClient client = null;
        Hashtable tried = new Hashtable();
        for (String proto : list) {
            block13: {
                try {
                    client = this.tryProtocol(proto, tried);
                }
                catch (ConnectorException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to create connector: ", ex);
                    }
                    if (savedEx != null) break block13;
                    savedEx = ex;
                }
            }
            if (client == null && (tryAll || tried.size() <= 0)) continue;
            break;
        }
        if (client == null && (tryAll || tried.size() == 0)) {
            for (int i = 0; i < connTypes.length; ++i) {
                block14: {
                    try {
                        client = this.tryProtocol(connTypes[i], tried);
                    }
                    catch (ConnectorException ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unable to create connector: ", ex);
                        }
                        if (savedEx != null) break block14;
                        savedEx = ex;
                    }
                }
                if (client != null || !tryAll && tried.size() > 0) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnector", new Object[]{client, savedEx});
        }
        if (client != null) {
            return client;
        }
        if (savedEx != null) {
            throw new ConnectorException(savedEx);
        }
        throw new ConnectorException("Unable to create AdminCient");
    }

    public String getLocalAdminProtocol() {
        return this.localAdminProtocol;
    }

    public String getRemoteAdminProtocol() {
        return this.remoteAdminProtocol;
    }

    public String getPreferredConnector() {
        return this.preferredConnector;
    }

    private AdminClient tryProtocol(String connType, Hashtable tried) throws ConnectorException {
        AdminClient ret = null;
        if (connType != null && tried.get(connType) == null) {
            ConnectorInfo info = (ConnectorInfo)this.connectors.get(connType);
            tried.put(connType, connType);
            if (info != null && info.enabled && info.props != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "trying to create admin client with properties:");
                    for (String string : info.props.keySet()) {
                        String value = info.props.getProperty(string);
                        if ("password".equals(string)) {
                            Tr.debug(tc, "    " + string + "=****");
                            continue;
                        }
                        Tr.debug(tc, "    " + string + "=" + value);
                    }
                }
                ret = AdminClientFactory.createAdminClient(info.props);
                Tr.debug(tc, "admin client created", ret);
            }
        }
        return ret;
    }

    public List getOpenConnectorPorts(boolean tryAll) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenConnectorPorts: " + tryAll);
        }
        ArrayList<String> runningList = new ArrayList<String>();
        ArrayList<String> tried = new ArrayList<String>();
        for (ConnectorInfo info : this.connectors.values()) {
            boolean running = false;
            if (!info.enabled || info.props == null) continue;
            String host = info.props.getProperty("host");
            String port = info.props.getProperty("port");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "testing host: " + host + ", port: " + port);
            }
            int portInt = 0;
            try {
                portInt = Integer.parseInt(port);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String hostport = host + ":" + port;
            if (host == null || port == null || portInt == 0 || tried.contains(hostport)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trying host: " + host + ", port: " + port);
            }
            try {
                tried.add(hostport);
                Socket soc = new Socket(host, portInt);
                running = true;
                runningList.add(port);
                soc.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "determined host: " + host + ", port: " + port + (running ? " " : " NOT ") + " in use");
            }
            if (!running || tryAll) continue;
            break;
        }
        return runningList;
    }

    public void debug() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "**** Begin ConectorHelper dump: ****");
            Tr.debug(tc, "localAdminProtocol: " + this.localAdminProtocol);
            Tr.debug(tc, "remoteAdminProtocol: " + this.remoteAdminProtocol);
            Tr.debug(tc, "preferredConnector: " + this.preferredConnector);
            int i = 0;
            Iterator it = this.connectors.values().iterator();
            while (it.hasNext()) {
                Tr.debug(tc, "******* Connector " + i + "*****");
                ConnectorInfo data = (ConnectorInfo)it.next();
                Tr.debug(tc, "enabled: " + data.enabled);
                this.debugProps(data.props, "    ");
                ++i;
            }
            Tr.debug(tc, "**** End ConectorHelper dump: ****");
        }
    }

    private void debugProps(Properties props, String prefix) {
        if (props == null) {
            return;
        }
        for (String string : props.keySet()) {
            String value = props.getProperty(string);
            if ("password".equals(string)) {
                Tr.debug(tc, prefix + string + "=****");
                continue;
            }
            Tr.debug(tc, prefix + string + "=" + value);
        }
    }

    static {
        for (int i = 0; i < typeNames.length; ++i) {
            typeNameToConnType.put(typeNames[i], connTypes[i]);
        }
    }

    public static class ConnectorInfo {
        public Properties props = null;
        public boolean enabled = false;
        public String endpointName;
    }
}

