/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RemoteAdminService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class AdminServiceDelegator
implements RemoteAdminService {
    private static TraceComponent tc = Tr.register(AdminServiceDelegator.class, "Admin", "com.ibm.ws.management.resources.connector");
    private AdminServiceImpl _adminInstance = (AdminServiceImpl)AdminServiceFactory.getAdminService();

    public boolean serverSecurityEnabled() {
        return SecurityHelper.getHelper().isSecurityEnabled();
    }

    public X509Certificate getAdminRSAPropagationCertificate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminRSAPropagationCertificate");
        }
        boolean isDebug = tc.isDebugEnabled();
        String node = this._adminInstance.getNodeName();
        String process = this._adminInstance.getProcessName();
        ObjectName queryName = new ObjectName(this._adminInstance.getDomainName() + ":" + "type=SSLAdmin,node=" + node + ",process=" + process + ",*");
        Set names = this._adminInstance.queryNames(queryName, null);
        ObjectName mBeanName = (ObjectName)names.iterator().next();
        if (isDebug) {
            Tr.debug(tc, "mBeanName = " + mBeanName);
        }
        X509Certificate cert = (X509Certificate)this._adminInstance.invoke(mBeanName, "getAdminRSAPropagationCertificate", null, null);
        if (isDebug) {
            Tr.debug(tc, "cert = " + cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminRSAPropagationCertificate", cert);
        }
        return cert;
    }

    public Session isAlive() {
        return this._adminInstance.isAlive();
    }

    public Session isAlive(int timeout) {
        return this._adminInstance.isAlive();
    }

    public String getDomainName() {
        return this._adminInstance.getDomainName();
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames", name);
        }
        Set retVal = this._adminInstance.queryNames(name, query);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames");
        }
        return retVal;
    }

    public boolean isRegistered(ObjectName name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered", name);
        }
        boolean retVal = this._adminInstance.isRegistered(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered");
        }
        return retVal;
    }

    public Integer getMBeanCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        Integer retVal = this._adminInstance.getMBeanCount();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount");
        }
        return retVal;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", name);
        }
        Object retVal = this._adminInstance.getAttribute(name, attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute");
        }
        return retVal;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", name);
        }
        AttributeList retVal = this._adminInstance.getAttributes(name, attributes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return retVal;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute");
        }
        this._adminInstance.setAttribute(name, attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", name);
        }
        AttributeList retVal = this._adminInstance.setAttributes(name, attributes);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
        return retVal;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", name);
        }
        Object retVal = this._adminInstance.invoke(name, operationName, params, signature);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return retVal;
    }

    public String getDefaultDomain() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        String retVal = this._adminInstance.getDefaultDomain();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain");
        }
        return retVal;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanInfo", name);
        }
        MBeanInfo retVal = this._adminInstance.getMBeanInfo(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanInfo");
        }
        return retVal;
    }

    public ObjectName getServerMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerMBean");
        }
        ObjectName retVal = this._adminInstance.getServerMBean();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerMBean");
        }
        return retVal;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf", name);
        }
        boolean retVal = this._adminInstance.isInstanceOf(name, className);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf");
        }
        return retVal;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        this.addNotificationListenerExtended(name, listener, filter, handback);
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        this._adminInstance.addNotificationListenerExtended(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        if (!this.isRegistered(name)) {
            throw new InstanceNotFoundException("Could not find " + name);
        }
        this.removeNotificationListenerExtended(listener);
    }

    public void removeNotificationListenerExtended(NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        this._adminInstance.removeNotificationListenerExtended(listener);
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) {
        return this._adminInstance.addNotificationListener(filter, listener);
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws ReceiverNotFoundException {
        this._adminInstance.removeNotificationListener(listenerId);
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws ReceiverNotFoundException {
        this._adminInstance.resetFilter(listenerId, filter);
    }

    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ReceiverNotFoundException {
        return this._adminInstance.pullNotifications(id, batchSize);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans", name);
        }
        Set retVal = this._adminInstance.queryMBeans(name, query);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans");
        }
        return retVal;
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor", name);
        }
        ClassLoader retVal = this._adminInstance.getClassLoaderFor(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor", retVal);
        }
        return retVal;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader", name);
        }
        ClassLoader retVal = this._adminInstance.getClassLoader(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader", retVal);
        }
        return retVal;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", name);
        }
        ObjectInstance retVal = this._adminInstance.getObjectInstance(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance", retVal);
        }
        return retVal;
    }

    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this._adminInstance.addNotificationListener(observed, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this._adminInstance.removeNotificationListener(observed, listener);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this._adminInstance.removeNotificationListener(observed, listener, filter, handback);
    }
}

