/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.ConfigChangeId;
import com.ibm.ws.management.configservice.configdiff.SPXId;
import com.ibm.ws.management.configservice.configdiff.TimeLine;
import com.ibm.ws.management.configservice.configdiff.TimeLineImpl;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegment;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegmentImpl;
import com.ibm.ws.management.configservice.configdiff.Version;
import com.ibm.ws.management.configservice.schemadiff.ConfigChange;
import com.ibm.ws.management.configservice.schemadiff.ProductCapability;
import com.ibm.ws.management.configservice.schemadiff.ProductDiff;
import com.ibm.ws.management.configservice.schemadiff.ProductProperty;
import com.ibm.ws.management.configservice.schemadiff.SchemaDiff;
import com.ibm.ws.management.configservice.schemadiff.SchemadiffFactory;
import com.ibm.ws.management.configservice.schemadiff.SchemadiffPackage;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.framework.Bundle;

public abstract class TimeLineDataBase {
    protected static Map timeLineCache = Collections.synchronizedMap(new HashMap());
    private static TraceComponent tc = Tr.register(TimeLineDataBase.class, "management", "com.ibm.ws.management.resources.configservice");
    private static SchemadiffFactory dfac = null;

    protected void createTimeLine(String schema, ProductCapability pcap, ConfigChange change) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTimeLine", new Object[]{pcap, change});
        }
        ConfigChangeId configChangeId = new ConfigChangeId(schema, change.getChangedObject());
        SPXId spxId = new SPXId(pcap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching with ConfigId: ", configChangeId);
        }
        LinkedList<TimeLineImpl> spx = (LinkedList<TimeLineImpl>)timeLineCache.get(configChangeId);
        TimeLineImpl impl = null;
        if (spx == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find SPX List");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found a SPX List");
            }
            ListIterator iterator = spx.listIterator();
            while (iterator.hasNext()) {
                TimeLineImpl tmpTimeLine = (TimeLineImpl)iterator.next();
                if (!tmpTimeLine.sameProductCapability(schema, pcap)) continue;
                impl = tmpTimeLine;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found an existing TimeLineImpl SPX List with matching product capabilities: " + impl);
                break;
            }
            if (impl == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find an existing TimeLineImpl SPX List with matching product capabilities: " + pcap);
            }
        }
        boolean spxWasNull = false;
        if (spx == null) {
            spx = new LinkedList<TimeLineImpl>();
            spxWasNull = true;
        }
        boolean implWasNull = false;
        if (impl == null) {
            impl = new TimeLineImpl(schema, pcap, change);
            implWasNull = true;
        }
        EList newPropsList = pcap.getProductProperty();
        String version = null;
        String versionKey = pcap.getVersionKey();
        for (ProductProperty prop : newPropsList) {
            if (!prop.getName().equals(versionKey)) continue;
            version = prop.getValue();
            break;
        }
        TimeLineSegmentImpl segment = new TimeLineSegmentImpl(version, change.getChangedData(), impl);
        impl.addTimeLineSegment(segment);
        if (implWasNull) {
            spx.add(impl);
        }
        if (spxWasNull) {
            timeLineCache.put(configChangeId, spx);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTimeLine", impl);
        }
    }

    public List getTimeLine(ConfigChangeId configChangeId) {
        LinkedList spx;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeLine", new Object[]{configChangeId});
        }
        if ((spx = (LinkedList)timeLineCache.get(configChangeId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTimeLine", "spx is null");
            }
            spx = new LinkedList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeLine", new Object[]{spx});
        }
        return spx;
    }

    public List getTimeLineSegments(ConfigChangeId configChangeId, Properties nodeProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeLineSegments", new Object[]{configChangeId, nodeProperties});
        }
        LinkedList<TimeLineSegment> result = new LinkedList<TimeLineSegment>();
        List timelines = (List)timeLineCache.get(configChangeId);
        if (timelines != null) {
            for (TimeLine timeline : timelines) {
                if (!timeline.match(nodeProperties)) continue;
                String versionKey = timeline.getVersionKey();
                String version = (String)nodeProperties.get(versionKey);
                TimeLineSegment segment = timeline.getClosestSegment(version);
                result.add(segment);
            }
        }
        if (result.size() <= 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimeLineSegments", new Object[]{result});
            }
            return result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimeLineSegments", "Finding bestmatch for each product");
        }
        Hashtable<String, LinkedList<TimeLineSegment>> tbl = new Hashtable<String, LinkedList<TimeLineSegment>>();
        for (TimeLineSegment segment : result) {
            String versionKey = segment.getTimeLine().getVersionKey();
            LinkedList<TimeLineSegment> l = (LinkedList<TimeLineSegment>)tbl.get(versionKey);
            if (l == null) {
                l = new LinkedList<TimeLineSegment>();
                tbl.put(versionKey, l);
            }
            l.add(segment);
        }
        result = new LinkedList();
        for (List segments : tbl.values()) {
            TimeLineSegment seg1 = (TimeLineSegment)segments.remove(0);
            Version seg1Version = new Version(seg1.getVersion());
            String versionKey = seg1.getTimeLine().getVersionKey();
            Version nodeVersion = new Version((String)nodeProperties.get(versionKey));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTimeLineSegments", new Object[]{"finding preferred segment", versionKey, seg1});
            }
            while (segments.size() > 0) {
                int nodeSeg1Compare;
                TimeLineSegment seg2 = (TimeLineSegment)segments.remove(0);
                Version seg2Version = new Version(seg2.getVersion());
                int segCompare = seg1Version.compareTo(seg2Version);
                if (segCompare == 0) {
                    Properties seg1Props = seg1.getTimeLine().getProductCapabilities();
                    Properties seg2Props = seg2.getTimeLine().getProductCapabilities();
                    if (seg2Props.size() > seg1Props.size()) {
                        seg1 = seg2;
                        seg1Version = seg2Version;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getTimeLineSegments", new Object[]{"same segment version; preferred segment", seg1});
                    continue;
                }
                if (segCompare > 0) {
                    TimeLineSegment tmpSegment = seg1;
                    seg1 = seg2;
                    seg2 = tmpSegment;
                    Version tmpVersion = seg1Version;
                    seg1Version = seg2Version;
                    seg2Version = tmpVersion;
                    segCompare = -1;
                }
                if ((nodeSeg1Compare = nodeVersion.compareTo(seg1Version)) <= 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getTimeLineSegments", new Object[]{"nodeVersion <= seg1Version < seg2Version; preferred segment", seg1});
                    continue;
                }
                int nodeSeg2Compare = nodeVersion.compareTo(seg2Version);
                if (nodeSeg2Compare < 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getTimeLineSegments", new Object[]{"seg1Version < nodeVersion < seg2Version; preferred segment", seg1});
                    continue;
                }
                seg1 = seg2;
                seg1Version = seg2Version;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getTimeLineSegments", new Object[]{"seg1Version < seg2Version <= nodeVersion; preferred segment", seg1});
            }
            result.add(seg1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeLineSegments", new Object[]{result});
        }
        return result;
    }

    protected void init(String file) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", file);
        }
        SchemadiffPackage pkg = SchemadiffPackage.eINSTANCE;
        List l = this.loadResources(file);
        for (SchemaDiff diffData : l) {
            this.buildTimeLines(diffData);
        }
        Set set = timeLineCache.entrySet();
        for (Map.Entry entry : set) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeLineCache key", entry.getKey());
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "timeLineCache value", entry.getValue());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    protected void buildTimeLines(SchemaDiff diffData) {
        try {
            EList productDiffs = diffData.getProductDiff();
            for (ProductDiff pDiff : productDiffs) {
                String schema = pDiff.getSchemaType();
                ProductCapability pCap = pDiff.getProductCapability();
                EList configChanges = pDiff.getConfigChange();
                for (ConfigChange change : configChanges) {
                    this.createTimeLine(schema, pCap, change);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected List loadResources(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadResources", uri);
        }
        ArrayList<SchemaDiff> list = new ArrayList<SchemaDiff>();
        ResourceSetImpl resSet = new ResourceSetImpl();
        XMIResourceImpl res = new XMIResourceImpl();
        res.setURI(URI.createURI("SchemaDiff"));
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
            return null;
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".config-schemadiff";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
        if (extensionPoint == null) {
            Tr.error(tc, "Unable to get extension point - " + epid);
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing extension point " + epid);
        }
        HashSet<Long> bundlesProcessed = new HashSet<Long>();
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Bundle bundle;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension " + extensions[i].getUniqueIdentifier());
            }
            if ((bundle = Platform.getBundle((String)extensions[i].getNamespace())) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bundle is null; returning empty list");
                }
                return list;
            }
            long bundleId = bundle.getBundleId();
            Long bundleIdObj = new Long(bundleId);
            if (bundlesProcessed.contains(bundleIdObj)) continue;
            bundlesProcessed.add(bundleIdObj);
            Enumeration e = null;
            try {
                e = bundle.getResources(uri);
            }
            catch (IOException e1) {
                Tr.error(tc, "unable to get resources for bundle " + bundleId, e1);
            }
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                SchemaDiff diff = this.loadSchemadiff(u);
                list.add(diff);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadResources", list);
        }
        return list;
    }

    private SchemaDiff loadSchemadiff(URL uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSchemadiff", uri);
        }
        SchemaDiff result = null;
        try {
            XMLResourceImpl s = new XMLResourceImpl();
            XMLMapImpl xmlMap = new XMLMapImpl();
            HashMap<String, XMLMapImpl> loadOptions = new HashMap<String, XMLMapImpl>(1);
            loadOptions.put("XML_MAP", xmlMap);
            s.setURI(URI.createURI("META-INF/ws-config-schemadiff.xml"));
            InputStream ins = uri.openStream();
            s.load(ins, loadOptions);
            EList content = s.getContents();
            if (content.size() > 0) {
                result = (SchemaDiff)s.getContents().get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Tr.warning(tc, "unable to load META-INF/ws-config-schemadiff in " + uri.getFile(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSchemadiff", result);
        }
        return result;
    }

    static {
        SchemadiffPackage schemaPkg = SchemadiffPackage.eINSTANCE;
        dfac = schemaPkg.getSchemadiffFactory();
    }
}

