/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.schemadiff.ProductCapability;
import com.ibm.ws.management.configservice.schemadiff.ProductProperty;
import com.ibm.ws.management.configservice.schemadiff.Property;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;

public class SPXId {
    private static TraceComponent tc = Tr.register(SPXId.class, "management", "com.ibm.ws.management.resources.configservice");
    private String id;
    private Properties props = new Properties();
    private String versionKey;

    public SPXId(ProductCapability prodCap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SPXId", new Object[]{prodCap});
        }
        this.versionKey = prodCap.getVersionKey();
        this.versionKey = prodCap.getVersionKey();
        EList prodCapProps = prodCap.getProductProperty();
        for (ProductProperty pr : prodCapProps) {
            this.props.put(pr.getName(), pr);
        }
        this.sort(this.props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SPXId");
        }
    }

    private void sort(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sort", props);
        }
        this.id = "%";
        if (props == null || props.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sort - no properties", this.id);
            }
            return;
        }
        TreeMap<Object, Object> prodPropTreeMap = new TreeMap<Object, Object>(props);
        Set<Map.Entry<Object, Object>> entrySet = prodPropTreeMap.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (entry.getValue() instanceof ProductProperty) {
                ProductProperty keyProp = (ProductProperty)entry.getValue();
                this.id = this.id + keyProp.getName() + "=" + keyProp.getValue() + "%";
                continue;
            }
            this.id = this.id + entry.getKey() + "=" + entry.getValue() + "%";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sort", this.id);
        }
    }

    public String toString() {
        return this.id;
    }

    public Properties getSPXProperties() {
        return this.props;
    }

    public boolean match(Properties nodeProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "match", new Object[]{this.props, nodeProperties});
        }
        if (nodeProperties == null) {
            return false;
        }
        if (nodeProperties.get(this.versionKey) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", new Object[]{"node does not contain versionKey", this.versionKey});
            }
            return false;
        }
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            Property prop = (Property)entry.getValue();
            String key = prop.getName();
            String val = prop.getValue();
            String nodeVal = (String)nodeProperties.get(key);
            if (key.equals(this.versionKey)) continue;
            if (val != null) {
                if (val.equals(nodeVal)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "match", new Object[]{"mismatch", key, val, nodeVal});
                }
                return false;
            }
            if (nodeVal == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", new Object[]{"mismatch", key, val, nodeVal});
            }
            return false;
        }
        return true;
    }
}

