/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.ConfigChangeId;
import com.ibm.ws.management.configservice.configdiff.TimeLineDataBase;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegment;
import com.ibm.ws.management.configservice.configdiff.Version;
import java.util.List;
import java.util.Properties;

public class ConfigTimeLineDataBase
extends TimeLineDataBase {
    private static TraceComponent tc = Tr.register(ConfigTimeLineDataBase.class, "management", "com.ibm.ws.management.resources.configservice");
    private String SCHEMADIFF_FILE_NAME = "META-INF/ws-config-schemadiff.xml";
    private static ConfigTimeLineDataBase instance = null;
    private String SCHEMA_TYPE = "config";
    private static String VALIDITY = "validity";
    private static String VALID = "valid";
    private static String REMOVED = "removed";
    private static String DEPRECATED = "deprecated";
    private static String PACKAGE = "package";
    private static String TYPE = "type";
    private static String ATTRIBUTE = "attribute";

    protected ConfigTimeLineDataBase() {
        this.init(this.SCHEMADIFF_FILE_NAME);
    }

    public static ConfigTimeLineDataBase getInstance() {
        if (instance == null) {
            instance = new ConfigTimeLineDataBase();
        }
        return instance;
    }

    public boolean isPackageValid(Properties nodeProperties, String pack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPackageValid", new Object[]{nodeProperties, pack});
        }
        Properties configProps = new Properties();
        configProps.put(PACKAGE, pack);
        ConfigChangeId configId = new ConfigChangeId(this.SCHEMA_TYPE, configProps);
        boolean valid = this.determineValidity(configId, nodeProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPackageValid", new Boolean(valid));
        }
        return valid;
    }

    public boolean isTypeValid(Properties nodeProperties, String pack, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTypeValid", new Object[]{nodeProperties, pack, type});
        }
        Properties configProps = new Properties();
        configProps.put(PACKAGE, pack);
        configProps.put(TYPE, type);
        ConfigChangeId configId = new ConfigChangeId(this.SCHEMA_TYPE, configProps);
        boolean valid = this.determineValidity(configId, nodeProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTypeValid", new Boolean(valid));
        }
        return valid;
    }

    public boolean isAttributeValid(Properties nodeProperties, String pack, String type, String attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAttributeValid", new Object[]{nodeProperties, pack, type, attr});
        }
        Properties configProps = new Properties();
        configProps.put(PACKAGE, pack);
        configProps.put(TYPE, type);
        configProps.put(ATTRIBUTE, attr);
        ConfigChangeId configId = new ConfigChangeId(this.SCHEMA_TYPE, configProps);
        boolean valid = this.determineValidity(configId, nodeProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAttributeValid", new Boolean(valid));
        }
        return valid;
    }

    public boolean determineValidity(ConfigChangeId configId, Properties nodeProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineValidity", new Object[]{configId, nodeProperties});
        }
        if (nodeProperties == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity - nodeProperties is null", new Boolean(true));
            }
            return true;
        }
        List matches = super.getTimeLineSegments(configId, nodeProperties);
        if (matches.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity - no match", new Boolean(true));
            }
            return true;
        }
        TimeLineSegment bestSegment = null;
        String bestValidity = null;
        String versionMsg = "";
        for (TimeLineSegment segment : matches) {
            String validAttr;
            String versionKey = segment.getTimeLine().getVersionKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Version Key: " + versionKey);
            }
            String nodeVersion = (String)nodeProperties.get(versionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Version: " + nodeVersion);
            }
            if (nodeVersion == null || nodeVersion.trim().equals("")) {
                Tr.audit(tc, "Node Version not found, skipping");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TimeLineSegment", segment);
            }
            if ((validAttr = (String)segment.getChangedData().get(VALIDITY)) == null) continue;
            Version nodeVer = new Version(nodeVersion);
            String segmentVersion = segment.getVersion();
            Version segmentVer = new Version(segment.getVersion());
            int compareResult = nodeVer.compareTo(segmentVer);
            if (compareResult >= 0) {
                versionMsg = segmentVersion;
                if (validAttr.equals(VALID)) {
                    bestSegment = segment;
                    bestValidity = VALID;
                    continue;
                }
                if (validAttr.equals(DEPRECATED)) {
                    if (bestSegment != null && VALID.equals(bestValidity)) continue;
                    bestSegment = segment;
                    bestValidity = DEPRECATED;
                    continue;
                }
                if (!validAttr.equals(REMOVED) || bestSegment != null) continue;
                bestSegment = segment;
                bestValidity = REMOVED;
                continue;
            }
            versionMsg = nodeVersion;
            if (validAttr.equals(VALID)) {
                if (bestSegment != null) continue;
                bestSegment = segment;
                bestValidity = REMOVED;
                continue;
            }
            if (validAttr.equals(DEPRECATED)) {
                if (bestSegment != null && VALID.equals(bestValidity)) continue;
                bestSegment = segment;
                bestValidity = VALID;
                continue;
            }
            if (!validAttr.equals(REMOVED) || bestSegment != null && VALID.equals(bestValidity)) continue;
            bestSegment = segment;
            bestValidity = VALID;
        }
        if (bestSegment == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity", new Object[]{bestSegment, new Boolean(true)});
            }
            return true;
        }
        if (VALID.equals(bestValidity)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity", new Object[]{bestSegment, new Boolean(true)});
            }
            return true;
        }
        if (DEPRECATED.equals(bestValidity)) {
            Tr.warning(tc, "ADMG0301W", new Object[]{configId, versionMsg});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity", new Object[]{bestSegment, new Boolean(true)});
            }
            return true;
        }
        if (REMOVED.equals(bestValidity)) {
            Tr.error(tc, "ADMG0302E", new Object[]{configId, versionMsg});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity deprecated", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineValidity", new Object[]{bestSegment, new Boolean(false)});
        }
        return false;
    }
}

