/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManager;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class WorkspaceHelper {
    private static TraceComponent tc = Tr.register(WorkspaceHelper.class, "management", "com.ibm.ws.management.resources.configservice");
    public static final String SESSION = "_WEBSPHERE_CONFIG_SESSION";

    public static WorkSpace getWorkspace(EObject obj) {
        WorkSpace workspace = null;
        Resource res = obj.eResource();
        if (res != null) {
            ResourceSet set = res.getResourceSet();
            RepositoryContext context = WorkspaceHelper.getContext(res);
            if (context != null) {
                workspace = context.getWorkSpace();
            }
        }
        return workspace;
    }

    public static WorkSpace getWorkspace(Session session) throws ConfigServiceException {
        WorkSpace workspace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkspace", session);
        }
        WorkSpaceManager workspaceMan = WorkSpaceManagerFactory.getManager();
        try {
            workspace = session.isShareWorkspace() ? workspaceMan.getWorkSpace(session.getUserName()) : workspaceMan.getWorkSpace(session.toString());
        }
        catch (WorkSpaceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.getWorkspace", (String)"47");
            throw new ConfigServiceException(ex, ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkspace", workspace);
        }
        return workspace;
    }

    public static RepositoryContext getContext(Session session, ConfigDataId id) throws ConfigServiceException {
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        return WorkspaceHelper.getContext(workspace, id);
    }

    public static RepositoryContext getContext(WorkSpace workspace, ConfigDataId id) throws ConfigServiceException {
        RepositoryContext context;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContext", new Object[]{workspace, id});
        }
        try {
            context = workspace.findContext(id.getContextUri());
        }
        catch (WorkSpaceException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.getContext", (String)"69");
            throw new ConfigServiceException(ex, ex.getMessage());
        }
        if (context == null) {
            throw new ConfigDataNotFoundException(MOFUtil.getURI(id).path(), id, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContext", context);
        }
        return context;
    }

    public static RepositoryContext getNodeContext(Session session, String nodeName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeContext, session: " + session + ", nodeName: " + nodeName);
        }
        RepositoryContext nodeContext = null;
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        RepositoryContext rootContext = workspace.getRootContext();
        RepositoryMetaData metadata2 = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType type = metadata2.getContextType("cells");
        try {
            Collection match = rootContext.findContext(type);
            if (match == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNodeContext, cannot find cell context.");
                }
                throw new ConfigServiceException("Cannot find cell context.");
            }
            RepositoryContext cellContext = (RepositoryContext)match.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getNodeContext, found context for cell " + cellContext.getName());
            }
            if ((match = cellContext.findContext("nodes", nodeName)) == null || match.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNodeContext, cannot find node context " + nodeName);
                }
                throw new ConfigServiceException("Cannot find node context for " + nodeName);
            }
            nodeContext = (RepositoryContext)match.iterator().next();
        }
        catch (ConfigServiceException cse) {
            throw cse;
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeContext, got unexpected exception: " + e.getMessage());
            }
            throw new ConfigServiceException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeContext, return node context " + nodeContext.getPath());
        }
        return nodeContext;
    }

    public static DocAccessor getDocAccessor(WorkSpace workspace, ConfigDataId id) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocAccessor", new Object[]{workspace, id});
        }
        RepositoryContext context = WorkspaceHelper.getContext(workspace, id);
        String fileName = MOFUtil.getURI(id).path();
        DocAccessor result = WorkspaceHelper.getDocAccessor(context, fileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDocAccessor", result);
        }
        return result;
    }

    public static DocAccessor getDocAccessorNoCreate(RepositoryContext context, String fileName) throws ConfigServiceException {
        return WorkspaceHelper.getDocAccessorInternal(context, fileName, false);
    }

    public static DocAccessor getDocAccessor(RepositoryContext context, String fileName) throws ConfigServiceException {
        return WorkspaceHelper.getDocAccessorInternal(context, fileName, true);
    }

    private static DocAccessor getDocAccessorInternal(final RepositoryContext context, final String fileName, boolean create) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocAccessor", new Object[]{context, fileName});
        }
        Thread currThread = null;
        ClassLoader origCL = null;
        try {
            currThread = Thread.currentThread();
            origCL = currThread.getContextClassLoader();
            currThread.setContextClassLoader(ExtClassLoader.getInstance());
            Resource res = context.getResourceSet().getResource(URI.createURI(fileName), false);
            if (res == null) {
                if (context.isAvailable(fileName)) {
                    if (!context.isExtracted(fileName)) {
                        if (!RestrictedAccess.isReadable((String)fileName)) {
                            try {
                                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                                ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        context.extract(fileName, false);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException pae) {
                                throw pae.getException();
                            }
                        } else {
                            context.extract(fileName, false);
                        }
                    }
                    res = context.getResourceSet().getResource(URI.createURI(fileName), true);
                } else if (create) {
                    Resource.Factory factory = context.getResourceSet().getResourceFactoryRegistry().getFactory(URI.createURI(fileName));
                    res = factory.createResource(URI.createURI(fileName));
                    context.getResourceSet().getResources().add(res);
                }
            }
            if (res == null) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0505E", new Object[]{fileName}, null);
                throw new Exception(msg);
            }
            res.setTrackingModification(true);
            DocAccessor docAccessor = new DocAccessor(res);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDocAccessor", docAccessor);
            }
            DocAccessor docAccessor2 = docAccessor;
            Object var9_10 = null;
            currThread.setContextClassLoader(origCL);
            return docAccessor2;
        }
        catch (Exception ex) {
            try {
                if (create && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to load document ", fileName);
                }
                throw new ConfigDocumentLoadException(context.getURI() + '/' + fileName, ex);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                currThread.setContextClassLoader(origCL);
                throw throwable;
            }
        }
    }

    public static DocAccessor getDocAccessor(Session session, ConfigDataId id) throws ConfigServiceException {
        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
        return WorkspaceHelper.getDocAccessor(workspace, id);
    }

    public static DocAccessor getDocAccessor(Session session, WorkSpaceFile file) throws ConfigServiceException {
        String fileName;
        String fileURI = file.getURI();
        int index = fileURI.lastIndexOf(fileName = file.getFileName().replace(File.separatorChar, '/'));
        String contextUri = index <= 0 ? "" : fileURI.substring(0, index - 1);
        return WorkspaceHelper.getDocAccessor(session, new ConfigDataId(contextUri, fileName));
    }

    static Collection getScopeContexts(Session session, ObjectName scope) throws ConfigServiceException {
        Collection rootContexts;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getScopeContexts", new Object[]{session, scope});
            }
            Collection policyRootContexts = null;
            try {
                if (scope == null) {
                    block8: {
                        WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
                        RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                        rootContexts = workspace.findContext(metaData.getContextType("cells"));
                        try {
                            policyRootContexts = workspace.findContext(metaData.getContextType("waspolicies"));
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block8;
                            Tr.debug(tc, "No waspolicies context found. Check repository metadata.xml file.");
                        }
                    }
                    if (policyRootContexts != null && policyRootContexts.size() > 0) {
                        rootContexts.addAll(policyRootContexts);
                    }
                    break block9;
                }
                rootContexts = new ArrayList<RepositoryContext>(1);
                rootContexts.add(WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(scope)));
            }
            catch (WorkSpaceException ex) {
                throw new ConfigServiceException(ex, ex.getLocalizedMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeContexts", rootContexts);
        }
        return rootContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EObject getTemplate(WorkSpace workspace, EClassifier typeMetaObj, ObjectName template) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplate", new Object[]{workspace, typeMetaObj, template});
        }
        EObject result = null;
        if (template == null) {
            result = WorkspaceHelper.getTemplate(workspace, typeMetaObj);
        } else {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(template);
            WorkSpace templateWs = workspace;
            Session templateSession = WorkspaceHelper.getConfigSession(template);
            if (templateSession != null) {
                templateWs = WorkspaceHelper.getWorkspace(templateSession);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template workspace", templateWs);
            }
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(templateWs, id);
            Resource resource = docAccessor.getResource();
            synchronized (resource) {
                result = docAccessor.lookup(id);
                if (!typeMetaObj.isInstance(result)) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0021E", new Object[]{TypeRegistry.getTypeShortName(typeMetaObj), TypeRegistry.getTypeShortName(result.eClass())}, null);
                    throw new ConfigServiceException(msg);
                }
                TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)templateWs);
                result = templateMan.getRefObjectHelper().clone(result);
                WorkspaceHelper.clearNameAttribute(result);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", result);
        }
        return result;
    }

    private static EObject getTemplate(WorkSpace workspace, EClassifier typeMetaObj) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplate", new Object[]{workspace, typeMetaObj});
        }
        EObject result = null;
        try {
            TemplateManager templateMan = TemplateManagerFactory.getManager((WorkSpace)workspace);
            RepositoryContext templateContext = templateMan.getRootTemplateContext();
            if (templateContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTemplate", result);
                }
                return result;
            }
            templateContext = templateContext.findContext("default");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateContext", templateContext);
            }
            List files = null;
            files = TypeRegistry.getTypeShortName(typeMetaObj).equals("Server") ? templateContext.getAllList(true) : templateContext.getAllList(false);
            ArrayList<EObject> templates = new ArrayList<EObject>();
            block4: for (WorkSpaceFile file : files) {
                if (!file.getFileName().endsWith(".xml")) continue;
                try {
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(file.getContext(), file.getFileName());
                    Resource res = docAccessor.getResource();
                    EList extent = res.getContents();
                    for (EObject obj : extent) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "root obj", obj);
                        }
                        if (!typeMetaObj.equals(obj.eClass())) continue;
                        templates.add(obj);
                        break block4;
                    }
                }
                catch (Exception ex) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to load templates", "templates" + file.getFileName());
                }
            }
            if (templates.size() == 0) {
                result = null;
            } else {
                result = (EObject)templates.iterator().next();
                RefObjectHelper helper = templateMan.getRefObjectHelper();
                result = helper.clone(result);
                WorkspaceHelper.clearNameAttribute(result);
            }
        }
        catch (Exception ex) {
            throw new ConfigServiceException(ex, ex.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", result);
        }
        return result;
    }

    public static ValidationManager getValidationManager(Session session) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidationManager", session);
        }
        try {
            WorkSpace workspace = WorkspaceHelper.getWorkspace(session);
            ValidationManagerRegistry registry = ValidationHelper.getRegistry();
            ValidationManager validationManager = registry.getValidationManager(workspace);
            if (validationManager == null) {
                ValidationPolicy policy = ValidationHelper.createPolicy();
                policy.setIncludeCross(true);
                policy.setIncludeExtracted(true);
                policy.setIncludeParentChain(true);
                policy.setIncludeLocalSiblings(true);
                policy.setIncludeAll(false);
                validationManager = registry.getValidationManager(workspace, policy, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getValidationManager", validationManager);
            }
            return validationManager;
        }
        catch (ValidationManagerException ex) {
            throw new ConfigServiceException(ex, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0016E", new Object[]{session}, null));
        }
    }

    static boolean isConfigDocument(RepositoryContextType contextType, String fileName) {
        boolean result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConfigDocument", new Object[]{contextType, fileName});
        }
        boolean bl = result = contextType.getChildDocumentType(fileName) != null;
        if (!result) {
            Iterator iter = contextType.getChildContextTypes().iterator();
            while (iter.hasNext() && !(result = WorkspaceHelper.isConfigDocument((RepositoryContextType)iter.next(), fileName))) {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConfigDocument," + result);
        }
        return result;
    }

    public static RepositoryContext getContext(Resource res) {
        ContextResourceSet set = (ContextResourceSet)res.getResourceSet();
        return set.getContext();
    }

    static String getType(Session session, ObjectName name) throws ConfigServiceException {
        String type = ConfigServiceHelper.getConfigDataType(name);
        if (type == null) {
            ConfigDataId id = ConfigServiceHelper.getConfigDataId(name);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, id);
            type = ConfigServiceHelper.getConfigDataType(docAccessor.resolveObjectName(session, id));
        }
        return type;
    }

    static ConfigServiceDelegator getDelegator(Session session, ObjectName name) throws ConfigServiceException {
        ConfigServiceImpl impl = ConfigServiceImpl.getInstance();
        return impl.getDelegator(WorkspaceHelper.getType(session, name));
    }

    static boolean isScopeContext(Session session, ObjectName scope) throws ConfigServiceException {
        ConfigDataId id;
        boolean isContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isScopeContext", new Object[]{session, scope});
        }
        boolean bl = isContext = (id = ConfigServiceHelper.getConfigDataId(scope)).getHref() == null;
        if (!isContext) {
            ConfigServiceDelegator delegator = WorkspaceHelper.getDelegator(session, scope);
            boolean bl2 = isContext = delegator instanceof RootObjectDelegator && ((RootObjectDelegator)delegator).isRootDocumentType();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isScopeContext," + isContext);
        }
        return isContext;
    }

    private static void clearNameAttribute(EObject obj) {
        try {
            EStructuralFeature attrFeature = MOFUtil.getAttributeMetaObj(obj.eClass(), "name", false);
            obj.eUnset(attrFeature);
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
    }

    public static ObjectName createObjectName(ConfigDataId id, String type, String displayName, Session session) {
        ObjectName name = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (displayName != null && (displayName.indexOf("=") > 0 || displayName.indexOf(":") > 0 || displayName.indexOf(",") > 0)) {
            displayName = "\"" + displayName + "\"";
        }
        if (id != null) {
            table.put("_Websphere_Config_Data_Id", id.toString());
        }
        if (type != null) {
            table.put("_Websphere_Config_Data_Type", type);
        }
        if (displayName != null && !displayName.trim().equals("")) {
            table.put("_Websphere_Config_Data_Display_Name", displayName);
        }
        if (session != null && session.toString().trim().length() > 0) {
            table.put(SESSION, session.toString());
        }
        try {
            name = new ObjectName("Websphere", table);
        }
        catch (MalformedObjectNameException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.createObjectName", (String)"171");
        }
        return name;
    }

    public static Session getConfigSession(ObjectName objName) {
        String session = objName.getKeyProperty(SESSION);
        return session == null ? null : new Session(session, true);
    }

    public static boolean containVersion5Memeber(Session session, ObjectName cluster) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containVersion5Member", new Object[]{session, cluster});
        }
        boolean result = false;
        try {
            ConfigServiceImpl cs = ConfigServiceImpl.getInstance();
            List members = (List)cs.getAttribute(session, cluster, "members");
            for (AttributeList member : members) {
                String nodeName = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeName", nodeName);
                }
                if (!(result = MOFUtil.isNodeVersion5(WorkspaceHelper.getWorkspace(session), nodeName))) continue;
                break;
            }
        }
        catch (ConnectorException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", (String)"426");
        }
        catch (AttributeNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", (String)"435");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containVersion5Member" + result);
        }
        return result;
    }

    public static boolean containVersion5DeploymentTarget(Session session, ObjectName deployment) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containVersion5DeploymentTarget", new Object[]{session, deployment});
        }
        boolean result = false;
        try {
            ConfigServiceImpl cs = ConfigServiceImpl.getInstance();
            List targets = (List)cs.getAttribute(session, deployment, "deploymentTargets");
            for (AttributeList target : targets) {
                String name = (String)ConfigServiceHelper.getAttributeValue(target, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", name);
                }
                String type = (String)ConfigServiceHelper.getAttributeValue(target, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type", type);
                }
                if (type.equals("ClusteredTarget")) {
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerCluster", null);
                    ObjectName[] match = cs.queryConfigObjects(session, null, pattern, null);
                    if (match.length <= 0 || !(result = WorkspaceHelper.containVersion5Memeber(session, match[0]))) continue;
                } else {
                    String nodeName = (String)ConfigServiceHelper.getAttributeValue(target, "nodeName");
                    result = MOFUtil.isNodeVersion5(WorkspaceHelper.getWorkspace(session), nodeName);
                    if (!result) continue;
                }
                break;
            }
        }
        catch (ConnectorException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", (String)"426");
        }
        catch (AttributeNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", (String)"435");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containVersion5DeploymentTarget" + result);
        }
        return result;
    }
}

